/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils.xml;

import com.zeitheron.hammercore.utils.xml.XMLElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMLDocument {
    final Document doc;
    final Map<String, XMLElement> elementsById = new HashMap<String, XMLElement>();
    final Map<String, XMLElement[]> elementsByTagName = new HashMap<String, XMLElement[]>();
    final Function<String, XMLElement> elementByIdNew;
    final Function<String, XMLElement[]> elementByTagNameNew;

    public XMLDocument(Document doc) {
        this.doc = doc;
        this.elementByIdNew = name -> new XMLElement(doc.getElementById((String)name));
        this.elementByTagNameNew = name -> {
            ArrayList<XMLElement> elems = new ArrayList<XMLElement>();
            NodeList nl = doc.getElementsByTagName((String)name);
            for (int i = 0; i < nl.getLength(); ++i) {
                elems.add(new XMLElement((Element)nl.item(i)));
            }
            return elems.toArray(new XMLElement[elems.size()]);
        };
    }

    public XMLElement getElementById(String name) {
        return this.elementsById.computeIfAbsent(name, this.elementByIdNew);
    }

    public XMLElement[] getElementsByTagName(String name) {
        return this.elementsByTagName.computeIfAbsent(name, this.elementByTagNameNew);
    }

    public String getTextContent() {
        return this.doc.getTextContent();
    }
}

