/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.net.internal;

import com.zeitheron.hammercore.net.IPacket;
import com.zeitheron.hammercore.net.MainThreaded;
import com.zeitheron.hammercore.net.PacketContext;
import com.zeitheron.hammercore.tile.TileSyncable;
import com.zeitheron.hammercore.utils.StrPos;
import com.zeitheron.hammercore.utils.WorldUtil;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;

@MainThreaded
public class PacketSyncSyncableTile
implements IPacket {
    private String pos;
    private int world;
    private NBTTagCompound nbt;
    private String clazz;

    public PacketSyncSyncableTile() {
    }

    public PacketSyncSyncableTile(TileSyncable tile) {
        this.nbt = tile.func_189517_E_();
        this.pos = StrPos.toStr(tile.func_174877_v());
        this.world = tile.func_145831_w().field_73011_w.getDimension();
        this.clazz = tile.getClass().getName();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("data", (NBTBase)this.nbt);
        nbt.func_74778_a("pos", this.pos);
        nbt.func_74768_a("dim", this.world);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.nbt = nbt.func_74775_l("data");
        this.pos = nbt.func_74779_i("pos");
        this.world = nbt.func_74762_e("dim");
    }

    @Override
    public IPacket execute(Side side, PacketContext net) {
        World world = WorldUtil.getWorld(net, this.world);
        BlockPos pos = StrPos.fromStr(this.pos);
        if (world != null && world.func_175707_a(pos, pos)) {
            TileSyncable sync = WorldUtil.cast(world.func_175625_s(pos), TileSyncable.class);
            if (sync == null) {
                try {
                    sync = (TileSyncable)Class.forName(this.clazz).newInstance();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (sync != null) {
                sync.onPreSync(this.nbt);
                sync.handleUpdateTag(this.nbt);
                sync.onSynced();
            }
        }
        return null;
    }

    static {
        IPacket.handle(PacketSyncSyncableTile.class, PacketSyncSyncableTile::new);
    }
}

