/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.utils.gl;

import com.zeitheron.hammercore.client.utils.RenderUtil;
import com.zeitheron.hammercore.client.utils.gl.IGLWritable;
import com.zeitheron.hammercore.utils.base.Cast;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL31;
import sun.nio.ch.DirectBuffer;

public class GLBuffer {
    public final int buffer = RenderUtil.glTask(() -> GL15.glGenBuffers());
    private boolean disposed = false;
    public int drawType = 35040;
    public int bufferKind = 35345;

    private void dispose() {
        if (this.disposed) {
            return;
        }
        RenderUtil.glTaskAsync(() -> GL15.glDeleteBuffers((int)this.buffer));
        this.disposed = true;
    }

    public void bindBuffer() {
        GL15.glBindBuffer((int)this.bufferKind, (int)this.buffer);
    }

    public void bufferData(FloatBuffer data) {
        RenderUtil.glTask(() -> {
            this.bindBuffer();
            GL15.glBufferData((int)this.bufferKind, (FloatBuffer)data, (int)this.drawType);
        });
    }

    public <T extends IGLWritable> void bufferData(T ... writables) {
        int size = writables[0].getFloatSize() * writables.length;
        FloatBuffer buf = BufferUtils.createFloatBuffer((int)size);
        for (T w : writables) {
            w.writeFloats(buf::put);
        }
        buf.flip();
        this.bufferData(buf);
        if (buf instanceof DirectBuffer) {
            DirectBuffer db = (DirectBuffer)((Object)buf);
            if (db.cleaner() != null) {
                db.cleaner().clean();
            } else {
                Cast.optionally(db.attachment(), DirectBuffer.class).ifPresent(b2 -> {
                    if (b2.cleaner() != null) {
                        b2.cleaner().clean();
                    }
                });
            }
        }
    }

    public void bindToShader(int program, int blockBinding, String bufBlockName) {
        GL31.glUniformBlockBinding((int)program, (int)GL31.glGetUniformBlockIndex((int)program, (CharSequence)bufBlockName), (int)blockBinding);
        GL30.glBindBufferBase((int)this.bufferKind, (int)0, (int)this.buffer);
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

