/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.render.tesr;

import com.zeitheron.hammercore.client.render.item.IItemRender;
import com.zeitheron.hammercore.client.render.item.ItemRenderingHandler;
import com.zeitheron.hammercore.client.utils.DestroyStageTexture;
import com.zeitheron.hammercore.client.utils.RenderBlocks;
import com.zeitheron.hammercore.tile.TileSyncable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import org.lwjgl.opengl.GL11;

public abstract class TESR<T extends TileEntity>
extends TileEntitySpecialRenderer<T>
implements IItemRender {
    protected float destroyProgress;
    protected Minecraft mc = Minecraft.func_71410_x();

    public void bindTo(Class<? extends T> tileClass) {
        ClientRegistry.bindTileEntitySpecialRenderer(tileClass, (TileEntitySpecialRenderer)this);
    }

    public void bindTo(Item item) {
        ItemRenderingHandler.INSTANCE.bindItemRender(item, this);
    }

    public void bindTo(Block block) {
        this.bindTo(Item.func_150898_a((Block)block));
    }

    public void bindTo(Class<? extends T> tileClass, Block block) {
        this.bindTo(tileClass);
        this.bindTo(block);
    }

    protected void translateFromOrientation(double x, double y, double z, EnumFacing facing) {
        int orientation = facing.ordinal();
        if (orientation == 0) {
            GL11.glTranslated((double)(x + 0.5), (double)(y + 1.0), (double)(z + 0.5));
            GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
        } else if (orientation == 1) {
            GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        } else if (orientation == 2) {
            GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 1.0));
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (orientation == 3) {
            GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)z);
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (orientation == 4) {
            GL11.glTranslated((double)(x + 1.0), (double)(y + 0.5), (double)(z + 0.5));
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        } else if (orientation == 5) {
            GL11.glTranslated((double)x, (double)(y + 0.5), (double)(z + 0.5));
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    public final void func_192841_a(T te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        try {
            float progress;
            ResourceLocation destroy = null;
            RayTraceResult over = this.mc.field_71476_x;
            this.destroyProgress = 0.0f;
            if (over != null && over.field_72313_a == RayTraceResult.Type.BLOCK && over.func_178782_a().equals((Object)te.func_174877_v()) && (progress = (this.destroyProgress = Minecraft.func_71410_x().field_71442_b.field_78770_f)) > 0.0f) {
                destroy = DestroyStageTexture.getByProgress(progress);
            }
            this.renderBase(te, null, x, y, z, destroy, alpha);
            this.renderTileEntityAt(te, x, y, z, partialTicks, destroy, alpha);
        }
        catch (Throwable err) {
            err.printStackTrace();
        }
    }

    public final void renderTileEntityFast(T te, double x, double y, double z, float partialTicks, int destroyStage, float partial, BufferBuilder buffer) {
        float progress;
        ResourceLocation destroy = null;
        RayTraceResult over = this.mc.field_71476_x;
        if (over != null && over.field_72313_a == RayTraceResult.Type.BLOCK && over.func_178782_a().equals((Object)te.func_174877_v()) && (progress = Minecraft.func_71410_x().field_71442_b.field_78770_f) > 0.0f) {
            destroy = DestroyStageTexture.getByProgress(progress);
        }
        this.renderTileEntityFast(te, x, y, z, partialTicks, destroy, buffer);
    }

    public boolean canRenderFromNbt() {
        return false;
    }

    public void renderFromNBT(@Nonnull NBTTagCompound nbt, double x, double y, double z, float partialTicks, @Nullable ResourceLocation destroyStage) {
    }

    public void renderFromNBTFast(@Nonnull NBTTagCompound nbt, double x, double y, double z, float partialTicks, @Nullable ResourceLocation destroyStage, BufferBuilder buffer) {
    }

    public void renderTileEntityAt(@Nonnull T te, double x, double y, double z, float partialTicks, @Nullable ResourceLocation destroyStage, float alpha) {
        if (this.canRenderFromNbt()) {
            this.renderFromNBT(TESR.getNBTFromTile(te), x, y, z, partialTicks, destroyStage);
        }
    }

    public void renderTileEntityFast(@Nonnull T te, double x, double y, double z, float partialTicks, @Nullable ResourceLocation destroyStage, BufferBuilder buffer) {
        if (this.canRenderFromNbt()) {
            this.renderFromNBTFast(TESR.getNBTFromTile(te), x, y, z, partialTicks, destroyStage, buffer);
        }
    }

    @Override
    public void renderItem(ItemStack item) {
        NBTTagCompound nbt;
        this.renderBase(null, item, 0.0, 0.0, 0.0, null, 1.0f);
        if (this.canRenderFromNbt() && (nbt = TESR.getNBTFromItemStack(item)) != null) {
            this.renderFromNBT(nbt, 0.0, 0.0, 0.0, 0.0f, null);
        }
    }

    public void renderBase(@Nullable T tile, @Nullable ItemStack stack, double x, double y, double z, @Nullable ResourceLocation destroyStage, float alpha) {
    }

    public static NBTTagCompound getNBTFromTile(TileEntity tile) {
        if (tile instanceof TileSyncable) {
            NBTTagCompound nbt = new NBTTagCompound();
            ((TileSyncable)tile).writeNBT(nbt);
            return nbt;
        }
        return tile.serializeNBT();
    }

    @Nullable
    public static NBTTagCompound getNBTFromItemStack(ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags != null) {
            tags = tags.func_74775_l("BlockEntityTag");
        }
        if (tags != null && !tags.func_82582_d()) {
            return tags.func_74775_l("Tags");
        }
        return null;
    }

    protected int getBrightnessForRB(T te, RenderBlocks rb) {
        return te != null ? rb.setLighting(te.func_145831_w(), te.func_174877_v()) : rb.setLighting((World)Minecraft.func_71410_x().field_71441_e, Minecraft.func_71410_x().field_71439_g.func_180425_c());
    }
}

