/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.asm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

class ObjectWebUtils {
    ObjectWebUtils() {
    }

    public static ClassNode loadClass(byte[] data) {
        ClassReader reader = new ClassReader(data);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        return node;
    }

    public static ClassNode loadClass(InputStream stream) throws IOException {
        ClassReader reader = new ClassReader(stream);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        return node;
    }

    public static ClassNode loadClass(File file) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        ClassNode node = ObjectWebUtils.loadClass(stream);
        stream.close();
        return node;
    }

    public static ClassNode loadClass(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        try {
            conn.setDoInput(true);
            conn.connect();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        InputStream stream = conn.getInputStream();
        ClassNode node = ObjectWebUtils.loadClass(stream);
        stream.close();
        return node;
    }

    public static byte[] writeClassToByteArray(ClassNode node) {
        ClassWriter writer = new ClassWriter(3);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static void writeClassToOutputStream(ClassNode node, OutputStream stream) throws IOException {
        stream.write(ObjectWebUtils.writeClassToByteArray(node));
    }

    public static void writeClassToFile(ClassNode node, File file) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        ObjectWebUtils.writeClassToOutputStream(node, os);
        os.close();
    }

    public static void writeClassToURL(ClassNode node, URL url) throws IOException {
        URLConnection conn = url.openConnection();
        try {
            conn.setDoOutput(true);
            conn.connect();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        OutputStream os = conn.getOutputStream();
        ObjectWebUtils.writeClassToOutputStream(node, os);
        os.close();
    }
}

