/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.asm;

import com.zeitheron.hammercore.api.events.DisableLightingEvent;
import com.zeitheron.hammercore.api.events.EnableLightingEvent;
import com.zeitheron.hammercore.api.events.EntityItemHurtEvent;
import com.zeitheron.hammercore.api.events.PostRenderChunkEvent;
import com.zeitheron.hammercore.api.events.PreRenderChunkEvent;
import com.zeitheron.hammercore.api.events.ProfilerEndEvent;
import com.zeitheron.hammercore.api.events.ProfilerEndStartEvent;
import com.zeitheron.hammercore.api.events.ProfilerStartEvent;
import com.zeitheron.hammercore.api.events.RenderEntityEvent;
import com.zeitheron.hammercore.api.events.RenderTileEntityEvent;
import com.zeitheron.hammercore.api.tile.ITickSlipAwareTile;
import com.zeitheron.hammercore.api.tile.ITickSlipPreventTile;
import com.zeitheron.hammercore.cfg.tickslip.TickSlipConfig;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class McHooks {
    public static final boolean[] FEATURES = new boolean[EnumMcHook.values().length];

    public static void enableFeature(EnumMcHook hook) {
        McHooks.FEATURES[hook.ordinal()] = true;
    }

    public static void tickTile(ITickable tickable) {
        if (tickable instanceof TileEntity && !(tickable instanceof ITickSlipPreventTile)) {
            long val;
            TileEntity tile = (TileEntity)tickable;
            int rate = TickSlipConfig.getTickRate(tile.func_145838_q());
            if (tile instanceof ITickSlipAwareTile) {
                ((ITickSlipAwareTile)tile).handleInterpolations(rate);
            }
            if ((val = tile.func_145831_w().func_72820_D() + tile.func_174877_v().func_177986_g() * 36824626L) % (long)rate == 0L) {
                tickable.func_73660_a();
            }
        } else {
            tickable.func_73660_a();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void preRenderChunk(RenderChunk c) {
        if (FEATURES[0]) {
            MinecraftForge.EVENT_BUS.post((Event)new PreRenderChunkEvent(c));
        }
    }

    public static void profilerStart(String section) {
        if (FEATURES[1]) {
            MinecraftForge.EVENT_BUS.post((Event)new ProfilerStartEvent(section));
        }
    }

    public static void profilerEndStart(String section) {
        if (FEATURES[2]) {
            MinecraftForge.EVENT_BUS.post((Event)new ProfilerEndStartEvent(section));
        }
    }

    public static void profilerEnd() {
        if (FEATURES[3]) {
            MinecraftForge.EVENT_BUS.post((Event)ProfilerEndEvent.INSTANCE);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderEntity(Entity e) {
        if (FEATURES[4]) {
            MinecraftForge.EVENT_BUS.post((Event)new RenderEntityEvent(e));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderTileEntity(TileEntity e) {
        if (FEATURES[5]) {
            MinecraftForge.EVENT_BUS.post((Event)new RenderTileEntityEvent(e));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void enableLighting() {
        if (FEATURES[6]) {
            MinecraftForge.EVENT_BUS.post((Event)EnableLightingEvent.INSTANCE);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void disableLighting() {
        if (FEATURES[7]) {
            MinecraftForge.EVENT_BUS.post((Event)DisableLightingEvent.INSTANCE);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void postRenderChunk(RenderChunk renderChunk, BlockRenderLayer layer, float x, float y, float z, BufferBuilder bufferBuilderIn, CompiledChunk compiledChunkIn) {
        if (FEATURES[8]) {
            MinecraftForge.EVENT_BUS.post((Event)new PostRenderChunkEvent(renderChunk, layer, x, y, z, bufferBuilderIn, compiledChunkIn));
        }
    }

    public static boolean attackEntityItem(EntityItem item, DamageSource src, float amount) {
        if (FEATURES[9]) {
            EntityItemHurtEvent e = new EntityItemHurtEvent(item, src, amount);
            return MinecraftForge.EVENT_BUS.post((Event)e);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void setTransform(ItemCameraTransforms.TransformType t) {
        client.itemTransformType = t;
    }

    @SideOnly(value=Side.CLIENT)
    public static ItemCameraTransforms.TransformType getItemTransformType() {
        return client.itemTransformType;
    }

    @SideOnly(value=Side.CLIENT)
    public static class client {
        public static ItemCameraTransforms.TransformType itemTransformType = ItemCameraTransforms.TransformType.NONE;
    }

    public static enum EnumMcHook {
        PRE_RENDER_CHUNK,
        PROFILER_START,
        PROFILER_END_START,
        PROFILER_END,
        RENDER_ENTITY,
        RENDER_TILE_ENTITY,
        ENABLE_LIGHTING,
        DISABLE_LIGHTING,
        POST_RENDER_CHUNK,
        ENTITY_ITEM_HURT;

    }
}

