/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.internal.fluid;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.FluidTankPropertiesWrapper;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class Tank
extends FluidTank {
    private int maxTransfer;
    private List<String> allowedFluids;

    public Tank(int capacity, List<String> allowedFluids) {
        this(capacity, capacity, allowedFluids);
    }

    public Tank(int capacity, int maxTransfer, List<String> allowedFluids) {
        super(capacity);
        this.maxTransfer = maxTransfer;
        this.allowedFluids = allowedFluids;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return fluid != null && this.canFillFluidType(fluid.getFluid());
    }

    public boolean canFillFluidType(Fluid fluid) {
        return fluid != null && (this.allowedFluids == null || this.allowedFluids.contains(fluid.getName()));
    }

    public void changeFluidStored(Fluid fluid, int amount) {
        int newAmount = this.getFluidAmount() + amount;
        if (fluid == null || newAmount <= 0) {
            this.fluid = null;
            return;
        }
        if (newAmount > this.capacity) {
            newAmount = this.capacity;
        }
        this.fluid = new FluidStack(fluid, newAmount);
    }

    public void changeFluidAmount(int amount) {
        int newAmount = this.getFluidAmount() + amount;
        if (this.fluid == null || newAmount <= 0) {
            this.fluid = null;
            return;
        }
        if (newAmount > this.capacity) {
            newAmount = this.capacity;
        }
        this.fluid = new FluidStack(this.fluid, newAmount);
    }

    public void setFluidStored(Fluid fluid, int amount) {
        if (amount <= 0) {
            this.fluid = null;
            return;
        }
        this.fluid = new FluidStack(fluid, amount);
        if (this.getFluidAmount() > this.capacity) {
            this.fluid = new FluidStack(this.fluid, this.capacity);
        } else if (this.getFluidAmount() < 0) {
            this.fluid = null;
        }
    }

    public void setFluidStored(FluidStack stack) {
        if (stack == null || stack.amount <= 0) {
            this.fluid = null;
            return;
        }
        if (stack.amount > this.capacity) {
            stack.amount = this.capacity;
        }
        this.fluid = stack;
    }

    public void setFluidAmount(int amount) {
        if (this.fluid == null) {
            return;
        }
        if (amount <= 0) {
            this.fluid = null;
            return;
        }
        if (amount > this.capacity) {
            amount = this.capacity;
        }
        this.fluid.amount = amount;
    }

    public void setTankCapacity(int newCapacity) {
        if (newCapacity == this.capacity || newCapacity <= 0) {
            return;
        }
        this.capacity = newCapacity;
        if (newCapacity < this.getFluidAmount()) {
            this.setFluidAmount(newCapacity);
        }
    }

    public void mergeTank(Tank other) {
        if (this.fluid == null) {
            this.fluid = other.fluid;
        } else if (!this.fluid.isFluidEqual(other.getFluid())) {
            this.setFluidStored(null);
            return;
        }
        this.setFluidAmount(this.getFluidAmount() + other.getFluidAmount());
        this.setTankCapacity(this.capacity + other.capacity);
    }

    public void setMaxTransfer(int newMaxTransfer) {
        if (newMaxTransfer < 0) {
            return;
        }
        if (newMaxTransfer != this.maxTransfer) {
            this.maxTransfer = newMaxTransfer;
        }
    }

    public boolean isEmpty() {
        return this.getFluidAmount() == 0;
    }

    public boolean isFull() {
        return this.getFluidAmount() >= this.capacity;
    }

    public IFluidTankProperties getFluidTankProperties() {
        return new FluidTankPropertiesWrapper((FluidTank)this);
    }

    public String getFluidName() {
        if (this.fluid == null) {
            return "nullFluid";
        }
        return this.fluid.getFluid().getName();
    }

    public String getFluidLocalizedName() {
        if (this.fluid == null) {
            return "";
        }
        return this.fluid.getLocalizedName();
    }

    public final NBTTagCompound writeToNBT(NBTTagCompound nbt, int tankNumber) {
        NBTTagCompound tankTag = new NBTTagCompound();
        if (this.getFluidAmount() < 0) {
            this.fluid = null;
        }
        tankTag.func_74768_a("fluidAmount", this.getFluidAmount());
        tankTag.func_74778_a("fluidName", this.getFluidName());
        nbt.func_74782_a("tank" + tankNumber, (NBTBase)tankTag);
        return nbt;
    }

    public final Tank readFromNBT(NBTTagCompound nbt, int tankNumber) {
        if (nbt.func_74764_b("tank" + tankNumber)) {
            NBTTagCompound tankTag = nbt.func_74775_l("tank" + tankNumber);
            this.fluid = tankTag.func_74779_i("fluidName").equals("nullFluid") || tankTag.func_74762_e("fluidAmount") == 0 ? null : new FluidStack(FluidRegistry.getFluid((String)tankTag.func_74779_i("fluidName")), tankTag.func_74762_e("fluidAmount"));
            if (this.getFluidAmount() > this.capacity) {
                this.fluid.amount = this.capacity;
            }
        }
        return this;
    }

    public void readInfo(TankInfo info) {
        if (info.name().equals("nullFluid")) {
            this.setFluid(null);
        } else {
            this.setFluid(new FluidStack(FluidRegistry.getFluid((String)info.name()), info.amount()));
        }
    }

    public static class TankInfo {
        private String name;
        private int amount;

        public TankInfo(Tank tank) {
            this.name = tank.getFluidName();
            this.amount = tank.getFluidAmount();
        }

        private TankInfo(String name, int amount) {
            this.name = name;
            this.amount = amount;
        }

        public String name() {
            return this.name;
        }

        public int amount() {
            return this.amount;
        }

        public static List<TankInfo> infoList(List<Tank> tanks) {
            ArrayList<TankInfo> infoList = new ArrayList<TankInfo>();
            if (tanks == null || tanks.isEmpty()) {
                return infoList;
            }
            for (Tank tank : tanks) {
                infoList.add(new TankInfo(tank));
            }
            return infoList;
        }

        public static List<TankInfo> readBuf(ByteBuf buf, byte numberOfTanks) {
            ArrayList<TankInfo> infoList = new ArrayList<TankInfo>();
            for (byte i = 0; i < numberOfTanks; i = (byte)(i + 1)) {
                infoList.add(new TankInfo(ByteBufUtils.readUTF8String((ByteBuf)buf), buf.readInt()));
            }
            return infoList;
        }

        public void writeBuf(ByteBuf buf) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
            buf.writeInt(this.amount);
        }
    }
}

