/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.internal.energy;

import nc.config.NCConfig;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyStorage
implements IEnergyStorage {
    private int energyStored;
    private int energyCapacity;
    private int maxTransfer;

    public EnergyStorage(int capacity) {
        this(capacity, capacity);
    }

    public EnergyStorage(int capacity, int maxTransfer) {
        this.setStorageCapacity(capacity);
        this.setMaxTransfer(maxTransfer);
    }

    public EnergyStorage(int capacity, int maxTransfer, int energy) {
        this(capacity, maxTransfer);
        this.setEnergyStored(energy);
    }

    public int getEnergyStored() {
        return this.energyStored;
    }

    public int getMaxEnergyStored() {
        return this.energyCapacity;
    }

    public int getMaxTransfer() {
        return this.maxTransfer;
    }

    public boolean canReceive() {
        return true;
    }

    public boolean canExtract() {
        return true;
    }

    public int receiveEnergy(int receive, boolean simulated) {
        int energyReceived = Math.min(this.energyCapacity - this.energyStored, Math.min(this.maxTransfer, receive));
        if (!simulated) {
            this.changeEnergyStored(energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(int extract, boolean simulated) {
        int energyExtracted = Math.min(this.energyStored, Math.min(this.maxTransfer, extract));
        if (!simulated) {
            this.changeEnergyStored(-energyExtracted);
        }
        return energyExtracted;
    }

    public void changeEnergyStored(int energy) {
        this.energyStored += energy;
        if (this.energyStored > this.energyCapacity) {
            this.energyStored = this.energyCapacity;
        } else if (this.energyStored < 0) {
            this.energyStored = 0;
        }
    }

    public void setEnergyStored(int energy) {
        this.energyStored = energy;
        if (this.energyStored > this.energyCapacity) {
            this.energyStored = this.energyCapacity;
        } else if (this.energyStored < 0) {
            this.energyStored = 0;
        }
    }

    public void setStorageCapacity(int newCapacity) {
        if (newCapacity == this.energyCapacity || newCapacity <= 0) {
            return;
        }
        this.energyCapacity = Math.max(newCapacity, NCConfig.rf_per_eu);
        if (newCapacity < this.energyStored) {
            this.setEnergyStored(newCapacity);
        }
    }

    public void mergeEnergyStorage(EnergyStorage other) {
        this.setStorageCapacity(this.getMaxEnergyStored() + other.getMaxEnergyStored());
        this.setEnergyStored(this.getEnergyStored() + other.getEnergyStored());
    }

    public void setMaxTransfer(int newMaxTransfer) {
        if (newMaxTransfer < 0) {
            return;
        }
        if (newMaxTransfer != this.maxTransfer) {
            this.maxTransfer = Math.max(newMaxTransfer, NCConfig.rf_per_eu);
        }
    }

    public final NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound storageTag = new NBTTagCompound();
        if (this.energyStored < 0) {
            this.energyStored = 0;
        }
        storageTag.func_74768_a("energy", this.energyStored);
        nbt.func_74782_a("energyStorage", (NBTBase)storageTag);
        return nbt;
    }

    public final EnergyStorage readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("energyStorage")) {
            NBTTagCompound storageTag = nbt.func_74775_l("energyStorage");
            this.energyStored = storageTag.func_74762_e("energy");
            if (this.energyStored > this.energyCapacity) {
                this.energyStored = this.energyCapacity;
            }
        }
        return this;
    }
}

