/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.processor;

import nc.recipe.ProcessorRecipeHandler;

public class ElectrolyserRecipes
extends ProcessorRecipeHandler {
    public ElectrolyserRecipes() {
        super("electrolyser", 0, 1, 0, 4);
    }

    @Override
    public void addRecipes() {
        this.addRecipe(ElectrolyserRecipes.fluidStack("water", 1000), ElectrolyserRecipes.fluidStack("hydrogen", 950), ElectrolyserRecipes.fluidStack("deuterium", 50), ElectrolyserRecipes.fluidStack("oxygen", 500), ElectrolyserRecipes.emptyFluidStack(), 1.5, 1.0);
        this.addRecipe(ElectrolyserRecipes.fluidStack("hydrofluoric_acid", 1000), ElectrolyserRecipes.fluidStack("hydrogen", 500), ElectrolyserRecipes.fluidStack("fluorine", 500), ElectrolyserRecipes.emptyFluidStack(), ElectrolyserRecipes.emptyFluidStack(), 1.0, 0.5);
        this.addRecipe(ElectrolyserRecipes.fluidStack("naoh", 666), ElectrolyserRecipes.fluidStack("sodium", 144), ElectrolyserRecipes.fluidStack("water", 1000), ElectrolyserRecipes.fluidStack("oxygen", 500), ElectrolyserRecipes.emptyFluidStack(), 1.5, 1.5);
        this.addRecipe(ElectrolyserRecipes.fluidStack("koh", 666), ElectrolyserRecipes.fluidStack("potassium", 144), ElectrolyserRecipes.fluidStack("water", 1000), ElectrolyserRecipes.fluidStack("oxygen", 500), ElectrolyserRecipes.emptyFluidStack(), 1.5, 1.5);
        this.addRecipe(ElectrolyserRecipes.fluidStack("alumina", 144), ElectrolyserRecipes.fluidStack("aluminum", 288), ElectrolyserRecipes.fluidStack("oxygen", 3000), ElectrolyserRecipes.emptyFluidStack(), ElectrolyserRecipes.emptyFluidStack(), 2.0, 1.0);
        this.addRecipe(ElectrolyserRecipes.fluidStack("heavywater", 1000), ElectrolyserRecipes.fluidStack("deuterium", 950), ElectrolyserRecipes.fluidStack("tritium", 50), ElectrolyserRecipes.fluidStack("oxygen", 500), ElectrolyserRecipes.emptyFluidStack(), 1.5, 1.0);
        this.addElementFluorideRecipes("thorium", "uranium", "plutonium");
        this.addIsotopeFluorideRecipes("thorium", 230);
        this.addIsotopeFluorideRecipes("uranium", 233, 235, 238);
        this.addIsotopeFluorideRecipes("neptunium", 236, 237);
        this.addIsotopeFluorideRecipes("plutonium", 238, 239, 241, 242);
        this.addIsotopeFluorideRecipes("americium", 241, 242, 243);
        this.addIsotopeFluorideRecipes("curium", 243, 245, 246, 247);
        this.addIsotopeFluorideRecipes("berkelium", 247, 248);
        this.addIsotopeFluorideRecipes("californium", 249, 250, 251, 252);
        this.addRecipe(ElectrolyserRecipes.fluidStack("fuel_tbu_fluoride", 144), ElectrolyserRecipes.fluidStack("fuel_tbu", 144), ElectrolyserRecipes.fluidStack("fluorine", 1000), ElectrolyserRecipes.emptyFluidStack(), ElectrolyserRecipes.emptyFluidStack(), 0.5, 1.0);
        this.addRecipe(ElectrolyserRecipes.fluidStack("depleted_fuel_tbu_fluoride", 144), ElectrolyserRecipes.fluidStack("depleted_fuel_tbu", 144), ElectrolyserRecipes.fluidStack("fluorine", 1000), ElectrolyserRecipes.emptyFluidStack(), ElectrolyserRecipes.emptyFluidStack(), 0.5, 1.0);
        this.addFissionFuelFluorideRecipes("eu", 233, 235);
        this.addFissionFuelFluorideRecipes("en", 236);
        this.addFissionFuelFluorideRecipes("ep", 239, 241);
        this.addFissionFuelFluorideRecipes("ea", 242);
        this.addFissionFuelFluorideRecipes("ecm", 243, 245, 247);
        this.addFissionFuelFluorideRecipes("eb", 248);
        this.addFissionFuelFluorideRecipes("ecf", 249, 251);
    }

    public void addElementFluorideRecipes(String ... elements) {
        for (String element : elements) {
            this.addRecipe(ElectrolyserRecipes.fluidStack(element + "_fluoride", 144), ElectrolyserRecipes.fluidStack(element, 144), ElectrolyserRecipes.fluidStack("fluorine", 1000), ElectrolyserRecipes.emptyFluidStack(), ElectrolyserRecipes.emptyFluidStack(), 0.5, 1.0);
        }
    }

    public void addIsotopeFluorideRecipes(String element, int ... types) {
        for (int type : types) {
            this.addRecipe(ElectrolyserRecipes.fluidStack(element + "_" + type + "_fluoride", 144), ElectrolyserRecipes.fluidStack(element + "_" + type, 144), ElectrolyserRecipes.fluidStack("fluorine", 1000), ElectrolyserRecipes.emptyFluidStack(), ElectrolyserRecipes.emptyFluidStack(), 0.5, 1.0);
        }
    }

    public void addFissionFuelFluorideRecipes(String suffix, int ... types) {
        for (int type : types) {
            for (String form : new String[]{"fuel_l", "fuel_h", "depleted_fuel_l", "depleted_fuel_h"}) {
                this.addRecipe(ElectrolyserRecipes.fluidStack(form + suffix + "_" + type + "_fluoride", 144), ElectrolyserRecipes.fluidStack(form + suffix + "_" + type, 144), ElectrolyserRecipes.fluidStack("fluorine", 1000), ElectrolyserRecipes.emptyFluidStack(), ElectrolyserRecipes.emptyFluidStack(), 0.5, 1.0);
            }
        }
    }
}

