/*
 * Decompiled with CFR 0.152.
 */
package nc.radiation.environment;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import nc.config.NCConfig;
import nc.radiation.environment.RadiationEnvironmentInfo;
import nc.tile.radiation.ITileRadiationEnvironment;
import nc.util.FourPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class RadiationEnvironmentHandler {
    private static final ConcurrentMap<FourPos, RadiationEnvironmentInfo> ENVIRONMENT = new ConcurrentHashMap<FourPos, RadiationEnvironmentInfo>();
    private static final ConcurrentMap<FourPos, RadiationEnvironmentInfo> ENVIRONMENT_BACKUP = new ConcurrentHashMap<FourPos, RadiationEnvironmentInfo>();

    @SubscribeEvent
    public void updateRadiationEnvironment(TickEvent.WorldTickEvent event) {
        if (!NCConfig.radiation_enabled_public) {
            return;
        }
        if (event.phase != TickEvent.Phase.END || event.side == Side.CLIENT || !(event.world instanceof WorldServer)) {
            return;
        }
        int dim = event.world.field_73011_w.getDimension();
        int count = Math.min((1 + NCConfig.radiation_world_chunks_per_tick) / 2, ENVIRONMENT.size());
        Iterator environmentIter = ENVIRONMENT.entrySet().iterator();
        while (count > 0) {
            Map.Entry environmentEntry;
            --count;
            if (!environmentIter.hasNext() || (environmentEntry = environmentIter.next()) == null) break;
            FourPos pos = (FourPos)environmentEntry.getKey();
            RadiationEnvironmentInfo info = (RadiationEnvironmentInfo)environmentEntry.getValue();
            if (pos.getDimension() == dim) {
                for (Map.Entry infoEntry : info.tileMap.entrySet()) {
                    ((ITileRadiationEnvironment)infoEntry.getValue()).handleRadiationEnvironmentInfo(info);
                }
            }
            ENVIRONMENT.remove(pos);
            ENVIRONMENT_BACKUP.put(pos, info);
        }
        if (ENVIRONMENT.isEmpty()) {
            ENVIRONMENT.putAll(ENVIRONMENT_BACKUP);
            ENVIRONMENT_BACKUP.clear();
        }
    }

    public static void addTile(FourPos pos, ITileRadiationEnvironment tile) {
        RadiationEnvironmentInfo newInfo = new RadiationEnvironmentInfo(pos, tile);
        if (!ENVIRONMENT.containsKey(pos)) {
            ENVIRONMENT.put(pos, newInfo);
        } else {
            ((RadiationEnvironmentInfo)ENVIRONMENT.get(pos)).addToTileMap(tile);
        }
    }

    public static void removeTile(ITileRadiationEnvironment tile) {
        Iterator infoIterator = ENVIRONMENT.entrySet().iterator();
        while (infoIterator.hasNext()) {
            Map.Entry infoEntry = infoIterator.next();
            if (infoEntry == null || infoEntry.getKey() == null || infoEntry.getValue() == null) {
                infoIterator.remove();
                continue;
            }
            if (tile.getFourPos().getDimension() != ((FourPos)infoEntry.getKey()).getDimension()) continue;
            ((RadiationEnvironmentInfo)infoEntry.getValue()).tileMap.remove(tile.getFourPos());
            if (!((RadiationEnvironmentInfo)infoEntry.getValue()).tileMap.isEmpty()) continue;
            infoIterator.remove();
        }
        Iterator backupInfoIterator = ENVIRONMENT_BACKUP.entrySet().iterator();
        while (backupInfoIterator.hasNext()) {
            Map.Entry infoEntry = backupInfoIterator.next();
            if (infoEntry == null || infoEntry.getKey() == null || infoEntry.getValue() == null) {
                backupInfoIterator.remove();
                continue;
            }
            if (tile.getFourPos().getDimension() != ((FourPos)infoEntry.getKey()).getDimension()) continue;
            ((RadiationEnvironmentInfo)infoEntry.getValue()).tileMap.remove(tile.getFourPos());
            if (!((RadiationEnvironmentInfo)infoEntry.getValue()).tileMap.isEmpty()) continue;
            backupInfoIterator.remove();
        }
    }
}

