/*
 * Decompiled with CFR 0.152.
 */
package nc.network.gui;

import io.netty.buffer.ByteBuf;
import nc.tile.internal.inventory.ItemSorption;
import nc.tile.inventory.ITileInventory;
import nc.util.NCUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class ResetItemSorptionsPacket
implements IMessage {
    boolean messageValid;
    BlockPos pos;
    int slot;
    boolean defaults;

    public ResetItemSorptionsPacket() {
        this.messageValid = false;
    }

    public ResetItemSorptionsPacket(ITileInventory machine, int slot, boolean defaults) {
        this.pos = machine.getTilePos();
        this.slot = slot;
        this.defaults = defaults;
        this.messageValid = true;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
            this.slot = buf.readInt();
            this.defaults = buf.readBoolean();
        }
        catch (IndexOutOfBoundsException ioe) {
            NCUtil.getLogger().catching((Throwable)ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.slot);
        buf.writeBoolean(this.defaults);
    }

    public static class Handler
    implements IMessageHandler<ResetItemSorptionsPacket, IMessage> {
        public IMessage onMessage(ResetItemSorptionsPacket message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.SERVER) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }

        void processMessage(ResetItemSorptionsPacket message, MessageContext ctx) {
            TileEntity tile = ctx.getServerHandler().field_147369_b.func_71121_q().func_175625_s(message.pos);
            if (tile instanceof ITileInventory) {
                ITileInventory machine = (ITileInventory)tile;
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    if (message.defaults) {
                        machine.setItemSorption(side, message.slot, machine.getInventoryConnection(side).getDefaultItemSorption(message.slot));
                        continue;
                    }
                    machine.setItemSorption(side, message.slot, ItemSorption.NON);
                }
                machine.markDirtyAndNotify();
            }
        }
    }
}

