/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.turbine.tile;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.ModCheck;
import nc.config.NCConfig;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.multiblock.turbine.Turbine;
import nc.multiblock.turbine.TurbineDynamoCoilType;
import nc.multiblock.turbine.tile.TileTurbinePartBase;
import nc.multiblock.turbine.tile.TileTurbineRotorBearing;
import nc.tile.energy.ITileEnergy;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.energy.EnergyStorage;
import nc.tile.internal.energy.EnergyTileWrapper;
import nc.tile.internal.energy.EnergyTileWrapperGT;
import nc.tile.passive.ITilePassive;
import nc.util.BlockPosHelper;
import nc.util.EnergyHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergyTile", modid="ic2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="ic2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="ic2")})
public class TileTurbineDynamoCoil
extends TileTurbinePartBase
implements ITileEnergy,
IEnergySource {
    private final EnergyStorage backupStorage = new EnergyStorage(1);
    private final EnergyConnection[] energyConnections = ITileEnergy.energyConnectionAll(EnergyConnection.OUT);
    private final EnergyTileWrapper[] energySides = ITileEnergy.getDefaultEnergySides(this);
    private final EnergyTileWrapperGT[] energySidesGT = ITileEnergy.getDefaultEnergySidesGT(this);
    private boolean ic2reg = false;
    public final TurbineDynamoCoilType coilType;
    public boolean checked = false;
    public boolean isInValidPosition;

    private TileTurbineDynamoCoil(TurbineDynamoCoilType coilType) {
        super(CuboidalPartPositionType.WALL);
        this.coilType = coilType;
    }

    @Override
    public void onMachineAssembled(Turbine controller) {
        this.doStandardNullControllerResponse(controller);
        super.onMachineAssembled(controller);
        if (this.func_145831_w().field_72995_K) {
            return;
        }
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
    }

    public double contributeConductivity(int dynamoCoilCheckCount) {
        EnumFacing flowDir = ((Turbine)this.getMultiblock()).flowDir;
        if (!this.isMultiblockAssembled() || flowDir == null) {
            this.isInValidPosition = false;
            this.checked = true;
            return 0.0;
        }
        switch (this.coilType) {
            case MAGNESIUM: {
                if (dynamoCoilCheckCount != 0) {
                    return 0.0;
                }
                for (EnumFacing dir : BlockPosHelper.getHorizontals(flowDir)) {
                    if (!this.isRotorBearing(dir)) continue;
                    this.isInValidPosition = true;
                    this.checked = true;
                    return this.coilType.getConductivity();
                }
                this.isInValidPosition = false;
                this.checked = true;
                return 0.0;
            }
            case BERYLLIUM: {
                if (dynamoCoilCheckCount != 1) {
                    return 0.0;
                }
                for (EnumFacing dir : BlockPosHelper.getHorizontals(flowDir)) {
                    if (!this.isDynamoCoil(dir, TurbineDynamoCoilType.MAGNESIUM)) continue;
                    this.isInValidPosition = true;
                    this.checked = true;
                    return this.coilType.getConductivity();
                }
                this.isInValidPosition = false;
                this.checked = true;
                return 0.0;
            }
            case ALUMINUM: {
                if (dynamoCoilCheckCount != 4) {
                    return 0.0;
                }
                for (EnumFacing dir : BlockPosHelper.getHorizontals(flowDir)) {
                    if (!this.isDynamoCoilExcluding(dir, TurbineDynamoCoilType.ALUMINUM)) continue;
                    this.isInValidPosition = true;
                    this.checked = true;
                    return this.coilType.getConductivity();
                }
                this.isInValidPosition = false;
                this.checked = true;
                return 0.0;
            }
            case GOLD: {
                if (dynamoCoilCheckCount != 2) {
                    return 0.0;
                }
                for (EnumFacing dir : BlockPosHelper.getHorizontals(flowDir)) {
                    if (!this.isDynamoCoil(dir, TurbineDynamoCoilType.BERYLLIUM)) continue;
                    this.isInValidPosition = true;
                    this.checked = true;
                    return this.coilType.getConductivity();
                }
                this.isInValidPosition = false;
                this.checked = true;
                return 0.0;
            }
            case COPPER: {
                if (dynamoCoilCheckCount != 3) {
                    return 0.0;
                }
                for (EnumFacing dir : BlockPosHelper.getHorizontals(flowDir)) {
                    if (!this.isDynamoCoil(dir, TurbineDynamoCoilType.GOLD)) continue;
                    this.isInValidPosition = true;
                    this.checked = true;
                    return this.coilType.getConductivity();
                }
                this.isInValidPosition = false;
                this.checked = true;
                return 0.0;
            }
            case SILVER: {
                if (dynamoCoilCheckCount != 3) {
                    return 0.0;
                }
                boolean magnesium = false;
                boolean gold = false;
                for (EnumFacing dir : BlockPosHelper.getHorizontals(flowDir)) {
                    if (!magnesium && this.isDynamoCoil(dir, TurbineDynamoCoilType.MAGNESIUM)) {
                        magnesium = true;
                    }
                    if (!gold && this.isDynamoCoil(dir, TurbineDynamoCoilType.GOLD)) {
                        gold = true;
                    }
                    if (!magnesium || !gold) continue;
                    this.isInValidPosition = true;
                    this.checked = true;
                    return this.coilType.getConductivity();
                }
                this.isInValidPosition = false;
                this.checked = true;
                return 0.0;
            }
        }
        this.isInValidPosition = false;
        return 0.0;
    }

    private boolean isRotorBearing(EnumFacing dir) {
        return this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir)) instanceof TileTurbineRotorBearing;
    }

    private boolean isDynamoCoil(EnumFacing dir, TurbineDynamoCoilType coilType) {
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir));
        if (!(tile instanceof TileTurbineDynamoCoil)) {
            return false;
        }
        TileTurbineDynamoCoil dynamoCoil = (TileTurbineDynamoCoil)tile;
        return dynamoCoil.isInValidPosition && dynamoCoil.coilType == coilType;
    }

    private boolean isDynamoCoilExcluding(EnumFacing dir, TurbineDynamoCoilType coilType) {
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir));
        if (!(tile instanceof TileTurbineDynamoCoil)) {
            return false;
        }
        TileTurbineDynamoCoil dynamoCoil = (TileTurbineDynamoCoil)tile;
        return dynamoCoil.isInValidPosition && dynamoCoil.coilType != coilType;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.pushEnergy();
        }
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (ModCheck.ic2Loaded()) {
            this.addTileToENet();
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (ModCheck.ic2Loaded()) {
            this.removeTileFromENet();
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (ModCheck.ic2Loaded()) {
            this.removeTileFromENet();
        }
    }

    @Override
    public EnergyStorage getEnergyStorage() {
        if (!this.isInValidPosition || !this.isMultiblockAssembled()) {
            return this.backupStorage;
        }
        return ((Turbine)this.getMultiblock()).energyStorage;
    }

    @Override
    @Nonnull
    public EnergyConnection[] getEnergyConnections() {
        return this.energyConnections;
    }

    @Override
    public int getEUSourceTier() {
        if (!this.isInValidPosition || !this.isMultiblockAssembled()) {
            return 1;
        }
        return EnergyHelper.getEUTier(((Turbine)this.getMultiblock()).power);
    }

    @Override
    public int getEUSinkTier() {
        return 1;
    }

    @Override
    @Nonnull
    public EnergyTileWrapper[] getEnergySides() {
        return this.energySides;
    }

    @Override
    @Nonnull
    public EnergyTileWrapperGT[] getEnergySidesGT() {
        return this.energySidesGT;
    }

    @Override
    public void pushEnergyToSide(@Nonnull EnumFacing side) {
        IEnergyContainer adjStorageGT;
        if (!this.getEnergyConnection(side).canExtract()) {
            return;
        }
        TileEntity tile = this.getTileWorld().func_175625_s(this.getTilePos().func_177972_a(side));
        if (tile == null || tile instanceof TileTurbinePartBase) {
            return;
        }
        if (tile instanceof ITileEnergy && !((ITileEnergy)tile).getEnergyConnection(side.func_176734_d()).canReceive()) {
            return;
        }
        if (tile instanceof ITilePassive && !((ITilePassive)tile).canPushEnergyTo()) {
            return;
        }
        IEnergyStorage adjStorage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, side.func_176734_d());
        if (adjStorage != null && this.getEnergyStorage().canExtract()) {
            this.getEnergyStorage().extractEnergy(adjStorage.receiveEnergy(this.getEnergyStorage().extractEnergy(this.getEnergyStorage().getMaxEnergyStored(), true), false), false);
            return;
        }
        if (this.getEnergyStorage().getEnergyStored() < NCConfig.rf_per_eu) {
            return;
        }
        if (ModCheck.ic2Loaded() && tile instanceof IEnergySink) {
            this.getEnergyStorage().extractEnergy((int)Math.round(((IEnergySink)tile).injectEnergy(side.func_176734_d(), (double)(this.getEnergyStorage().extractEnergy(this.getEnergyStorage().getMaxEnergyStored(), true) / NCConfig.rf_per_eu), (double)this.getEUSourceTier()) * (double)NCConfig.rf_per_eu), false);
            return;
        }
        if (NCConfig.enable_gtce_eu && ModCheck.gregtechLoaded() && (adjStorageGT = (IEnergyContainer)tile.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, side.func_176734_d())) != null && this.getEnergyStorage().canExtract()) {
            int voltage = MathHelper.func_76125_a((int)(this.getEnergyStorage().getEnergyStored() / NCConfig.rf_per_eu), (int)1, (int)EnergyHelper.getMaxEUFromTier(this.getEUSourceTier()));
            this.getEnergyStorage().extractEnergy((int)Math.min((long)voltage * adjStorageGT.acceptEnergyFromNetwork(side.func_176734_d(), (long)voltage, 1L) * (long)NCConfig.rf_per_eu, Integer.MAX_VALUE), false);
            return;
        }
    }

    @Optional.Method(modid="ic2")
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return this.getEnergyConnection(side).canExtract();
    }

    @Optional.Method(modid="ic2")
    public double getOfferedEnergy() {
        return Math.min(Math.pow(2.0, 2 * this.getSourceTier() + 3), (double)this.getEnergyStorage().extractEnergy(this.getEnergyStorage().getMaxTransfer(), true) / (double)NCConfig.rf_per_eu);
    }

    @Optional.Method(modid="ic2")
    public void drawEnergy(double amount) {
        this.getEnergyStorage().extractEnergy((int)((double)NCConfig.rf_per_eu * amount), false);
    }

    @Optional.Method(modid="ic2")
    public int getSourceTier() {
        return this.getEUSourceTier();
    }

    @Override
    @Optional.Method(modid="ic2")
    public void addTileToENet() {
        if (!this.field_145850_b.field_72995_K && ModCheck.ic2Loaded() && !this.ic2reg) {
            EnergyNet.instance.addTile((TileEntity)this);
            this.ic2reg = true;
        }
    }

    @Override
    @Optional.Method(modid="ic2")
    public void removeTileFromENet() {
        if (!this.field_145850_b.field_72995_K && ModCheck.ic2Loaded() && this.ic2reg) {
            EnergyNet.instance.removeTile((IEnergyTile)this);
            this.ic2reg = false;
        }
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeEnergy(nbt);
        this.writeEnergyConnections(nbt);
        nbt.func_74757_a("isInValidPosition", this.isInValidPosition);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readEnergy(nbt);
        this.readEnergyConnections(nbt);
        this.isInValidPosition = nbt.func_74767_n("isInValidPosition");
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityEnergy.ENERGY || ModCheck.gregtechLoaded() && NCConfig.enable_gtce_eu && capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER) {
            return this.hasEnergySideCapability(side);
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityEnergy.ENERGY) {
            if (this.hasEnergySideCapability(side)) {
                return (T)this.getEnergySide(this.nonNullSide(side));
            }
            return null;
        }
        if (ModCheck.gregtechLoaded() && capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER) {
            if (NCConfig.enable_gtce_eu && this.hasEnergySideCapability(side)) {
                return (T)this.getEnergySideGT(this.nonNullSide(side));
            }
            return null;
        }
        return super.getCapability(capability, side);
    }

    public static class Silver
    extends TileTurbineDynamoCoil {
        public Silver() {
            super(TurbineDynamoCoilType.SILVER);
        }
    }

    public static class Copper
    extends TileTurbineDynamoCoil {
        public Copper() {
            super(TurbineDynamoCoilType.COPPER);
        }
    }

    public static class Gold
    extends TileTurbineDynamoCoil {
        public Gold() {
            super(TurbineDynamoCoilType.GOLD);
        }
    }

    public static class Aluminum
    extends TileTurbineDynamoCoil {
        public Aluminum() {
            super(TurbineDynamoCoilType.ALUMINUM);
        }
    }

    public static class Beryllium
    extends TileTurbineDynamoCoil {
        public Beryllium() {
            super(TurbineDynamoCoilType.BERYLLIUM);
        }
    }

    public static class Magnesium
    extends TileTurbineDynamoCoil {
        public Magnesium() {
            super(TurbineDynamoCoilType.MAGNESIUM);
        }
    }
}

