/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.saltFission;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import nc.config.NCConfig;
import nc.init.NCSounds;
import nc.multiblock.IMultiblockFluid;
import nc.multiblock.IMultiblockPart;
import nc.multiblock.MultiblockBase;
import nc.multiblock.TileBeefBase;
import nc.multiblock.container.ContainerSaltFissionController;
import nc.multiblock.cuboidal.CuboidalMultiblockBase;
import nc.multiblock.network.SaltFissionUpdatePacket;
import nc.multiblock.saltFission.tile.TileSaltFissionController;
import nc.multiblock.saltFission.tile.TileSaltFissionDistributor;
import nc.multiblock.saltFission.tile.TileSaltFissionHeater;
import nc.multiblock.saltFission.tile.TileSaltFissionModerator;
import nc.multiblock.saltFission.tile.TileSaltFissionRedstonePort;
import nc.multiblock.saltFission.tile.TileSaltFissionRetriever;
import nc.multiblock.saltFission.tile.TileSaltFissionVent;
import nc.multiblock.saltFission.tile.TileSaltFissionVessel;
import nc.multiblock.validation.IMultiblockValidator;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.heat.HeatBuffer;
import nc.util.NCUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class SaltFissionReactor
extends CuboidalMultiblockBase<SaltFissionUpdatePacket>
implements IMultiblockFluid {
    protected Set<TileSaltFissionController> controllers = new ObjectOpenHashSet();
    protected Set<TileSaltFissionVent> vents = new ObjectOpenHashSet();
    protected Set<TileSaltFissionVessel> vessels = new ObjectOpenHashSet();
    protected Set<TileSaltFissionHeater> heaters = new ObjectOpenHashSet();
    protected Set<TileSaltFissionModerator> moderators = new ObjectOpenHashSet();
    protected Set<TileSaltFissionDistributor> distributors = new ObjectOpenHashSet();
    protected Set<TileSaltFissionRetriever> retrievers = new ObjectOpenHashSet();
    protected Set<TileSaltFissionRedstonePort> redstonePorts = new ObjectOpenHashSet();
    protected TileSaltFissionController controller;
    public final HeatBuffer heatBuffer = new HeatBuffer(25000L);
    protected static final int BASE_MAX_HEAT = 25000;
    public int comparatorSignal = 0;
    protected int updateCount = 0;
    protected int distributeCount = 0;
    public boolean isReactorOn;
    public boolean computerActivated;
    public double cooling;
    public double heating;
    public double rawEfficiency;
    public double maxRawEfficiency;
    public double heatMult;
    public double maxHeatMult;
    public double coolingEfficiency;
    protected short heaterCheckCount = 0;
    private static final ArrayList<String> STAGE_0_COOLANTS = Lists.newArrayList((Object[])new String[]{"nak", "redstone_nak", "quartz_nak", "glowstone_nak", "lapis_nak", "ender_nak", "cryotheum_nak", "emerald_nak", "magnesium_nak"});
    private static final ArrayList<String> STAGE_1_COOLANTS = Lists.newArrayList((Object[])new String[]{"gold_nak", "diamond_nak", "liquidhelium_nak", "copper_nak", "tin_nak"});
    private static final ArrayList<String> STAGE_2_COOLANTS = Lists.newArrayList((Object[])new String[]{"iron_nak"});

    public SaltFissionReactor(World world) {
        super(world);
    }

    public Set<TileSaltFissionController> getControllers() {
        return this.controllers;
    }

    public Set<TileSaltFissionVent> getVents() {
        return this.vents;
    }

    public Set<TileSaltFissionVessel> getVessels() {
        return this.vessels;
    }

    public Set<TileSaltFissionHeater> getHeaters() {
        return this.heaters;
    }

    public Set<TileSaltFissionModerator> getModerators() {
        return this.moderators;
    }

    public Set<TileSaltFissionDistributor> getDistributors() {
        return this.distributors;
    }

    public Set<TileSaltFissionRetriever> getRetrievers() {
        return this.retrievers;
    }

    public Set<TileSaltFissionRedstonePort> getRedstonePorts() {
        return this.redstonePorts;
    }

    @Override
    protected int getMinimumInteriorLength() {
        return NCConfig.salt_fission_min_size;
    }

    @Override
    protected int getMaximumInteriorLength() {
        return NCConfig.salt_fission_max_size;
    }

    @Override
    public void onAttachedPartWithMultiblockData(IMultiblockPart part, NBTTagCompound data) {
        this.syncDataFrom(data, TileBeefBase.SyncReason.FullSync);
    }

    @Override
    protected void onBlockAdded(IMultiblockPart newPart) {
        if (newPart instanceof TileSaltFissionController) {
            this.controllers.add((TileSaltFissionController)newPart);
        } else if (newPart instanceof TileSaltFissionVent) {
            this.vents.add((TileSaltFissionVent)newPart);
        } else if (newPart instanceof TileSaltFissionVessel) {
            this.vessels.add((TileSaltFissionVessel)newPart);
        } else if (newPart instanceof TileSaltFissionHeater) {
            this.heaters.add((TileSaltFissionHeater)newPart);
        } else if (newPart instanceof TileSaltFissionModerator) {
            this.moderators.add((TileSaltFissionModerator)newPart);
        } else if (newPart instanceof TileSaltFissionDistributor) {
            this.distributors.add((TileSaltFissionDistributor)newPart);
        } else if (newPart instanceof TileSaltFissionRetriever) {
            this.retrievers.add((TileSaltFissionRetriever)newPart);
        } else if (newPart instanceof TileSaltFissionRedstonePort) {
            this.redstonePorts.add((TileSaltFissionRedstonePort)newPart);
        }
    }

    @Override
    protected void onBlockRemoved(IMultiblockPart oldPart) {
        if (oldPart instanceof TileSaltFissionController) {
            this.controllers.remove(oldPart);
        } else if (oldPart instanceof TileSaltFissionVent) {
            this.vents.remove(oldPart);
        } else if (oldPart instanceof TileSaltFissionVessel) {
            this.vessels.remove(oldPart);
        } else if (oldPart instanceof TileSaltFissionHeater) {
            this.heaters.remove(oldPart);
        } else if (oldPart instanceof TileSaltFissionModerator) {
            this.moderators.remove(oldPart);
        } else if (oldPart instanceof TileSaltFissionDistributor) {
            this.distributors.remove(oldPart);
        } else if (oldPart instanceof TileSaltFissionRetriever) {
            this.retrievers.remove(oldPart);
        } else if (oldPart instanceof TileSaltFissionRedstonePort) {
            this.redstonePorts.remove(oldPart);
        }
    }

    @Override
    protected void onMachineAssembled() {
        Iterator<TileSaltFissionController> iterator = this.controllers.iterator();
        while (iterator.hasNext()) {
            TileSaltFissionController contr;
            this.controller = contr = iterator.next();
        }
        this.onReactorFormed();
    }

    @Override
    protected void onMachineRestored() {
        this.onReactorFormed();
    }

    protected void onReactorFormed() {
        this.setIsReactorOn();
        this.heatBuffer.setHeatCapacity(25000 * this.getNumConnectedBlocks());
        this.updateReactorStats();
    }

    @Override
    protected void onMachinePaused() {
    }

    @Override
    protected void onMachineDisassembled() {
        this.isReactorOn = false;
        if (this.controller != null) {
            this.controller.updateBlockState(false);
        }
        this.coolingEfficiency = 0.0;
        this.maxHeatMult = 0.0;
        this.heatMult = 0.0;
        this.maxRawEfficiency = 0.0;
        this.rawEfficiency = 0.0;
        this.heating = 0.0;
        this.cooling = 0.0;
    }

    @Override
    protected boolean isMachineWhole(IMultiblockValidator validatorCallback) {
        if (this.controllers.size() == 0) {
            validatorCallback.setLastError("nuclearcraft.multiblock_validation.no_controller", null, new Object[0]);
            return false;
        }
        if (this.controllers.size() > 1) {
            validatorCallback.setLastError("nuclearcraft.multiblock_validation.too_many_controllers", null, new Object[0]);
            return false;
        }
        return super.isMachineWhole(validatorCallback);
    }

    @Override
    protected void onAssimilate(MultiblockBase assimilated) {
        if (!(assimilated instanceof SaltFissionReactor)) {
            return;
        }
        SaltFissionReactor assimilatedReactor = (SaltFissionReactor)assimilated;
        this.heatBuffer.mergeHeatBuffers(assimilatedReactor.heatBuffer);
    }

    @Override
    protected void onAssimilated(MultiblockBase assimilator) {
    }

    @Override
    protected boolean updateServer() {
        if (this.shouldDistribute()) {
            this.distributeFuel();
        }
        if (this.shouldUpdate()) {
            this.updateReactorStats();
            this.updateRedstonePorts();
        }
        if (this.heatBuffer.isFull() && NCConfig.salt_fission_overheat) {
            this.heatBuffer.setHeatStored(0L);
            this.doMeltdown();
            return true;
        }
        if (this.shouldUpdate()) {
            this.sendUpdateToListeningPlayers();
        }
        this.incrementUpdateCount();
        return true;
    }

    public void setIsReactorOn() {
        boolean oldIsReactorOn = this.isReactorOn;
        boolean bl = this.isReactorOn = (this.isRedstonePowered() || this.computerActivated) && this.isAssembled();
        if (this.isReactorOn != oldIsReactorOn) {
            if (this.controller != null) {
                this.controller.updateBlockState(this.isReactorOn);
            }
            this.sendUpdateToAllPlayers();
        }
    }

    protected boolean isRedstonePowered() {
        if (this.controller != null && this.controller.checkIsRedstonePowered(this.WORLD, this.controller.func_174877_v())) {
            return true;
        }
        for (TileSaltFissionRedstonePort redstonePort : this.redstonePorts) {
            if (!redstonePort.checkIsRedstonePowered(this.WORLD, redstonePort.func_174877_v())) continue;
            return true;
        }
        return false;
    }

    protected void distributeFuel() {
        Tank vesselTank;
        int count;
        if (this.distributors.size() < 1 || this.vessels.size() < 1) {
            return;
        }
        for (TileSaltFissionVessel vessel : this.vessels) {
            vessel.distributedTo = false;
            vessel.retrievedFrom = false;
        }
        int rate = Math.max(1, NCConfig.salt_fission_max_distribution_rate / this.vessels.size());
        block1: for (TileSaltFissionDistributor distributor : this.distributors) {
            count = NCConfig.salt_fission_max_distribution_rate;
            Tank distributorTank = distributor.getTanks().get(0);
            for (TileSaltFissionVessel vessel : this.vessels) {
                if (count < 1 || distributorTank.isEmpty()) continue block1;
                if (vessel.distributedTo) continue;
                vesselTank = vessel.getTanks().get(0);
                distributorTank.drain(vesselTank.fillInternal(distributorTank.drain(rate, false), true), true);
                vessel.distributedTo = true;
                count -= rate;
            }
        }
        block3: for (TileSaltFissionRetriever retriever : this.retrievers) {
            count = NCConfig.salt_fission_max_distribution_rate;
            Tank retrieverTank = retriever.getTanks().get(0);
            for (TileSaltFissionVessel vessel : this.vessels) {
                if (count < 1 || retrieverTank.isFull()) continue block3;
                if (vessel.retrievedFrom) continue;
                vesselTank = vessel.getTanks().get(1);
                vesselTank.drain(retrieverTank.fillInternal(vesselTank.drain(rate, false), true), true);
                vessel.retrievedFrom = true;
                count -= rate;
            }
        }
    }

    protected void updateReactorStats() {
        this.setVesselStats();
        this.doHeaterPlacementChecks();
        this.setCooling();
        this.heatBuffer.changeHeatStored((long)((double)SaltFissionReactor.updateTime() * this.getNetHeatingRate(true)));
        this.setCoolingRate();
    }

    protected void updateRedstonePorts() {
        this.comparatorSignal = (int)MathHelper.func_151237_a((double)(1500.0 / (double)NCConfig.fission_comparator_max_heat * (double)this.heatBuffer.heatStored / (double)this.heatBuffer.heatCapacity), (double)0.0, (double)15.0);
        for (TileSaltFissionRedstonePort redstonePort : this.redstonePorts) {
            if (redstonePort.comparatorSignal == this.comparatorSignal) continue;
            redstonePort.comparatorSignal = this.comparatorSignal;
            this.WORLD.func_175666_e(redstonePort.func_174877_v(), null);
        }
    }

    protected void setVesselStats() {
        for (TileSaltFissionModerator moderator : this.moderators) {
            moderator.isInValidPosition = false;
            moderator.isInModerationLine = false;
        }
        if (this.vessels.size() < 1) {
            this.maxRawEfficiency = 0.0;
            this.rawEfficiency = 0.0;
            this.maxHeatMult = 0.0;
            this.heatMult = 0.0;
            this.heating = 0.0;
        } else {
            double newEfficiency = 0.0;
            double newMaxEfficiency = 0.0;
            double newHeatMult = 0.0;
            double newMaxHeatMult = 0.0;
            double newHeating = 0.0;
            for (TileSaltFissionVessel vessel : this.vessels) {
                vessel.calculateEfficiency();
                newEfficiency += vessel.getEfficiency();
                newMaxEfficiency += vessel.getMaxEfficiency();
                newHeatMult += vessel.getHeatMultiplier();
                newMaxHeatMult += vessel.getMaxHeatMultiplier();
                newHeating += vessel.getProcessHeat();
            }
            this.rawEfficiency = newEfficiency / (double)this.vessels.size();
            this.maxRawEfficiency = newMaxEfficiency / (double)this.vessels.size();
            this.heatMult = newHeatMult / (double)this.vessels.size();
            this.maxHeatMult = newMaxHeatMult / (double)this.vessels.size();
            this.heating = newHeating;
        }
    }

    protected void doHeaterPlacementChecks() {
        for (TileSaltFissionHeater heater : this.heaters) {
            heater.checked = false;
        }
        for (int i = 0; i <= 2; i = (int)((short)(i + 1))) {
            for (TileSaltFissionHeater heater : this.heaters) {
                this.heaterCheckCount = (short)i;
                if (heater.checked) continue;
                heater.checkIsInValidPosition(this.heaterCheckCount);
            }
        }
    }

    protected void setCooling() {
        double newCooling = 0.0;
        for (TileSaltFissionHeater heater : this.heaters) {
            if (!heater.isInValidPosition) continue;
            newCooling += heater.baseProcessCooling;
        }
        this.cooling = newCooling;
    }

    public double getNetHeatingRate(boolean checkIsReactorOn) {
        return this.isReactorOn || !checkIsReactorOn ? this.heating - this.cooling : -this.cooling;
    }

    protected void setCoolingRate() {
        if (this.vessels.size() <= 0 || this.cooling <= 0.0) {
            this.coolingEfficiency = 0.0;
        } else {
            this.coolingEfficiency = this.getNetHeatingRate(false) >= 0.0 ? this.rawEfficiency : this.rawEfficiency * this.heating / this.cooling;
            double heaterEfficiency = !this.isReactorOn && this.coolingEfficiency * (double)this.heatBuffer.heatStored < this.cooling ? this.coolingEfficiency * (double)this.heatBuffer.heatStored / this.cooling : this.coolingEfficiency;
            for (TileSaltFissionHeater heater : this.heaters) {
                heater.reactorCoolingEfficiency = heaterEfficiency;
            }
        }
    }

    protected void doMeltdown() {
        NCUtil.getLogger().info("Molten Salt Reactor meltdown at " + this.getMiddleCoord().toString() + "!");
        Iterator<TileSaltFissionVessel> vesselIterator = this.vessels.iterator();
        while (vesselIterator.hasNext()) {
            TileSaltFissionVessel vessel = vesselIterator.next();
            vesselIterator.remove();
            vessel.doMeltdown();
        }
        Iterator<TileSaltFissionController> controllerIterator = this.controllers.iterator();
        while (controllerIterator.hasNext()) {
            TileSaltFissionController controller = controllerIterator.next();
            controllerIterator.remove();
            controller.doMeltdown();
        }
        this.checkIfMachineIsWhole();
    }

    protected void incrementUpdateCount() {
        ++this.updateCount;
        this.updateCount %= SaltFissionReactor.updateTime();
        ++this.distributeCount;
        this.distributeCount %= SaltFissionReactor.distributeTime();
    }

    protected static int updateTime() {
        return NCConfig.machine_update_rate / 2;
    }

    protected boolean shouldUpdate() {
        return this.updateCount == 0;
    }

    protected static int distributeTime() {
        return 20;
    }

    protected boolean shouldDistribute() {
        return this.distributeCount == 0;
    }

    @Override
    protected void updateClient() {
        if (this.isReactorOn) {
            for (TileSaltFissionVessel vessel : this.vessels) {
                this.playFissionSound(vessel.func_174877_v());
            }
        }
    }

    protected void playFissionSound(BlockPos pos) {
        if (NCConfig.fission_sound_volume == 0.0 || this.vessels.size() <= 0) {
            return;
        }
        double soundRate = Math.min(this.rawEfficiency / (14.0 * (double)NCConfig.salt_fission_max_size * Math.sqrt(this.vessels.size())), 1.0 / (double)this.vessels.size());
        if (this.rand.nextDouble() < soundRate) {
            this.WORLD.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), NCSounds.geiger_tick, SoundCategory.BLOCKS, (float)(1.6 * NCConfig.fission_sound_volume), 1.0f + 0.12f * (this.rand.nextFloat() - 0.5f), false);
        }
    }

    @Override
    protected void syncDataTo(NBTTagCompound data, TileBeefBase.SyncReason syncReason) {
        this.heatBuffer.writeToNBT(data);
        data.func_74768_a("comparatorSignal", this.comparatorSignal);
        data.func_74757_a("isReactorOn", this.isReactorOn);
        data.func_74757_a("computerActivated", this.computerActivated);
        data.func_74780_a("cooling", this.cooling);
        data.func_74780_a("heating", this.heating);
        data.func_74780_a("efficiency", this.rawEfficiency);
        data.func_74780_a("maxEfficiency", this.maxRawEfficiency);
        data.func_74780_a("heatMult", this.heatMult);
        data.func_74780_a("maxHeatMult", this.maxHeatMult);
        data.func_74780_a("coolingRate", this.coolingEfficiency);
    }

    @Override
    protected void syncDataFrom(NBTTagCompound data, TileBeefBase.SyncReason syncReason) {
        this.heatBuffer.readFromNBT(data);
        this.comparatorSignal = data.func_74762_e("comparatorSignal");
        this.isReactorOn = data.func_74767_n("isReactorOn");
        this.computerActivated = data.func_74767_n("computerActivated");
        this.cooling = data.func_74769_h("cooling");
        this.heating = data.func_74769_h("heating");
        this.rawEfficiency = data.func_74769_h("efficiency");
        this.maxRawEfficiency = data.func_74769_h("maxEfficiency");
        this.heatMult = data.func_74769_h("heatMult");
        this.maxHeatMult = data.func_74769_h("maxHeatMult");
        this.coolingEfficiency = data.func_74769_h("coolingRate");
    }

    @Override
    protected SaltFissionUpdatePacket getUpdatePacket() {
        return new SaltFissionUpdatePacket(this.controller.func_174877_v(), this.isReactorOn, this.cooling, this.heating, this.rawEfficiency, this.maxRawEfficiency, this.heatMult, this.maxHeatMult, this.coolingEfficiency, this.heatBuffer.getHeatCapacity(), this.heatBuffer.getHeatStored());
    }

    @Override
    public void onPacket(SaltFissionUpdatePacket message) {
        this.isReactorOn = message.isReactorOn;
        this.cooling = message.cooling;
        this.heating = message.heating;
        this.rawEfficiency = message.rawEfficiency;
        this.heatMult = message.heatMult;
        this.coolingEfficiency = message.coolingEfficiency;
        this.heatBuffer.setHeatCapacity(message.capacity);
        this.heatBuffer.setHeatStored(message.heat);
    }

    public Container getContainer(EntityPlayer player) {
        return new ContainerSaltFissionController(player, this.controller);
    }

    @Override
    public void clearAllFluids() {
        for (TileSaltFissionVent vent : this.vents) {
            vent.clearAllTanks();
        }
        for (TileSaltFissionVessel vessel : this.vessels) {
            vessel.clearAllTanks();
        }
        for (TileSaltFissionHeater heater : this.heaters) {
            heater.clearAllTanks();
        }
        for (TileSaltFissionDistributor distributor : this.distributors) {
            distributor.clearAllTanks();
        }
        for (TileSaltFissionRetriever retriever : this.retrievers) {
            retriever.clearAllTanks();
        }
    }

    @Override
    protected boolean isBlockGoodForInterior(World world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        return true;
    }
}

