/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.network;

import io.netty.buffer.ByteBuf;
import nc.multiblock.IMultiblockFluid;
import nc.multiblock.IMultiblockPart;
import nc.util.NCUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class ClearAllFluidsPacket
implements IMessage {
    boolean messageValid;
    BlockPos pos;

    public ClearAllFluidsPacket() {
        this.messageValid = false;
    }

    public ClearAllFluidsPacket(BlockPos pos) {
        this.pos = pos;
        this.messageValid = true;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        }
        catch (IndexOutOfBoundsException ioe) {
            NCUtil.getLogger().catching((Throwable)ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
    }

    public static class Handler
    implements IMessageHandler<ClearAllFluidsPacket, IMessage> {
        public IMessage onMessage(ClearAllFluidsPacket message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.SERVER) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }

        void processMessage(ClearAllFluidsPacket message, MessageContext ctx) {
            Object multiblock;
            TileEntity tile = ctx.getServerHandler().field_147369_b.func_71121_q().func_175625_s(message.pos);
            if (tile == null) {
                return;
            }
            if (tile instanceof IMultiblockPart && (multiblock = ((IMultiblockPart)tile).getMultiblock()) instanceof IMultiblockFluid) {
                ((IMultiblockFluid)multiblock).clearAllFluids();
            }
        }
    }
}

