/*
 * Decompiled with CFR 0.152.
 */
package nc.gui.element;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import org.lwjgl.opengl.GL11;

public class GuiFluidRenderer {
    private static final Minecraft MC = Minecraft.func_71410_x();

    @Nonnull
    private static TextureAtlasSprite getStillTexture(@Nonnull FluidStack fluidstack) {
        Fluid fluid = fluidstack.getFluid();
        if (fluid == null) {
            return GuiFluidRenderer.getMissingSprite();
        }
        return GuiFluidRenderer.getStillTexture(fluid);
    }

    @Nonnull
    private static TextureAtlasSprite getStillTexture(@Nonnull Fluid fluid) {
        ResourceLocation iconKey = fluid.getStill();
        if (iconKey == null) {
            return GuiFluidRenderer.getMissingSprite();
        }
        TextureAtlasSprite textureExtry = MC.func_147117_R().getTextureExtry(iconKey.toString());
        return textureExtry != null ? textureExtry : GuiFluidRenderer.getMissingSprite();
    }

    @Nonnull
    private static TextureAtlasSprite getMissingSprite() {
        return MC.func_147117_R().func_174944_f();
    }

    public static void renderGuiTank(FluidTank tank, double x, double y, double zLevel, double width, double height) {
        if (tank == null || tank.getFluid() == null) {
            return;
        }
        GuiFluidRenderer.renderGuiTank(tank.getFluid(), tank.getCapacity(), tank.getFluidAmount(), x, y, zLevel, width, height);
    }

    public static void renderGuiTank(@Nullable FluidStack fluid, int capacity, int amount, double x, double y, double zLevel, double width, double height) {
        if (fluid == null || fluid.getFluid() == null || fluid.amount <= 0) {
            return;
        }
        TextureAtlasSprite icon = GuiFluidRenderer.getStillTexture(fluid);
        int renderAmount = (int)Math.max(Math.min(height, (double)amount * height / (double)capacity), 1.0);
        int posY = (int)(y + height - (double)renderAmount);
        GuiFluidRenderer.MC.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        int color = fluid.getFluid().getColor(fluid);
        GL11.glColor3ub((byte)((byte)(color >> 16 & 0xFF)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)));
        GlStateManager.func_179147_l();
        int i = 0;
        while ((double)i < width) {
            for (int j = 0; j < renderAmount; j += 16) {
                int drawWidth = (int)Math.min(width - (double)i, 16.0);
                int drawHeight = Math.min(renderAmount - j, 16);
                int drawX = (int)(x + (double)i);
                int drawY = posY + j;
                double minU = icon.func_94209_e();
                double maxU = icon.func_94212_f();
                double minV = icon.func_94206_g();
                double maxV = icon.func_94210_h();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder buffer = tessellator.func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                buffer.func_181662_b((double)drawX, (double)(drawY + drawHeight), 0.0).func_187315_a(minU, minV + (maxV - minV) * (double)drawHeight / 16.0).func_181675_d();
                buffer.func_181662_b((double)(drawX + drawWidth), (double)(drawY + drawHeight), 0.0).func_187315_a(minU + (maxU - minU) * (double)drawWidth / 16.0, minV + (maxV - minV) * (double)drawHeight / 16.0).func_181675_d();
                buffer.func_181662_b((double)(drawX + drawWidth), (double)drawY, 0.0).func_187315_a(minU + (maxU - minU) * (double)drawWidth / 16.0, minV).func_181675_d();
                buffer.func_181662_b((double)drawX, (double)drawY, 0.0).func_187315_a(minU, minV).func_181675_d();
                tessellator.func_78381_a();
            }
            i += 16;
        }
        GlStateManager.func_179084_k();
    }
}

