/*
 * Decompiled with CFR 0.152.
 */
package forestry.worktable.recipes;

import forestry.api.core.INbtWritable;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.worktable.recipes.MemorizedRecipe;
import java.io.IOException;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RecipeMemory
implements INbtWritable,
IStreamable {
    private static final int capacity = 9;
    private final LinkedList<MemorizedRecipe> memorizedRecipes = new LinkedList();
    private long lastUpdate;

    public RecipeMemory() {
    }

    public RecipeMemory(NBTTagCompound nbt) {
        if (!nbt.func_74764_b("RecipeMemory")) {
            return;
        }
        NBTTagList nbttaglist = nbt.func_150295_c("RecipeMemory", 10);
        for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
            NBTTagCompound recipeNbt = nbttaglist.func_150305_b(j);
            MemorizedRecipe recipe = new MemorizedRecipe(recipeNbt);
            if (recipe.getSelectedRecipe() == null) continue;
            this.memorizedRecipes.add(recipe);
        }
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public void memorizeRecipe(long worldTime, MemorizedRecipe recipe) {
        MemorizedRecipe memory;
        if (recipe.getSelectedRecipe() == null) {
            return;
        }
        this.lastUpdate = worldTime;
        recipe.updateLastUse(this.lastUpdate);
        if (recipe.hasRecipeConflict()) {
            recipe.removeRecipeConflicts();
        }
        if ((memory = this.getExistingMemorizedRecipe(recipe.getSelectedRecipe())) != null) {
            this.updateExistingRecipe(memory, recipe);
            return;
        }
        if (this.memorizedRecipes.size() < 9) {
            this.memorizedRecipes.add(recipe);
        } else {
            MemorizedRecipe oldest = this.getOldestUnlockedRecipe();
            if (oldest != null) {
                this.memorizedRecipes.remove(oldest);
                this.memorizedRecipes.add(recipe);
            }
        }
    }

    private void updateExistingRecipe(MemorizedRecipe existingRecipe, MemorizedRecipe updatedRecipe) {
        if (existingRecipe.isLocked() != updatedRecipe.isLocked()) {
            updatedRecipe.toggleLock();
        }
        int index = this.memorizedRecipes.indexOf(existingRecipe);
        this.memorizedRecipes.set(index, updatedRecipe);
    }

    @Nullable
    private MemorizedRecipe getOldestUnlockedRecipe() {
        MemorizedRecipe oldest = null;
        for (MemorizedRecipe existing : this.memorizedRecipes) {
            if (oldest != null && oldest.getLastUsed() < existing.getLastUsed() || existing.isLocked()) continue;
            oldest = existing;
        }
        return oldest;
    }

    @Nullable
    public MemorizedRecipe getRecipe(int recipeIndex) {
        if (recipeIndex < 0 || recipeIndex >= this.memorizedRecipes.size()) {
            return null;
        }
        return this.memorizedRecipes.get(recipeIndex);
    }

    public ItemStack getRecipeDisplayOutput(int recipeIndex) {
        MemorizedRecipe recipe = this.getRecipe(recipeIndex);
        if (recipe == null) {
            return ItemStack.field_190927_a;
        }
        return recipe.getOutputIcon();
    }

    public boolean isLocked(int recipeIndex) {
        MemorizedRecipe recipe = this.getRecipe(recipeIndex);
        return recipe != null && recipe.isLocked();
    }

    public void toggleLock(long worldTime, int recipeIndex) {
        this.lastUpdate = worldTime;
        if (this.memorizedRecipes.size() > recipeIndex) {
            this.memorizedRecipes.get(recipeIndex).toggleLock();
        }
    }

    @Nullable
    private MemorizedRecipe getExistingMemorizedRecipe(@Nullable IRecipe recipe) {
        if (recipe != null) {
            for (MemorizedRecipe memorizedRecipe : this.memorizedRecipes) {
                if (!memorizedRecipe.hasRecipe(recipe)) continue;
                return memorizedRecipe;
            }
        }
        return null;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (MemorizedRecipe recipe : this.memorizedRecipes) {
            if (recipe == null || recipe.getSelectedRecipe() == null) continue;
            NBTTagCompound recipeNbt = new NBTTagCompound();
            recipe.writeToNBT(recipeNbt);
            nbttaglist.func_74742_a((NBTBase)recipeNbt);
        }
        nbttagcompound.func_74782_a("RecipeMemory", (NBTBase)nbttaglist);
        return nbttagcompound;
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        data.writeStreamables(this.memorizedRecipes);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readData(PacketBufferForestry data) throws IOException {
        data.readStreamables(this.memorizedRecipes, MemorizedRecipe::new);
    }
}

