/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import forestry.api.recipes.ISqueezerManager;
import forestry.api.recipes.ISqueezerRecipe;
import forestry.core.fluids.FluidHelper;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.datastructures.ItemStackMap;
import forestry.factory.recipes.ISqueezerContainerRecipe;
import forestry.factory.recipes.SqueezerContainerRecipe;
import forestry.factory.recipes.SqueezerRecipe;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;

public class SqueezerRecipeManager
implements ISqueezerManager {
    private static final Set<ISqueezerRecipe> recipes = new HashSet<ISqueezerRecipe>();
    public static final ItemStackMap<ISqueezerContainerRecipe> containerRecipes = new ItemStackMap();

    @Override
    public void addRecipe(int timePerItem, NonNullList<ItemStack> resources, FluidStack liquid, ItemStack remnants, int chance) {
        SqueezerRecipe recipe = new SqueezerRecipe(timePerItem, resources, liquid, remnants, (float)chance / 100.0f);
        this.addRecipe(recipe);
    }

    @Override
    public void addRecipe(int timePerItem, ItemStack resources, FluidStack liquid, ItemStack remnants, int chance) {
        NonNullList resourcesList = NonNullList.func_191196_a();
        resourcesList.add((Object)resources);
        this.addRecipe(timePerItem, (NonNullList<ItemStack>)resourcesList, liquid, remnants, chance);
    }

    @Override
    public void addRecipe(int timePerItem, NonNullList<ItemStack> resources, FluidStack liquid) {
        this.addRecipe(timePerItem, resources, liquid, ItemStack.field_190927_a, 0);
    }

    @Override
    public void addRecipe(int timePerItem, ItemStack resources, FluidStack liquid) {
        NonNullList resourcesList = NonNullList.func_191196_a();
        resourcesList.add((Object)resources);
        this.addRecipe(timePerItem, (NonNullList<ItemStack>)resourcesList, liquid);
    }

    @Override
    public void addContainerRecipe(int timePerItem, ItemStack emptyContainer, ItemStack remnants, float chance) {
        containerRecipes.put(emptyContainer, new SqueezerContainerRecipe(emptyContainer, timePerItem, remnants, chance));
    }

    @Nullable
    public static ISqueezerContainerRecipe findMatchingContainerRecipe(ItemStack filledContainer) {
        if (!FluidHelper.isDrainableFilledContainer(filledContainer)) {
            return null;
        }
        return (ISqueezerContainerRecipe)containerRecipes.get(new ItemStack(filledContainer.func_77973_b()));
    }

    @Nullable
    public static ISqueezerRecipe findMatchingRecipe(NonNullList<ItemStack> items) {
        for (ItemStack itemStack : items) {
            ISqueezerRecipe recipe;
            ISqueezerContainerRecipe containerRecipe = SqueezerRecipeManager.findMatchingContainerRecipe(itemStack);
            if (containerRecipe == null || (recipe = containerRecipe.getSqueezerRecipe(itemStack)) == null) continue;
            return recipe;
        }
        for (ISqueezerRecipe recipe : recipes) {
            if (ItemStackUtil.containsSets(recipe.getResources(), items, false, false) <= 0) continue;
            return recipe;
        }
        return null;
    }

    public static boolean canUse(ItemStack itemStack) {
        for (ISqueezerRecipe recipe : recipes) {
            for (ItemStack recipeInput : recipe.getResources()) {
                if (!ItemStackUtil.isCraftingEquivalent(recipeInput, itemStack, true, false)) continue;
                return true;
            }
        }
        return SqueezerRecipeManager.findMatchingContainerRecipe(itemStack) != null;
    }

    @Override
    public boolean addRecipe(ISqueezerRecipe recipe) {
        return recipes.add(recipe);
    }

    @Override
    public boolean removeRecipe(ISqueezerRecipe recipe) {
        return recipes.remove(recipe);
    }

    @Override
    public Set<ISqueezerRecipe> recipes() {
        return Collections.unmodifiableSet(recipes);
    }
}

