/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import forestry.core.inventory.IInvSlot;
import forestry.core.inventory.InvIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class ItemHandlerInventoryManipulator
implements Iterable<IInvSlot> {
    private final IItemHandler inv;

    public ItemHandlerInventoryManipulator(IItemHandler inv) {
        this.inv = inv;
    }

    @Override
    public Iterator<IInvSlot> iterator() {
        return new InvIterator(this.inv);
    }

    @Nullable
    public ItemStack tryAddStack(ItemStack stack) {
        return this.addStack(stack, false);
    }

    @Nullable
    public ItemStack addStack(ItemStack stack) {
        return this.addStack(stack, true);
    }

    public ItemStack removeItem(Predicate<ItemStack> filter) {
        for (IInvSlot slot : this) {
            ItemStack stack = slot.getStackInSlot();
            if (stack.func_190926_b() || !slot.canTakeStackFromSlot(stack) || !filter.test(stack)) continue;
            return slot.decreaseStackInSlot();
        }
        return ItemStack.field_190927_a;
    }

    public boolean transferOneStack(IItemHandler dest, Predicate<ItemStack> filter) {
        return this.transferStacks(dest, filter, true);
    }

    public boolean transferStacks(IItemHandler dest, Predicate<ItemStack> filter) {
        return this.transferStacks(dest, filter, false);
    }

    private boolean transferStacks(IItemHandler dest, Predicate<ItemStack> filter, boolean singleStack) {
        ItemHandlerInventoryManipulator destManipulator = new ItemHandlerInventoryManipulator(dest);
        boolean stacksMoved = false;
        for (int slotIndex = 0; slotIndex < this.inv.getSlots(); ++slotIndex) {
            ItemStack targetStack = this.inv.extractItem(slotIndex, Integer.MAX_VALUE, true);
            if (targetStack.func_190926_b() || !filter.test(targetStack)) continue;
            int extractStackSize = targetStack.func_190916_E();
            ItemStack remaining = destManipulator.tryAddStack(targetStack);
            if (remaining != null) {
                extractStackSize -= remaining.func_190916_E();
            }
            if (extractStackSize <= 0) continue;
            ItemStack extracted = this.inv.extractItem(slotIndex, extractStackSize, false);
            destManipulator.addStack(extracted);
            stacksMoved = true;
            if (!singleStack) continue;
            return true;
        }
        return stacksMoved;
    }

    @Nullable
    protected ItemStack addStack(ItemStack stack, boolean doAdd) {
        if (stack.func_190926_b()) {
            return null;
        }
        stack = stack.func_77946_l();
        ArrayList<IInvSlot> filledSlots = new ArrayList<IInvSlot>(this.inv.getSlots());
        ArrayList<IInvSlot> emptySlots = new ArrayList<IInvSlot>(this.inv.getSlots());
        for (IInvSlot slot : new ItemHandlerInventoryManipulator(this.inv)) {
            if (!slot.canPutStackInSlot(stack)) continue;
            if (slot.getStackInSlot().func_190926_b()) {
                emptySlots.add(slot);
                continue;
            }
            filledSlots.add(slot);
        }
        int injected = 0;
        injected = this.tryPut(filledSlots, stack, injected, doAdd);
        injected = this.tryPut(emptySlots, stack, injected, doAdd);
        stack.func_190918_g(injected);
        return stack;
    }

    private int tryPut(List<IInvSlot> slots, ItemStack stack, int injected, boolean doAdd) {
        if (injected >= stack.func_190916_E()) {
            return injected;
        }
        for (IInvSlot slot : slots) {
            ItemStack stackToInsert = stack.func_77946_l();
            int stackToInsertSize = stack.func_190916_E() - injected;
            stackToInsert.func_190920_e(stackToInsertSize);
            ItemStack remainder = this.inv.insertItem(slot.getIndex(), stackToInsert, !doAdd);
            if (remainder.func_190926_b()) {
                return stack.func_190916_E();
            }
            if ((injected += stackToInsertSize - remainder.func_190916_E()) < stack.func_190916_E()) continue;
            return injected;
        }
        return injected;
    }
}

