/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.widgets;

import forestry.core.gui.GuiForestry;
import forestry.core.gui.widgets.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class WidgetManager {
    public final GuiForestry gui;
    public final Minecraft minecraft;
    protected final List<Widget> widgets = new ArrayList<Widget>();

    public WidgetManager(GuiForestry gui) {
        this.gui = gui;
        this.minecraft = Minecraft.func_71410_x();
    }

    public void add(Widget slot) {
        this.widgets.add(slot);
    }

    public void remove(Widget slot) {
        this.widgets.remove(slot);
    }

    public void clear() {
        this.widgets.clear();
    }

    public List<Widget> getWidgets() {
        return this.widgets;
    }

    @Nullable
    public Widget getAtPosition(int mX, int mY) {
        for (Widget slot : this.widgets) {
            if (!slot.isMouseOver(mX, mY)) continue;
            return slot;
        }
        return null;
    }

    public void drawWidgets() {
        for (Widget slot : this.widgets) {
            slot.draw(0, 0);
        }
    }

    public void updateWidgets(int mouseX, int mouseY) {
        for (Widget slot : this.widgets) {
            slot.update(mouseX, mouseY);
        }
    }

    public void handleMouseClicked(int mouseX, int mouseY, int mouseButton) {
        Widget slot = this.getAtPosition(mouseX - this.gui.getGuiLeft(), mouseY - this.gui.getGuiTop());
        if (slot != null) {
            slot.handleMouseClick(mouseX, mouseY, mouseButton);
        }
    }

    public boolean handleMouseRelease(int mouseX, int mouseY, int eventType) {
        boolean hasToStop = false;
        for (Widget slot : this.widgets) {
            hasToStop |= slot.handleMouseRelease(mouseX - this.gui.getGuiLeft(), mouseY - this.gui.getGuiTop(), eventType);
        }
        return hasToStop;
    }

    public void handleMouseMove(int mouseX, int mouseY, int mouseButton, long time) {
        for (Widget slot : this.widgets) {
            slot.handleMouseMove(mouseX, mouseY, mouseButton, time);
        }
    }
}

