/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import forestry.api.gui.IGuiElement;
import forestry.api.gui.IValueElement;
import forestry.api.gui.IWindowElement;
import forestry.api.gui.events.ElementEvent;
import forestry.api.gui.events.GuiEvent;
import forestry.api.gui.events.GuiEventDestination;
import forestry.api.gui.events.TextEditEvent;
import forestry.core.gui.elements.GuiElement;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiTextField;

public class TextEditElement
extends GuiElement
implements IValueElement<String> {
    private final GuiTextField field;

    public TextEditElement(int xPos, int yPos, int width, int height) {
        super(xPos, yPos, width, height);
        this.field = new GuiTextField(0, Minecraft.func_71410_x().field_71466_p, 0, 0, width, height);
        this.field.func_146185_a(false);
        this.addSelfEventHandler(GuiEvent.KeyEvent.class, event -> {
            String oldText = this.field.func_146179_b();
            this.field.func_146201_a(event.getCharacter(), event.getKey());
            String text = this.field.func_146179_b();
            if (!text.equals(oldText)) {
                this.postEvent(new TextEditEvent((IGuiElement)this, text, oldText), GuiEventDestination.ALL);
            }
        });
        this.addSelfEventHandler(GuiEvent.DownEvent.class, event -> {
            IWindowElement windowElement = this.getWindow();
            this.field.func_146192_a(windowElement.getRelativeMouseX(this), windowElement.getRelativeMouseY(this), event.getButton());
        });
        this.addSelfEventHandler(ElementEvent.GainFocus.class, event -> this.field.func_146195_b(true));
        this.addSelfEventHandler(ElementEvent.LoseFocus.class, event -> this.field.func_146195_b(false));
    }

    public TextEditElement setMaxLength(int maxLength) {
        this.field.func_146203_f(maxLength);
        return this;
    }

    public TextEditElement setValidator(Predicate<String> validator) {
        this.field.func_175205_a(validator::test);
        return this;
    }

    @Override
    public String getValue() {
        return this.field.func_146179_b();
    }

    @Override
    public void setValue(String value) {
        if (!this.field.func_146179_b().equals(value)) {
            this.field.func_146180_a(value);
        }
    }

    @Override
    public void drawElement(int mouseX, int mouseY) {
        this.field.func_146194_f();
    }

    @Override
    public boolean canFocus() {
        return true;
    }

    @Override
    public boolean canMouseOver() {
        return true;
    }
}

