/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.circuits.ISocketable;
import forestry.core.gui.ContainerLiquidTanksHelper;
import forestry.core.gui.ContainerSocketedHelper;
import forestry.core.gui.ContainerTile;
import forestry.core.gui.IContainerLiquidTanks;
import forestry.core.gui.IContainerSocketed;
import forestry.core.tiles.ILiquidTankTile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ContainerLiquidTanksSocketed<T extends TileEntity & ISocketable>
extends ContainerTile<T>
implements IContainerSocketed,
IContainerLiquidTanks {
    private final ContainerSocketedHelper<T> socketedHelper;
    private final ContainerLiquidTanksHelper<T> tanksHelper;

    protected ContainerLiquidTanksSocketed(T tile, InventoryPlayer playerInventory, int xInv, int yInv) {
        super(tile, playerInventory, xInv, yInv);
        this.socketedHelper = new ContainerSocketedHelper<T>(tile);
        this.tanksHelper = new ContainerLiquidTanksHelper<T>(tile);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handlePipetteClickClient(int slot, EntityPlayer player) {
        this.tanksHelper.handlePipetteClickClient(slot, player);
    }

    @Override
    public void handlePipetteClick(int slot, EntityPlayerMP player) {
        this.tanksHelper.handlePipetteClick(slot, player);
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        ((ILiquidTankTile)this.tile).getTankManager().sendTankUpdate(this, this.field_75149_d);
    }

    public void func_75132_a(IContainerListener crafting) {
        super.func_75132_a(crafting);
        ((ILiquidTankTile)this.tile).getTankManager().containerAdded(this, crafting);
    }

    public void func_75134_a(EntityPlayer entityPlayer) {
        super.func_75134_a(entityPlayer);
        ((ILiquidTankTile)this.tile).getTankManager().containerRemoved(this);
    }

    @Override
    public IFluidTank getTank(int slot) {
        return ((ILiquidTankTile)this.tile).getTankManager().getTank(slot);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleChipsetClick(int slot) {
        this.socketedHelper.handleChipsetClick(slot);
    }

    @Override
    public void handleChipsetClickServer(int slot, EntityPlayerMP player, ItemStack itemstack) {
        this.socketedHelper.handleChipsetClickServer(slot, player, itemstack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleSolderingIronClick(int slot) {
        this.socketedHelper.handleSolderingIronClick(slot);
    }

    @Override
    public void handleSolderingIronClickServer(int slot, EntityPlayerMP player, ItemStack itemstack) {
        this.socketedHelper.handleSolderingIronClickServer(slot, player, itemstack);
    }
}

