/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.alleles;

import forestry.api.genetics.EnumTolerance;
import forestry.apiculture.flowers.FlowerProvider;
import forestry.core.genetics.alleles.IAlleleValue;
import java.util.Locale;
import net.minecraft.util.math.Vec3i;

public class EnumAllele {

    public static enum Yield implements IAlleleValue<Float>
    {
        LOWEST(0.025f, true),
        LOWER(0.05f, true),
        LOW(0.1f, true),
        AVERAGE(0.2f, true),
        HIGH(0.3f),
        HIGHER(0.35f),
        HIGHEST(0.4f);

        private final float value;
        private final boolean dominant;

        private Yield(float value) {
            this(value, false);
        }

        private Yield(float value, boolean dominant) {
            this.value = value;
            this.dominant = dominant;
        }

        @Override
        public Float getValue() {
            return Float.valueOf(this.value);
        }

        @Override
        public boolean isDominant() {
            return this.dominant;
        }
    }

    public static enum Tolerance implements IAlleleValue<EnumTolerance>
    {
        NONE,
        BOTH_1(true),
        BOTH_2,
        BOTH_3,
        BOTH_4,
        BOTH_5,
        UP_1(true),
        UP_2,
        UP_3,
        UP_4,
        UP_5,
        DOWN_1(true),
        DOWN_2,
        DOWN_3,
        DOWN_4,
        DOWN_5;

        private final EnumTolerance value = EnumTolerance.values()[this.ordinal()];
        private final boolean dominant;

        private Tolerance() {
            this(false);
        }

        private Tolerance(boolean dominant) {
            this.dominant = dominant;
        }

        public String toString() {
            return super.toString().replace("_", "");
        }

        @Override
        public EnumTolerance getValue() {
            return this.value;
        }

        @Override
        public boolean isDominant() {
            return this.dominant;
        }
    }

    public static enum Territory implements IAlleleValue<Vec3i>
    {
        AVERAGE(9, 6, 9),
        LARGE(11, 8, 11),
        LARGER(13, 12, 13),
        LARGEST(15, 13, 15);

        private final Vec3i area;
        private final boolean dominant;

        private Territory(int x, int y, int z) {
            this(x, y, z, false);
        }

        private Territory(int x, int y, int z, boolean dominant) {
            this.area = new Vec3i(x, y, z);
            this.dominant = dominant;
        }

        @Override
        public Vec3i getValue() {
            return this.area;
        }

        @Override
        public boolean isDominant() {
            return this.dominant;
        }
    }

    public static enum Speed implements IAlleleValue<Float>
    {
        SLOWEST(0.3f, true),
        SLOWER(0.6f, true),
        SLOW(0.8f, true),
        NORMAL(1.0f),
        FAST(1.2f, true),
        FASTER(1.4f),
        FASTEST(1.7f);

        private final float value;
        private final boolean dominant;

        private Speed(float value) {
            this(value, false);
        }

        private Speed(float value, boolean dominant) {
            this.value = value;
            this.dominant = dominant;
        }

        @Override
        public Float getValue() {
            return Float.valueOf(this.value);
        }

        @Override
        public boolean isDominant() {
            return this.dominant;
        }
    }

    public static enum Size implements IAlleleValue<Float>
    {
        SMALLEST(0.3f),
        SMALLER(0.4f),
        SMALL(0.5f),
        AVERAGE(0.6f),
        LARGE(0.75f),
        LARGER(0.9f),
        LARGEST(1.0f);

        private final float value;
        private final boolean dominant;

        private Size(float value) {
            this(value, false);
        }

        private Size(float value, boolean dominant) {
            this.value = value;
            this.dominant = dominant;
        }

        @Override
        public Float getValue() {
            return Float.valueOf(this.value);
        }

        @Override
        public boolean isDominant() {
            return this.dominant;
        }
    }

    public static enum Sappiness implements IAlleleValue<Float>
    {
        LOWEST(Float.valueOf(0.1f), true),
        LOWER(Float.valueOf(0.2f), true),
        LOW(Float.valueOf(0.3f), true),
        AVERAGE(Float.valueOf(0.4f), true),
        HIGH(Float.valueOf(0.6f), true),
        HIGHER(Float.valueOf(0.8f)),
        HIGHEST(Float.valueOf(1.0f));

        private final Float value;
        private final boolean dominant;

        private Sappiness(Float value) {
            this(value, false);
        }

        private Sappiness(Float value, boolean dominant) {
            this.value = value;
            this.dominant = dominant;
        }

        @Override
        public Float getValue() {
            return this.value;
        }

        @Override
        public boolean isDominant() {
            return this.dominant;
        }
    }

    public static enum Saplings implements IAlleleValue<Float>
    {
        LOWEST(0.01f, true),
        LOWER(0.025f, true),
        LOW(0.035f, true),
        AVERAGE(0.05f, true),
        HIGH(0.1f, true),
        HIGHER(0.2f, true),
        HIGHEST(0.3f, true);

        private final float value;
        private final boolean dominant;

        private Saplings(float value) {
            this(value, false);
        }

        private Saplings(float value, boolean dominant) {
            this.value = value;
            this.dominant = dominant;
        }

        @Override
        public Float getValue() {
            return Float.valueOf(this.value);
        }

        @Override
        public boolean isDominant() {
            return this.dominant;
        }
    }

    public static enum Maturation implements IAlleleValue<Integer>
    {
        SLOWEST(10, true),
        SLOWER(7),
        SLOW(5, true),
        AVERAGE(4),
        FAST(3),
        FASTER(2),
        FASTEST(1);

        private final Integer value;
        private final boolean dominant;

        private Maturation(Integer value) {
            this(value, false);
        }

        private Maturation(Integer value, boolean dominant) {
            this.value = value;
            this.dominant = dominant;
        }

        @Override
        public Integer getValue() {
            return this.value;
        }

        @Override
        public boolean isDominant() {
            return this.dominant;
        }
    }

    public static enum Lifespan implements IAlleleValue<Integer>
    {
        SHORTEST(10),
        SHORTER(20, true),
        SHORT(30, true),
        SHORTENED(35, true),
        NORMAL(40),
        ELONGATED(45, true),
        LONG(50),
        LONGER(60),
        LONGEST(70);

        private final Integer value;
        private final boolean dominant;

        private Lifespan(Integer value) {
            this(value, false);
        }

        private Lifespan(Integer value, boolean dominant) {
            this.value = value;
            this.dominant = dominant;
        }

        @Override
        public Integer getValue() {
            return this.value;
        }

        @Override
        public boolean isDominant() {
            return this.dominant;
        }
    }

    public static enum Height implements IAlleleValue<Float>
    {
        SMALLEST(0.25f),
        SMALLER(0.5f),
        SMALL(0.75f),
        AVERAGE(1.0f),
        LARGE(1.25f),
        LARGER(1.5f),
        LARGEST(1.75f),
        GIGANTIC(2.0f);

        private final float value;
        private final boolean dominant;

        private Height(float value) {
            this(value, false);
        }

        private Height(float value, boolean dominant) {
            this.value = value;
            this.dominant = dominant;
        }

        @Override
        public Float getValue() {
            return Float.valueOf(this.value);
        }

        @Override
        public boolean isDominant() {
            return this.dominant;
        }
    }

    public static enum Flowers implements IAlleleValue<FlowerProvider>
    {
        VANILLA("flowersVanilla", true),
        NETHER("flowersNether"),
        CACTI("flowersCacti"),
        MUSHROOMS("flowersMushrooms"),
        END("flowersEnd"),
        JUNGLE("flowersJungle"),
        SNOW("flowersSnow", true),
        WHEAT("flowersWheat", true),
        GOURD("flowersGourd", true);

        private final FlowerProvider value;
        private final boolean dominant;

        private Flowers(String flowerType) {
            this(flowerType, false);
        }

        private Flowers(String flowerType, boolean dominant) {
            String lowercaseName = this.toString().toLowerCase(Locale.ENGLISH);
            this.value = new FlowerProvider(flowerType, "for.flowers." + lowercaseName);
            this.dominant = dominant;
        }

        @Override
        public FlowerProvider getValue() {
            return this.value;
        }

        @Override
        public boolean isDominant() {
            return this.dominant;
        }
    }

    public static enum Flowering implements IAlleleValue<Integer>
    {
        SLOWEST(5, true),
        SLOWER(10),
        SLOW(15),
        AVERAGE(20),
        FAST(25),
        FASTER(30),
        FASTEST(35),
        MAXIMUM(99, true);

        private final Integer value;
        private final boolean dominant;

        private Flowering(Integer value) {
            this(value, false);
        }

        private Flowering(Integer value, boolean dominant) {
            this.value = value;
            this.dominant = dominant;
        }

        @Override
        public Integer getValue() {
            return this.value;
        }

        @Override
        public boolean isDominant() {
            return this.dominant;
        }
    }

    public static enum Fireproof implements IAlleleValue<Boolean>
    {
        TRUE(true),
        FALSE(false);

        private final boolean value;
        private final boolean dominant;

        private Fireproof(boolean value) {
            this(value, false);
        }

        private Fireproof(boolean value, boolean dominant) {
            this.value = value;
            this.dominant = dominant;
        }

        @Override
        public boolean isDominant() {
            return this.dominant;
        }

        @Override
        public Boolean getValue() {
            return this.value;
        }
    }

    public static enum Fertility implements IAlleleValue<Integer>
    {
        LOW(1, true),
        NORMAL(2, true),
        HIGH(3),
        MAXIMUM(4);

        private final Integer value;
        private final boolean dominant;

        private Fertility(Integer value) {
            this(value, false);
        }

        private Fertility(Integer value, boolean dominant) {
            this.value = value;
            this.dominant = dominant;
        }

        @Override
        public Integer getValue() {
            return this.value;
        }

        @Override
        public boolean isDominant() {
            return this.dominant;
        }
    }
}

