/*
 * Decompiled with CFR 0.152.
 */
package forestry.climatology.blocks;

import forestry.api.core.EnumTemperature;
import forestry.climatology.blocks.BlockTypeClimatology;
import forestry.climatology.tiles.TileHabitatFormer;
import forestry.core.blocks.BlockBase;
import forestry.core.blocks.IColoredBlock;
import forestry.core.render.ParticleRender;
import forestry.core.tiles.TileUtil;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockHabitatFormer
extends BlockBase<BlockTypeClimatology>
implements IColoredBlock {
    public BlockHabitatFormer() {
        super(BlockTypeClimatology.HABITAT_FORMER);
        this.func_149711_c(1.0f);
        this.setHarvestLevel("pickaxe", 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileHabitatFormer former = TileUtil.getTile((IBlockAccess)worldIn, pos, TileHabitatFormer.class);
        if (former != null) {
            ParticleRender.addClimateParticles(worldIn, pos, rand, former.getTemperature(), former.getHumidity());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public int colorMultiplier(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
        if (worldIn == null || pos == null) {
            return 9511479;
        }
        TileHabitatFormer former = TileUtil.getTile(worldIn, pos, TileHabitatFormer.class);
        if (former != null) {
            EnumTemperature temperature = former.getTemperature();
            return temperature.color;
        }
        return 9511479;
    }
}

