/*
 * Decompiled with CFR 0.152.
 */
package forestry.climatology;

import com.google.common.base.Preconditions;
import forestry.api.climate.IClimateListener;
import forestry.api.climate.IClimateTransformer;
import forestry.api.modules.ForestryModule;
import forestry.api.recipes.RecipeManagers;
import forestry.climatology.blocks.BlockRegistryClimatology;
import forestry.climatology.items.ItemRegistryClimatology;
import forestry.climatology.network.PacketRegistryClimatology;
import forestry.climatology.proxy.ProxyClimatology;
import forestry.climatology.tiles.TileHabitatFormer;
import forestry.core.ModuleCore;
import forestry.core.capabilities.NullStorage;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.climate.FakeClimateListener;
import forestry.core.climate.FakeClimateTransformer;
import forestry.core.items.EnumElectronTube;
import forestry.core.items.ItemRegistryCore;
import forestry.core.network.IPacketRegistry;
import forestry.core.recipes.RecipeUtil;
import forestry.core.tiles.TileUtil;
import forestry.modules.BlankForestryModule;
import forestry.modules.ModuleHelper;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.SidedProxy;

@ForestryModule(containerID="forestry", moduleID="climatology", name="Climatology", author="Nedelosk", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.greenhouse.description")
public class ModuleClimatology
extends BlankForestryModule {
    @SidedProxy(clientSide="forestry.climatology.proxy.ProxyClimatologyClient", serverSide="forestry.climatology.proxy.ProxyClimatology")
    public static ProxyClimatology proxy;
    @Nullable
    private static BlockRegistryClimatology blocks;
    @Nullable
    private static ItemRegistryClimatology items;

    public static BlockRegistryClimatology getBlocks() {
        Preconditions.checkNotNull((Object)blocks);
        return blocks;
    }

    public static ItemRegistryClimatology getItems() {
        Preconditions.checkNotNull((Object)items);
        return items;
    }

    @Override
    public void registerItemsAndBlocks() {
        blocks = new BlockRegistryClimatology();
        items = new ItemRegistryClimatology();
    }

    @Override
    public void preInit() {
        proxy.preInit();
        CapabilityManager.INSTANCE.register(IClimateListener.class, new NullStorage(), () -> FakeClimateListener.INSTANCE);
        CapabilityManager.INSTANCE.register(IClimateTransformer.class, new NullStorage(), () -> FakeClimateTransformer.INSTANCE);
    }

    @Override
    public void doInit() {
        TileUtil.registerTile(TileHabitatFormer.class, "habitat_former");
    }

    @Override
    public void registerRecipes() {
        ItemRegistryCore coreItems = ModuleCore.getItems();
        BlockRegistryClimatology blockRegistry = ModuleClimatology.getBlocks();
        RecipeUtil.addRecipe("habitat_former", new ItemStack((Block)blockRegistry.habitatformer), "GRG", "TST", "BCB", Character.valueOf('S'), coreItems.sturdyCasing, Character.valueOf('G'), "blockGlass", Character.valueOf('B'), "gearBronze", Character.valueOf('R'), "dustRedstone", Character.valueOf('C'), coreItems.circuitboards.get(EnumCircuitBoardType.BASIC), Character.valueOf('T'), coreItems.tubes.get(EnumElectronTube.IRON, 1));
        if (ModuleHelper.isEnabled("factory")) {
            RecipeManagers.carpenterManager.addRecipe(100, new FluidStack(FluidRegistry.WATER, 2000), ItemStack.field_190927_a, ModuleClimatology.getItems().habitatScreen.getItemStack(), "IPI", "IPI", "GDG", Character.valueOf('G'), "gearBronze", Character.valueOf('P'), "paneGlass", Character.valueOf('I'), "ingotBronze", Character.valueOf('D'), "gemDiamond");
        } else {
            RecipeUtil.addRecipe("habitat_screen", ModuleClimatology.getItems().habitatScreen.getItemStack(), "IPI", "IPI", "GDG", Character.valueOf('G'), "gearBronze", Character.valueOf('P'), "paneGlass", Character.valueOf('I'), "ingotBronze", Character.valueOf('D'), "gemDiamond");
        }
    }

    @Override
    public IPacketRegistry getPacketRegistry() {
        return new PacketRegistryClimatology();
    }
}

