/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.ILeafSpriteProvider;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.IModelManager;
import forestry.api.genetics.ISpeciesType;
import forestry.arboriculture.ModuleArboriculture;
import forestry.arboriculture.blocks.BlockAbstractLeaves;
import forestry.arboriculture.blocks.PropertyTreeTypeFruit;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.core.network.packets.PacketFXSignal;
import forestry.core.proxy.Proxies;
import forestry.core.utils.NetworkUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class BlockDefaultLeavesFruit
extends BlockAbstractLeaves {
    private static final int VARIANTS_PER_BLOCK = 4;
    protected final int blockNumber;

    public static List<BlockDefaultLeavesFruit> create() {
        ArrayList<BlockDefaultLeavesFruit> blocks = new ArrayList<BlockDefaultLeavesFruit>();
        int blockCount = PropertyTreeTypeFruit.getBlockCount(4);
        for (int blockNumber = 0; blockNumber < blockCount; ++blockNumber) {
            final PropertyTreeTypeFruit variant = PropertyTreeTypeFruit.create("variant", blockNumber, 4);
            BlockDefaultLeavesFruit block = new BlockDefaultLeavesFruit(blockNumber){

                @Override
                public PropertyTreeTypeFruit getVariant() {
                    return variant;
                }
            };
            blocks.add(block);
        }
        return blocks;
    }

    public BlockDefaultLeavesFruit(int blockNumber) {
        this.blockNumber = blockNumber;
        PropertyTreeTypeFruit variant = this.getVariant();
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)variant, (Comparable)variant.getFirstType()).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(true)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.getVariant(), field_176236_b, field_176237_a});
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack mainHand = player.func_184586_b(EnumHand.MAIN_HAND);
        ItemStack offHand = player.func_184586_b(EnumHand.OFF_HAND);
        if (mainHand.func_190926_b() && offHand.func_190926_b()) {
            PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.VisualFXType.BLOCK_BREAK, PacketFXSignal.SoundFXType.BLOCK_BREAK, pos, state);
            NetworkUtil.sendNetworkPacket(packet, pos, world);
            ITree tree = this.getTree((IBlockAccess)world, pos);
            if (tree == null) {
                return false;
            }
            IFruitProvider fruitProvider = tree.getGenome().getFruitProvider();
            NonNullList<ItemStack> products = tree.produceStacks(world, pos, fruitProvider.getRipeningPeriod());
            world.func_180501_a(pos, ModuleArboriculture.getBlocks().getDefaultLeaves(tree.getIdent()), 2);
            for (ItemStack fruit : products) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)fruit);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void getLeafDrop(NonNullList<ItemStack> drops, World world, @Nullable GameProfile playerProfile, BlockPos pos, float saplingModifier, int fortune) {
        ITree tree = this.getTree((IBlockAccess)world, pos);
        if (tree == null) {
            return;
        }
        List<ITree> saplings = tree.getSaplings(world, playerProfile, pos, saplingModifier);
        for (ITree sapling : saplings) {
            if (sapling == null) continue;
            drops.add((Object)TreeManager.treeRoot.getMemberStack(sapling, (ISpeciesType)EnumGermlingType.SAPLING));
        }
        ITreeGenome genome = tree.getGenome();
        IFruitProvider fruitProvider = genome.getFruitProvider();
        if (fruitProvider.isFruitLeaf(genome, world, pos)) {
            NonNullList<ItemStack> produceStacks = tree.produceStacks(world, pos, Integer.MAX_VALUE);
            drops.addAll(produceStacks);
        }
    }

    public int getBlockNumber() {
        return this.blockNumber;
    }

    protected abstract PropertyTreeTypeFruit getVariant();

    @Nullable
    public PropertyTreeTypeFruit.LeafVariant getLeafVariant(IBlockState blockState) {
        if (blockState.func_177230_c() == this) {
            return (PropertyTreeTypeFruit.LeafVariant)blockState.func_177229_b((IProperty)this.getVariant());
        }
        return null;
    }

    public int func_180651_a(IBlockState state) {
        PropertyTreeTypeFruit.LeafVariant treeDefinition = this.getLeafVariant(state);
        if (treeDefinition == null) {
            return 0;
        }
        return treeDefinition.metadata - this.blockNumber * 4;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)this.getVariant(), (Comparable)this.getTreeType(meta)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf((meta & 4) == 0)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int i = this.func_180651_a(state);
        if (!((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            i |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    public PropertyTreeTypeFruit.LeafVariant getTreeType(int meta) {
        int variantCount = this.getVariant().func_177700_c().size();
        int variantMeta = meta % variantCount + this.blockNumber * 4;
        return PropertyTreeTypeFruit.getVariant(variantMeta);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        PropertyTreeTypeFruit.LeafVariant type = this.getTreeType(meta);
        return this.func_176223_P().func_177226_a((IProperty)this.getVariant(), (Comparable)type);
    }

    @Override
    protected ITree getTree(IBlockAccess world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        PropertyTreeTypeFruit.LeafVariant treeDefinition = this.getLeafVariant(blockState);
        if (treeDefinition != null) {
            return treeDefinition.definition.getIndividual();
        }
        return null;
    }

    @Override
    public final boolean func_149662_c(IBlockState state) {
        if (!Proxies.render.fancyGraphicsEnabled()) {
            PropertyTreeTypeFruit.LeafVariant treeDefinition = (PropertyTreeTypeFruit.LeafVariant)state.func_177229_b((IProperty)this.getVariant());
            return !TreeDefinition.Willow.equals(treeDefinition.definition);
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        for (IBlockState state : this.field_176227_L.func_177619_a()) {
            int meta = this.func_176201_c(state);
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation("forestry:leaves.default.fruit." + this.blockNumber, "inventory"));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
        PropertyTreeTypeFruit.LeafVariant variant = this.getLeafVariant(state);
        TreeDefinition treeDefinition = variant != null ? variant.definition : TreeDefinition.Oak;
        ITreeGenome genome = treeDefinition.getGenome();
        if (tintIndex == 2) {
            IFruitProvider fruitProvider = genome.getFruitProvider();
            return fruitProvider.getDecorativeColor();
        }
        ILeafSpriteProvider spriteProvider = genome.getPrimary().getLeafSpriteProvider();
        return spriteProvider.getColor(false);
    }
}

