/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.network;

import knightminer.ceramics.network.BarrelSizeChangedPacket;
import knightminer.ceramics.network.ChannelConnectionPacket;
import knightminer.ceramics.network.ChannelFlowPacket;
import knightminer.ceramics.network.ExtensionMasterUpdatePacket;
import knightminer.ceramics.network.FluidUpdatePacket;
import knightminer.ceramics.network.PacketBase;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class CeramicsNetwork {
    public static final SimpleNetworkWrapper INSTANCE = NetworkRegistry.INSTANCE.newSimpleChannel("ceramics");
    private static int id = 0;

    public static void registerPackets() {
        PacketHandler handler = new PacketHandler();
        INSTANCE.registerMessage((IMessageHandler)handler, FluidUpdatePacket.class, id++, Side.CLIENT);
        INSTANCE.registerMessage((IMessageHandler)handler, BarrelSizeChangedPacket.class, id++, Side.CLIENT);
        INSTANCE.registerMessage((IMessageHandler)handler, ExtensionMasterUpdatePacket.class, id++, Side.CLIENT);
        INSTANCE.registerMessage((IMessageHandler)handler, ChannelConnectionPacket.class, id++, Side.CLIENT);
        INSTANCE.registerMessage((IMessageHandler)handler, ChannelFlowPacket.class, id++, Side.CLIENT);
    }

    public static void sendToAllAround(World world, BlockPos pos, PacketBase message) {
        INSTANCE.sendToAllAround((IMessage)message, new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 64.0));
    }

    public static void sendToClients(WorldServer world, BlockPos pos, PacketBase packet) {
        Chunk chunk = world.func_175726_f(pos);
        for (EntityPlayer player : world.field_73010_i) {
            if (!(player instanceof EntityPlayerMP)) continue;
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            if (!world.func_184164_w().func_72694_a(playerMP, chunk.field_76635_g, chunk.field_76647_h)) continue;
            INSTANCE.sendTo((IMessage)packet, playerMP);
        }
    }

    public static class PacketHandler
    implements IMessageHandler<PacketBase, IMessage> {
        public IMessage onMessage(PacketBase message, MessageContext ctx) {
            if (!ctx.side.isClient()) {
                throw new UnsupportedOperationException("Serverside only packets not currently supported");
            }
            NetHandlerPlayClient handler = ctx.getClientHandler();
            FMLCommonHandler.instance().getWorldThread((INetHandler)handler).func_152344_a(() -> message.handleClient(handler));
            return null;
        }
    }
}

