/*
 * Decompiled with CFR 0.152.
 */
package panszelescik.moreplates.plugins.helpers;

import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import panszelescik.morelibs.api.Helper;
import panszelescik.moreplates.MorePlates;
import panszelescik.moreplates.config.Config;
import panszelescik.moreplates.items.ItemGear;
import panszelescik.moreplates.items.ItemPlate;
import panszelescik.moreplates.items.ItemStick;
import panszelescik.moreplates.plugins.core.ItemInfo;
import panszelescik.moreplates.plugins.helpers.ImmersiveEngineeringHelper;
import panszelescik.moreplates.plugins.helpers.IndustrialCraft2Helper;
import panszelescik.moreplates.plugins.helpers.TechRebornHelper;
import panszelescik.moreplates.plugins.helpers.ThermalExpansionHelper;

public class PluginHelper
extends Helper {
    public static void reg(ItemInfo info) {
        PluginHelper.regGear(info);
        PluginHelper.regPlate(info);
    }

    protected static void regGear(ItemInfo info) {
        ItemGear gear = new ItemGear(info.toString());
        if (Config.loadItem((Item)gear)) {
            PluginHelper.regItem((Item)gear);
            OreDictionary.registerOre((String)("gear" + info.getOre()), (Item)gear);
        }
    }

    protected static void regPlate(ItemInfo info) {
        ItemPlate plate = new ItemPlate(info.toString());
        if (Config.loadItem((Item)plate)) {
            PluginHelper.regItem((Item)plate);
            OreDictionary.registerOre((String)("plate" + info.getOre()), (Item)plate);
        }
    }

    protected static void regStick(ItemInfo info) {
        ItemStick stick = new ItemStick(info.toString());
        if (Config.loadItem((Item)stick)) {
            PluginHelper.regItem((Item)stick);
            OreDictionary.registerOre((String)("stick" + info.getOre()), (Item)stick);
        }
    }

    private static void regItem(Item item) {
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
        MorePlates.logger.debug("Registering item: " + PluginHelper.getItemName((Item)item));
    }

    protected static boolean contains(String name) {
        return Item.field_150901_e.func_148741_d((Object)new ResourceLocation("moreplates:" + name));
    }

    protected static boolean oreNameExists(ItemInfo ore) {
        return PluginHelper.oreNameExists((String)ore.getInput());
    }

    protected static boolean oreNameExists(ItemInfo ore, ItemInfo.Type type) {
        return PluginHelper.oreNameExists((String)(type.toString() + ore.getOre()));
    }

    protected static void add(ItemInfo output, String input, boolean gear, boolean plate) {
        if (PluginHelper.ieEnabled()) {
            ImmersiveEngineeringHelper.add(output.getOre(), input, gear, plate, false);
        }
        if (PluginHelper.icEnabled()) {
            IndustrialCraft2Helper.add(output.getOre(), input, plate);
        }
        if (PluginHelper.thEnabled()) {
            TechRebornHelper.add(output.getOre(), input, plate);
        }
        if (PluginHelper.teEnabled()) {
            ThermalExpansionHelper.add(output.getOre(), input, gear, plate);
        }
    }

    protected static void add(ItemInfo item, boolean gear, boolean plate) {
        PluginHelper.add(item, gear, plate, false);
    }

    protected static void add(ItemInfo item, boolean gear, boolean plate, boolean stick) {
        if (PluginHelper.ieEnabled()) {
            ImmersiveEngineeringHelper.add(item.getOre(), item.getInput(), gear, plate, stick);
        }
        if (PluginHelper.icEnabled()) {
            IndustrialCraft2Helper.add(item.getOre(), item.getInput(), plate);
        }
        if (PluginHelper.thEnabled()) {
            TechRebornHelper.add(item.getOre(), item.getInput(), plate);
        }
        if (PluginHelper.teEnabled()) {
            ThermalExpansionHelper.add(item.getOre(), item.getInput(), gear, plate);
        }
    }

    protected static void add(ItemInfo item) {
        PluginHelper.add(item, item);
    }

    protected static void add(ItemInfo output, ItemInfo input) {
        if (PluginHelper.ieEnabled()) {
            ImmersiveEngineeringHelper.add(output.getOre(), input.getInput());
        }
        if (PluginHelper.icEnabled()) {
            IndustrialCraft2Helper.add(output.getOre(), input.getInput());
        }
        if (PluginHelper.thEnabled()) {
            TechRebornHelper.add(output.getOre(), input.getInput());
        }
        if (PluginHelper.teEnabled()) {
            ThermalExpansionHelper.add(output.getOre(), input.getInput());
        }
    }

    protected static void add(ItemInfo output, String input, String id) {
        PluginHelper.add(output, input, id, 0);
    }

    protected static void add(ItemInfo output, String input, String id, int meta) {
        if (PluginHelper.ieEnabled()) {
            ImmersiveEngineeringHelper.add(output.getOre(), input, id, meta);
        }
        if (PluginHelper.icEnabled()) {
            IndustrialCraft2Helper.add(output.getOre(), input, id, meta);
        }
        if (PluginHelper.thEnabled()) {
            TechRebornHelper.add(output.getOre(), input, id, meta);
        }
        if (PluginHelper.teEnabled()) {
            ThermalExpansionHelper.add(output.getOre(), input, id, meta);
        }
    }

    protected static void addBlock(ItemInfo name, int amount, boolean plate) {
        if (PluginHelper.icEnabled()) {
            IndustrialCraft2Helper.addBlock(name.getOre(), amount, plate);
        }
        if (PluginHelper.thEnabled()) {
            TechRebornHelper.addBlock(name.getOre(), amount, plate);
        }
    }

    protected static void addBlock(ItemInfo name) {
        PluginHelper.addBlock(name, 9);
    }

    protected static void addBlock(ItemInfo name, int amount) {
        if (PluginHelper.icEnabled()) {
            IndustrialCraft2Helper.addBlock(name.getOre(), amount);
        }
        if (PluginHelper.thEnabled()) {
            TechRebornHelper.addBlock(name.getOre(), amount);
        }
    }

    protected static void addBlock(ItemInfo output, String input, int amount, String id) {
        PluginHelper.addBlock(output, input, amount, id, 0);
    }

    protected static void addBlock(ItemInfo output, String input, int amount, String id, int meta) {
        if (PluginHelper.icEnabled()) {
            IndustrialCraft2Helper.addBlock(output.getOre(), input, amount, id, meta);
        }
        if (PluginHelper.thEnabled()) {
            TechRebornHelper.addBlock(output.getOre(), input, amount, id, meta);
        }
    }

    private static boolean icEnabled() {
        return PluginHelper.isLoaded((String)"Industrial Craft 2") && !PluginHelper.isLoaded((String)"ic2-classic-spmod");
    }

    private static boolean ieEnabled() {
        return PluginHelper.isLoaded((String)"immersiveengineering");
    }

    private static boolean thEnabled() {
        return PluginHelper.isLoaded((String)"techreborn");
    }

    private static boolean teEnabled() {
        return PluginHelper.isLoaded((String)"thermalexpansion");
    }

    public static void printAmount() {
        if (PluginHelper.ieEnabled()) {
            MorePlates.logger.info("Added " + ImmersiveEngineeringHelper.MetalPressRecipes + " recipes to Metal Press");
        }
        if (PluginHelper.icEnabled()) {
            MorePlates.logger.info("Added " + IndustrialCraft2Helper.BlockCuttingMachineRecipes + " recipes to Block Cutting Machine");
            MorePlates.logger.info("Added " + IndustrialCraft2Helper.MetalFormerRecipes + " recipes to Metal Former");
        }
        if (PluginHelper.thEnabled()) {
            MorePlates.logger.info("Added " + TechRebornHelper.CompressorRecipes + " recipes to Compressor");
        }
        if (PluginHelper.teEnabled()) {
            MorePlates.logger.info("Added " + ThermalExpansionHelper.CompactorRecipes + " recipes to Compactor");
            MorePlates.logger.info("Added " + ThermalExpansionHelper.InductionSmelterRecipes + " recipes to Induction Smelter");
        }
    }
}

