/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalinnovation.gui.container;

import cofh.api.core.IFilterable;
import cofh.core.gui.container.ContainerCore;
import cofh.core.gui.slot.SlotFalseCopy;
import cofh.core.gui.slot.SlotLocked;
import cofh.core.network.PacketCore;
import cofh.core.util.CoreUtils;
import cofh.core.util.filter.ItemFilterWrapper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalinnovation.item.ItemMagnet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerMagnetFilter
extends ContainerCore
implements IFilterable {
    public static final String NAME = "item.thermalinnovation.magnet.name";
    protected final ItemFilterWrapper filterWrapper;
    protected final EntityPlayer player;
    protected final int containerIndex;
    protected final int filterIndex;
    protected boolean valid = true;

    public ContainerMagnetFilter(ItemStack stack, InventoryPlayer inventory) {
        this.player = inventory.field_70458_d;
        this.containerIndex = inventory.field_70461_c;
        this.filterWrapper = new ItemFilterWrapper(stack, ItemMagnet.getFilterSize(stack));
        this.filterIndex = ItemMagnet.getLevel(stack);
        int rows = MathHelper.clamp((int)(this.filterIndex + 1), (int)1, (int)3);
        int slots = ItemMagnet.getFilterSize(stack);
        int rowSize = slots / rows;
        int xOffset = 62 - 9 * rowSize;
        int yOffset = 44 - 9 * rows;
        this.bindPlayerInventory(inventory);
        for (int i = 0; i < slots; ++i) {
            this.func_75146_a((Slot)new SlotFalseCopy((IInventory)this.filterWrapper, i, xOffset + i % rowSize * 18, yOffset + i / rowSize * 18));
        }
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        int xOffset = this.getPlayerInventoryHorizontalOffset();
        int yOffset = this.getPlayerInventoryVerticalOffset();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, xOffset + j * 18, yOffset + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            if (i == inventoryPlayer.field_70461_c) {
                this.func_75146_a((Slot)new SlotLocked((IInventory)inventoryPlayer, i, xOffset + i * 18, yOffset + 58));
                continue;
            }
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, xOffset + i * 18, yOffset + 58));
        }
    }

    protected int getPlayerInventoryVerticalOffset() {
        return 84;
    }

    protected int getSizeInventory() {
        return 0;
    }

    public void func_75142_b() {
        ItemStack item = (ItemStack)this.player.field_71071_by.field_70462_a.get(this.containerIndex);
        if (item.func_190926_b() || item.func_77973_b() != this.filterWrapper.getFilterItem()) {
            this.valid = false;
            return;
        }
        super.func_75142_b();
    }

    public boolean func_75145_c(EntityPlayer player) {
        this.onSlotChanged();
        if (this.filterWrapper.getDirty() && !this.valid) {
            player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
        }
        return this.valid;
    }

    public void onSlotChanged() {
        ItemStack item = (ItemStack)this.player.field_71071_by.field_70462_a.get(this.containerIndex);
        if (this.valid && !item.func_190926_b() && item.func_77973_b() == this.filterWrapper.getFilterItem()) {
            this.player.field_71071_by.field_70462_a.set(this.containerIndex, (Object)this.filterWrapper.getFilterStack());
        }
    }

    public boolean getFlag(int flag) {
        return this.filterWrapper.getFilter().getFlag(flag);
    }

    public String getInventoryName() {
        return this.filterWrapper.func_145818_k_() ? this.filterWrapper.func_70005_c_() : StringHelper.localize((String)NAME);
    }

    public ItemStack getFilterStack() {
        return this.filterWrapper.getFilterStack();
    }

    public void setFlag(int flag, boolean value) {
        this.filterWrapper.getFilter().setFlag(flag, value);
        if (CoreUtils.isClient()) {
            PacketCore.sendFilterPacketToServer((int)flag, (boolean)value);
        }
        this.filterWrapper.func_70296_d();
    }
}

