/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.gui.controls;

import erogenousbeef.bigreactors.client.gui.BeefGuiBase;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.gui.IBeefTooltipControl;
import erogenousbeef.bigreactors.gui.controls.BeefGuiIconProgressBar;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class BeefGuiFluidBar
extends BeefGuiIconProgressBar
implements IBeefTooltipControl {
    private IFluidHandler _fluidInfo;
    private static ResourceLocation s_bgTexture;

    public BeefGuiFluidBar(BeefGuiBase container, int x, int y, IFluidHandler handlerInfo) {
        super(container, x, y);
        this._fluidInfo = handlerInfo;
    }

    @Override
    protected ResourceLocation getProgressBarIcon() {
        IFluidTankProperties properties = this.getTankProperties();
        FluidStack stack = null != properties ? properties.getContents() : null;
        Fluid fluid = null != stack ? stack.getFluid() : null;
        return null != fluid ? fluid.getStill(stack) : null;
    }

    @Override
    protected ResourceLocation getBackgroundTexture() {
        if (null == s_bgTexture) {
            s_bgTexture = BigReactors.createGuiResourceLocation("controls/fluidtank.png");
        }
        return s_bgTexture;
    }

    @Override
    protected float getProgress() {
        FluidStack stack;
        IFluidTankProperties properties = this.getTankProperties();
        if (null != properties && null != (stack = properties.getContents())) {
            return (float)stack.amount / (float)properties.getCapacity();
        }
        return 0.0f;
    }

    @Override
    public String[] getTooltip() {
        if (!this.visible) {
            return null;
        }
        IFluidTankProperties properties = this.getTankProperties();
        if (null != properties) {
            int amount;
            String fluidName;
            FluidStack stack = properties.getContents();
            int capacity = properties.getCapacity();
            if (null != stack) {
                fluidName = stack.getFluid().getLocalizedName(stack);
                amount = stack.amount;
            } else {
                amount = 0;
                fluidName = "Empty";
            }
            return new String[]{fluidName, String.format("%d / %d mB", amount, capacity)};
        }
        return null;
    }

    @Override
    protected ResourceLocation getResourceLocation() {
        return TextureMap.field_110575_b;
    }

    @Override
    protected boolean drawGradationMarks() {
        return true;
    }

    @Nullable
    private IFluidTankProperties getTankProperties() {
        IFluidTankProperties[] properties = this._fluidInfo.getTankProperties();
        return null != properties && properties.length > 0 ? properties[0] : null;
    }
}

