/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.computer;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import erogenousbeef.bigreactors.common.multiblock.computer.TurbineComputer;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbineComputerPort;
import it.zerono.mods.zerocore.lib.compat.LuaHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="computercraft")})
public class TurbineComputerCC
extends TurbineComputer
implements IPeripheral {
    private static final String[] METHODS_NAMES;

    private TurbineComputerCC(@Nonnull TileEntityTurbineComputerPort computerPort) {
        super(computerPort);
    }

    public static TurbineComputerCC create(TileEntityTurbineComputerPort tileEntity) {
        return new TurbineComputerCC(tileEntity);
    }

    @Nonnull
    @Optional.Method(modid="computercraft")
    public String getType() {
        return "BigReactors-Turbine";
    }

    @Nonnull
    @Optional.Method(modid="computercraft")
    public String[] getMethodNames() {
        return METHODS_NAMES;
    }

    @Optional.Method(modid="computercraft")
    public void attach(@Nonnull IComputerAccess iComputerAccess) {
    }

    @Optional.Method(modid="computercraft")
    public void detach(@Nonnull IComputerAccess iComputerAccess) {
    }

    @Optional.Method(modid="computercraft")
    public boolean equals(@Nullable IPeripheral other) {
        return null != other && this.hashCode() == other.hashCode();
    }

    @Nullable
    @Optional.Method(modid="computercraft")
    public Object[] callMethod(@Nonnull IComputerAccess computer, @Nonnull ILuaContext luaContext, int methodIdx, @Nonnull Object[] arguments) throws LuaException, InterruptedException {
        try {
            ComputerMethod method = ComputerMethod.fromIndex(methodIdx);
            switch (method) {
                case getConnected: {
                    return new Object[]{this.getConnected()};
                }
                case getActive: {
                    return new Object[]{this.getActive()};
                }
                case getEnergyStored: {
                    return new Object[]{this.getEnergyStored()};
                }
                case getRotorSpeed: {
                    return new Object[]{Float.valueOf(this.getRotorSpeed())};
                }
                case getInputAmount: {
                    return new Object[]{this.getInputAmount()};
                }
                case getInputType: {
                    return new Object[]{this.getInputType()};
                }
                case getOutputAmount: {
                    return new Object[]{this.getOutputAmount()};
                }
                case getOutputType: {
                    return new Object[]{this.getOutputType()};
                }
                case getFluidAmountMax: {
                    return new Object[]{this.getFluidAmountMax()};
                }
                case getFluidFlowRate: {
                    return new Object[]{this.getFluidFlowRate()};
                }
                case getFluidFlowRateMax: {
                    return new Object[]{this.getFluidFlowRateMax()};
                }
                case getFluidFlowRateMaxMax: {
                    return new Object[]{this.getFluidFlowRateMaxMax()};
                }
                case getEnergyProducedLastTick: {
                    return new Object[]{Float.valueOf(this.getEnergyProducedLastTick())};
                }
                case getNumberOfBlades: {
                    return new Object[]{this.getNumberOfBlades()};
                }
                case getBladeEfficiency: {
                    return new Object[]{Float.valueOf(this.getBladeEfficiency())};
                }
                case getRotorMass: {
                    return new Object[]{this.getRotorMass()};
                }
                case getInductorEngaged: {
                    return new Object[]{this.getInductorEngaged()};
                }
                case getMaximumCoordinate: {
                    BlockPos coords = this.getMaximumCoordinate();
                    return new Object[]{coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p()};
                }
                case getMinimumCoordinate: {
                    BlockPos coords = this.getMinimumCoordinate();
                    return new Object[]{coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p()};
                }
                case setActive: {
                    LuaHelper.validateArgsCount((Object[])arguments, (int)1);
                    this.setActive(LuaHelper.getBooleanFromArgs((Object[])arguments, (int)0));
                    return null;
                }
                case setFluidFlowRateMax: {
                    LuaHelper.validateArgsCount((Object[])arguments, (int)1);
                    this.setFluidFlowRateMax(LuaHelper.getIntFromArgs((Object[])arguments, (int)0));
                    return null;
                }
                case setVentNone: {
                    this.setVentNone();
                    return null;
                }
                case setVentOverflow: {
                    this.setVentOverflow();
                    return null;
                }
                case setVentAll: {
                    this.setVentAll();
                    return null;
                }
                case setInductorEngaged: {
                    LuaHelper.validateArgsCount((Object[])arguments, (int)1);
                    this.setInductorEngaged(LuaHelper.getBooleanFromArgs((Object[])arguments, (int)0));
                    return null;
                }
                case getEnergyCapacity: {
                    return new Object[]{this.getEnergyCapacity()};
                }
                case getMultiblockAssembled: {
                    return new Object[]{this.getMultiblockAssembled()};
                }
            }
            throw new Exception("Method not implemented");
        }
        catch (Exception ex) {
            throw new LuaException(ex.getMessage());
        }
    }

    static {
        ComputerMethod[] methods = ComputerMethod.values();
        METHODS_NAMES = new String[methods.length];
        for (ComputerMethod method : methods) {
            TurbineComputerCC.METHODS_NAMES[method.ordinal()] = method.toString();
        }
    }

    private static enum ComputerMethod {
        getConnected,
        getActive,
        getEnergyStored,
        getRotorSpeed,
        getInputAmount,
        getInputType,
        getOutputAmount,
        getOutputType,
        getFluidAmountMax,
        getFluidFlowRate,
        getFluidFlowRateMax,
        getFluidFlowRateMaxMax,
        getEnergyProducedLastTick,
        getNumberOfBlades,
        getBladeEfficiency,
        getRotorMass,
        getInductorEngaged,
        getMaximumCoordinate,
        getMinimumCoordinate,
        setActive,
        setFluidFlowRateMax,
        setVentNone,
        setVentOverflow,
        setVentAll,
        setInductorEngaged,
        getEnergyCapacity,
        getMultiblockAssembled;


        public static Boolean isValidIndex(int index) {
            return index >= 0 && index < ComputerMethod.values().length;
        }

        public static ComputerMethod fromIndex(int index) {
            if (!ComputerMethod.isValidIndex(index).booleanValue()) {
                throw new IndexOutOfBoundsException("Invalid method index");
            }
            return ComputerMethod.values()[index];
        }
    }
}

