/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.block;

import erogenousbeef.bigreactors.common.Properties;
import erogenousbeef.bigreactors.common.multiblock.PartType;
import erogenousbeef.bigreactors.common.multiblock.block.BlockPart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePart;
import it.zerono.mods.zerocore.api.multiblock.rectangular.PartPosition;
import it.zerono.mods.zerocore.api.multiblock.rectangular.RectangularMultiblockTileEntityBase;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMultiblockCasing
extends BlockPart {
    public BlockMultiblockCasing(PartType type, String blockName) {
        super(type, blockName, Material.field_151573_f);
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        switch (this._type) {
            case ReactorCasing: {
                return new TileEntityReactorPart();
            }
            case TurbineHousing: {
                return new TileEntityTurbinePart();
            }
        }
        throw new IllegalArgumentException("Unrecognized part");
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos position) {
        RectangularMultiblockTileEntityBase mbTile;
        TileEntity te = world.func_175625_s(position);
        CasingType type = CasingType.Single;
        if (te instanceof RectangularMultiblockTileEntityBase && (mbTile = (RectangularMultiblockTileEntityBase)te).isConnected() && mbTile.getMultiblockController().isAssembled()) {
            type = CasingType.from(mbTile.getPartPosition());
        }
        return state.func_177226_a(Properties.CASINGTYPE, (Comparable)((Object)type));
    }

    protected void buildBlockState(BlockStateContainer.Builder builder) {
        super.buildBlockState(builder);
        builder.add(new IProperty[]{Properties.CASINGTYPE});
    }

    protected IBlockState buildDefaultState(IBlockState state) {
        return super.buildDefaultState(state).func_177226_a(Properties.CASINGTYPE, (Comparable)((Object)CasingType.Single));
    }

    public static enum CasingType implements IStringSerializable
    {
        Single,
        Wall,
        FrameEW,
        FrameSN,
        FrameUD,
        Corner;

        private final String _name = this.name().toLowerCase();

        public static CasingType from(PartPosition position) {
            if (position.isFace()) {
                return Wall;
            }
            switch (position) {
                case FrameCorner: {
                    return Corner;
                }
                case FrameEastWest: {
                    return FrameEW;
                }
                case FrameSouthNorth: {
                    return FrameSN;
                }
                case FrameUpDown: {
                    return FrameUD;
                }
            }
            return Single;
        }

        public String toString() {
            return this._name;
        }

        public String func_176610_l() {
            return this._name;
        }
    }
}

