/*
 * Decompiled with CFR 0.152.
 */
package ninja.leaping.configurate.util;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import ninja.leaping.configurate.util.MapFactory;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class MapFactories {
    private MapFactories() {
    }

    public static MapFactory unordered() {
        return DefaultFactory.UNORDERED;
    }

    public static MapFactory sorted(Comparator<Object> comparator) {
        Preconditions.checkNotNull(comparator, (Object)"comparator");
        return new SortedMapFactory(comparator);
    }

    public static MapFactory sortedNatural() {
        return DefaultFactory.SORTED_NATURAL;
    }

    public static MapFactory insertionOrdered() {
        return DefaultFactory.INSERTION_ORDERED;
    }

    private static class SynchronizedWrapper<K, V>
    implements ConcurrentMap<K, V> {
        private final Map<K, V> wrapped;

        private SynchronizedWrapper(Map<K, V> wrapped) {
            this.wrapped = wrapped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V putIfAbsent(K k, V v) {
            Map<K, V> map = this.wrapped;
            synchronized (map) {
                if (this.wrapped.containsKey(k)) {
                    return this.wrapped.get(k);
                }
                this.wrapped.put(k, v);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object key, Object expected) {
            Map<K, V> map = this.wrapped;
            synchronized (map) {
                if (Objects.equal((Object)expected, this.wrapped.get(key))) {
                    return this.wrapped.remove(key) != null;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean replace(K key, V old, V replace) {
            Map<K, V> map = this.wrapped;
            synchronized (map) {
                if (Objects.equal(old, this.wrapped.get(key))) {
                    this.wrapped.put(key, replace);
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V replace(K k, V v) {
            Map<K, V> map = this.wrapped;
            synchronized (map) {
                if (this.wrapped.containsKey(k)) {
                    return this.wrapped.put(k, v);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Map<K, V> map = this.wrapped;
            synchronized (map) {
                return this.wrapped.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Map<K, V> map = this.wrapped;
            synchronized (map) {
                return this.wrapped.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object o) {
            Map<K, V> map = this.wrapped;
            synchronized (map) {
                return this.wrapped.containsKey(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object o) {
            Map<K, V> map = this.wrapped;
            synchronized (map) {
                return this.wrapped.containsKey(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(Object o) {
            Map<K, V> map = this.wrapped;
            synchronized (map) {
                return this.wrapped.get(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V put(K k, V v) {
            Map<K, V> map = this.wrapped;
            synchronized (map) {
                return this.wrapped.put(k, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V remove(Object o) {
            Map<K, V> map = this.wrapped;
            synchronized (map) {
                return this.wrapped.remove(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            Map<K, V> map2 = this.wrapped;
            synchronized (map2) {
                this.wrapped.putAll(map);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Map<K, V> map = this.wrapped;
            synchronized (map) {
                this.wrapped.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<K> keySet() {
            Map<K, V> map = this.wrapped;
            synchronized (map) {
                return ImmutableSet.copyOf(this.wrapped.keySet());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<V> values() {
            Map<K, V> map = this.wrapped;
            synchronized (map) {
                return ImmutableSet.copyOf(this.wrapped.values());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Map<K, V> map = this.wrapped;
            synchronized (map) {
                return ImmutableSet.copyOf(this.wrapped.entrySet());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            Map<K, V> map = this.wrapped;
            synchronized (map) {
                return this.wrapped.equals(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Map<K, V> map = this.wrapped;
            synchronized (map) {
                return this.wrapped.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Map<K, V> map = this.wrapped;
            synchronized (map) {
                return "SynchronizedWrapper{backing=" + this.wrapped.toString() + '}';
            }
        }
    }

    private static final class SortedMapFactory
    implements MapFactory {
        private final Comparator<Object> comparator;

        private SortedMapFactory(Comparator<Object> comparator) {
            this.comparator = comparator;
        }

        @Override
        public <K, V> @NonNull ConcurrentMap<K, V> create() {
            return new ConcurrentSkipListMap(this.comparator);
        }

        public boolean equals(Object obj) {
            return obj instanceof SortedMapFactory && this.comparator.equals(((SortedMapFactory)obj).comparator);
        }

        public int hashCode() {
            return this.comparator.hashCode();
        }

        public String toString() {
            return "SortedMapFactory{comparator=" + this.comparator + '}';
        }
    }

    private static enum DefaultFactory implements MapFactory
    {
        UNORDERED{

            @Override
            public <K, V> @NonNull ConcurrentMap<K, V> create() {
                return new ConcurrentHashMap();
            }
        }
        ,
        SORTED_NATURAL{

            @Override
            public <K, V> @NonNull ConcurrentMap<K, V> create() {
                return new ConcurrentSkipListMap();
            }
        }
        ,
        INSERTION_ORDERED{

            @Override
            public <K, V> @NonNull ConcurrentMap<K, V> create() {
                return new SynchronizedWrapper(new LinkedHashMap());
            }
        };

    }
}

