/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.util;

import com.google.common.primitives.Ints;
import gcewing.sg.BaseUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldSavedData;

public class SGDimensionMap
extends WorldSavedData {
    public static boolean debugDimensionMap = false;
    protected List<Integer> indexToDimension = new ArrayList<Integer>();
    protected Map<Integer, Integer> dimensionToIndex = new HashMap<Integer, Integer>();

    public SGDimensionMap(String name) {
        super(name);
    }

    public static SGDimensionMap get() {
        WorldServer world = BaseUtils.getWorldForDimension(0);
        return BaseUtils.getWorldData((World)world, SGDimensionMap.class, "sgcraft-dimension_map");
    }

    public static Integer dimensionForIndex(int index) {
        return SGDimensionMap.get().getDimensionForIndex(index);
    }

    protected Integer getDimensionForIndex(int index) {
        Integer dimension = null;
        if (index >= 0 && index < this.indexToDimension.size()) {
            dimension = this.indexToDimension.get(index);
        }
        if (debugDimensionMap) {
            System.out.printf("SGDimensionMap: Found index %s -> dimension %s\n", index, dimension);
        }
        return dimension;
    }

    public static Integer indexForDimension(int dimension) {
        return SGDimensionMap.get().getIndexForDimension(dimension);
    }

    protected Integer getIndexForDimension(int dimension) {
        if (!this.dimensionToIndex.containsKey(dimension)) {
            int index = this.indexToDimension.size();
            if (debugDimensionMap) {
                System.out.printf("SGDimensionMap: Adding dimension %s -> index %s\n", dimension, index);
            }
            this.indexToDimension.add(dimension);
            this.dimensionToIndex.put(dimension, index);
            this.func_76185_a();
            return index;
        }
        int index = this.dimensionToIndex.get(dimension);
        if (debugDimensionMap) {
            System.out.printf("SGDimensionMap: Found dimension %s -> index %s\n", dimension, index);
        }
        return index;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        if (debugDimensionMap) {
            System.out.printf("SGDimensionMap: Reading from nbt\n", new Object[0]);
        }
        int[] a = nbt.func_74759_k("dimensions");
        for (int i = 0; i < a.length; ++i) {
            this.indexToDimension.add(a[i]);
            this.dimensionToIndex.put(a[i], i);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        if (debugDimensionMap) {
            System.out.printf("SGDimensionMap: Writing to nbt\n", new Object[0]);
        }
        int[] a = Ints.toArray(this.indexToDimension);
        nbt.func_74783_a("dimensions", a);
        return nbt;
    }
}

