/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.generator;

import gcewing.sg.BaseOrientation;
import gcewing.sg.SGCraft;
import gcewing.sg.block.SGRingBlock;
import gcewing.sg.generator.FeatureGeneration;
import gcewing.sg.generator.GeneratorAddressRegistry;
import gcewing.sg.tileentity.DHDTE;
import gcewing.sg.tileentity.SGBaseTE;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class FeatureStargate
extends StructureComponent {
    StructureComponent base;
    boolean generateStructure = false;
    boolean generateChevronUpgrade = false;
    boolean generateZpmChest = false;
    boolean generateTokra = false;
    boolean taintedZpm = false;
    boolean generateSubmerged = false;
    boolean generateBuried = false;
    boolean generateRuined = false;
    int gateType = 1;
    int gateX = 0;
    int gateY = 0;
    int gateZ = 0;
    BlockPos gatePos = null;
    EnumFacing gateFaces = null;
    ItemStack[] gateCamo = new ItemStack[5];
    int dhdX = 0;
    int dhdY = 0;
    int dhdZ = 0;
    BlockPos dhdPos = null;
    EnumFacing dhdFaces = null;
    int chestX = 0;
    int chestY = 0;
    int chestZ = 0;
    BlockPos chestPos = null;
    EnumFacing chestFaces = null;
    int pass = 0;
    BlockPos centerPos = null;
    int firstY = -1;
    EnumFacing spawnDirection = null;

    public FeatureStargate() {
    }

    public FeatureStargate(StructureComponent base) {
        super(0);
        this.base = base;
    }

    public FeatureStargate(StructureComponent base, StructureBoundingBox box) {
        super(0);
        this.base = base;
        this.field_74887_e = box;
    }

    protected void func_143011_b(NBTTagCompound compound, TemplateManager templateManager) {
    }

    protected void func_143012_a(NBTTagCompound compound) {
    }

    public boolean func_74875_a(World world, Random rand, StructureBoundingBox clip) {
        return this.generateStructure && this.addAugmentationParts(world, rand, clip);
    }

    protected boolean addAugmentationParts(World world, Random rand, StructureBoundingBox clip) {
        return true;
    }

    public void updateBoundingBox(StructureBoundingBox box) {
        this.field_74887_e = box;
    }

    public void GenerateSimpleStargatePlatform(World world, StructureBoundingBox clip, Block stairBlock, IBlockState platformBlock, IBlockState randHighBlock, IBlockState randLowBlock) {
        int sizeX = 8;
        int sizeZ = 8;
        StructureBoundingBox box = this.func_74874_b();
        IBlockState air = Blocks.field_150350_a.func_176223_P();
        IBlockState stairsN = stairBlock.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH);
        IBlockState stairsS = stairBlock.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH);
        IBlockState stairsE = stairBlock.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST);
        IBlockState stairsW = stairBlock.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST);
        IBlockState stairsNE = stairsN.func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.OUTER_LEFT);
        IBlockState stairsSW = stairsS.func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.OUTER_RIGHT);
        IBlockState id = null;
        this.func_175804_a(world, clip, 0, -4, 0, 8, -1, 8, platformBlock, platformBlock, false);
        Random rand = new Random();
        int minX = 0;
        int maxX = sizeX;
        int minZ = 0;
        int maxZ = sizeZ;
        int useY = 0;
        int randBrick = 0;
        Block edge = null;
        Block edge2 = null;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                edge = null;
                id = null;
                if (x == minX && z == minZ) {
                    edge = world.func_180495_p(new BlockPos(box.field_78897_a + minX, box.field_78895_b + useY, box.field_78896_c + minZ - 1)).func_177230_c();
                    edge2 = world.func_180495_p(new BlockPos(box.field_78897_a + minX - 1, box.field_78895_b + useY, box.field_78896_c + minZ)).func_177230_c();
                } else if (x == maxX && z == minZ) {
                    edge = world.func_180495_p(new BlockPos(box.field_78897_a + maxX, box.field_78895_b + useY, box.field_78896_c + minZ - 1)).func_177230_c();
                    edge2 = world.func_180495_p(new BlockPos(box.field_78897_a + maxX + 1, box.field_78895_b + useY, box.field_78896_c + minZ)).func_177230_c();
                } else if (x == minX && z == maxZ) {
                    edge = world.func_180495_p(new BlockPos(box.field_78897_a + minX - 1, box.field_78895_b + useY, box.field_78896_c + maxZ)).func_177230_c();
                    edge2 = world.func_180495_p(new BlockPos(box.field_78897_a + minX, box.field_78895_b + useY, box.field_78896_c + maxZ + 1)).func_177230_c();
                } else if (x == maxX && z == maxZ) {
                    edge = world.func_180495_p(new BlockPos(box.field_78897_a + maxX + 1, box.field_78895_b + useY, box.field_78896_c + maxZ)).func_177230_c();
                    edge2 = world.func_180495_p(new BlockPos(box.field_78897_a + maxX, box.field_78895_b + useY, box.field_78896_c + maxZ + 1)).func_177230_c();
                }
                if (edge != null && edge2 != null) {
                    if (edge == Blocks.field_150355_j || edge2 == Blocks.field_150355_j) {
                        id = randHighBlock;
                    } else if (edge != Blocks.field_150350_a || edge2 != Blocks.field_150350_a) {
                        id = randLowBlock;
                    }
                }
                if (id == null) {
                    edge = null;
                    if (z == minZ) {
                        edge = world.func_180495_p(new BlockPos(box.field_78897_a + x, box.field_78895_b + useY, box.field_78896_c + minZ - 1)).func_177230_c();
                    } else if (z == maxZ) {
                        edge = world.func_180495_p(new BlockPos(box.field_78897_a + x, box.field_78895_b + useY, box.field_78896_c + maxZ + 1)).func_177230_c();
                    } else if (x == minX) {
                        edge = world.func_180495_p(new BlockPos(box.field_78897_a + minX - 1, box.field_78895_b + useY, box.field_78896_c + z)).func_177230_c();
                    } else if (x == maxX) {
                        edge = world.func_180495_p(new BlockPos(box.field_78897_a + maxX + 1, box.field_78895_b + useY, box.field_78896_c + z)).func_177230_c();
                    }
                    if (edge != null) {
                        if (edge == Blocks.field_150355_j) {
                            id = randHighBlock;
                        } else if (edge != Blocks.field_150350_a) {
                            id = randLowBlock;
                        }
                    }
                }
                if (id == null) {
                    id = x == minX && z > minZ && z < maxZ ? stairsE : (x == maxX && z > minZ && z < maxZ ? stairsW : (z == minZ && x > minX && x < maxX ? stairsN : (z == maxZ && x > minX && x < maxX ? stairsS : (x == minX && z == minZ ? stairsNE : (x == minX && z == maxZ ? stairsSW : (x == maxX && z == minZ ? stairsNE : (x == maxX && z == maxZ ? stairsSW : ((randBrick = rand.nextInt(40)) < 15 ? randHighBlock : (randBrick < 19 ? randLowBlock : platformBlock)))))))));
                }
                if (id == null) continue;
                this.func_175811_a(world, id, x, useY, z, clip);
            }
        }
        if (this.spawnDirection == EnumFacing.NORTH) {
            this.gateX = 4;
            this.gateY = 1;
            this.gateZ = 6;
            this.gateFaces = EnumFacing.SOUTH;
            this.dhdX = 6;
            this.dhdY = 1;
            this.dhdZ = 2;
            this.dhdFaces = EnumFacing.SOUTH;
            this.chestX = 2;
            this.chestY = 1;
            this.chestZ = 2;
            this.chestFaces = EnumFacing.SOUTH;
        } else if (this.spawnDirection == EnumFacing.SOUTH) {
            this.gateX = 4;
            this.gateY = 1;
            this.gateZ = 2;
            this.gateFaces = EnumFacing.NORTH;
            this.dhdX = 6;
            this.dhdY = 1;
            this.dhdZ = 6;
            this.dhdFaces = EnumFacing.NORTH;
            this.chestX = 2;
            this.chestY = 1;
            this.chestZ = 6;
            this.chestFaces = EnumFacing.NORTH;
        } else if (this.spawnDirection == EnumFacing.EAST) {
            this.gateX = 2;
            this.gateY = 1;
            this.gateZ = 4;
            this.gateFaces = EnumFacing.WEST;
            this.dhdX = 6;
            this.dhdY = 1;
            this.dhdZ = 2;
            this.dhdFaces = EnumFacing.WEST;
            this.chestX = 6;
            this.chestY = 1;
            this.chestZ = 6;
            this.chestFaces = EnumFacing.EAST;
        } else if (this.spawnDirection == EnumFacing.WEST) {
            this.gateX = 6;
            this.gateY = 1;
            this.gateZ = 4;
            this.gateFaces = EnumFacing.EAST;
            this.dhdX = 2;
            this.dhdY = 1;
            this.dhdZ = 2;
            this.dhdFaces = EnumFacing.EAST;
            this.chestX = 2;
            this.chestY = 1;
            this.chestZ = 6;
            this.chestFaces = EnumFacing.WEST;
        }
        this.gatePos = new BlockPos(box.field_78897_a + this.gateX, box.field_78895_b + this.gateY, box.field_78896_c + this.gateZ);
        this.dhdPos = new BlockPos(box.field_78897_a + this.dhdX, box.field_78895_b + this.dhdY, box.field_78896_c + this.dhdZ);
        this.chestPos = new BlockPos(box.field_78897_a + this.chestX, box.field_78895_b + this.chestY, box.field_78896_c + this.chestZ);
        this.GenerateStargate(world, clip, true);
        this.GenerateStargateStairs(world, clip, stairBlock);
        this.GenerateDHD(world, clip);
        this.GenerateChest(world, clip);
        this.GenerateTokRa(world, clip);
    }

    public void GenerateStargateStairs(World world, StructureBoundingBox clip, Block stairBlock) {
        IBlockState stairsN = stairBlock.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH);
        IBlockState stairsS = stairBlock.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH);
        IBlockState stairsE = stairBlock.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST);
        IBlockState stairsW = stairBlock.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST);
        IBlockState stairsNE = stairsN.func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.OUTER_LEFT);
        IBlockState stairsSW = stairsS.func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.OUTER_RIGHT);
        int minX = this.gateX - 1;
        int minZ = this.gateZ - 3;
        int maxX = this.gateX + 1;
        int maxZ = this.gateZ + 3;
        if (this.gateFaces == EnumFacing.NORTH || this.gateFaces == EnumFacing.SOUTH) {
            minX = this.gateX - 3;
            minZ = this.gateZ - 1;
            maxX = this.gateX + 3;
            maxZ = this.gateZ + 1;
        }
        IBlockState id = null;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                id = null;
                if (x > minX && x < maxX && z == minZ) {
                    id = stairsN;
                } else if (x > minX && x < maxX && z == maxZ) {
                    id = stairsS;
                } else if (z > minZ && z < maxZ && x == minX) {
                    id = stairsE;
                } else if (z > minZ && z < maxZ && x == maxX) {
                    id = stairsW;
                } else if (x == minX && z == minZ) {
                    id = stairsNE;
                } else if (x == maxX && z == maxZ) {
                    id = stairsSW;
                } else if (x == minX && z == maxZ) {
                    id = stairsSW;
                } else if (x == maxX && z == minZ) {
                    id = stairsNE;
                }
                if (id == null) continue;
                this.func_175811_a(world, id, x, this.gateY, z, clip);
            }
        }
    }

    public void recalcGatePos() {
        if (this.field_74887_e != null) {
            this.gatePos = new BlockPos(this.field_74887_e.field_78897_a + this.gateX, this.field_74887_e.field_78895_b + this.gateY, this.field_74887_e.field_78896_c + this.gateZ);
        }
    }

    public void GenerateStargate(World world, StructureBoundingBox clip, boolean gateVertical) {
        IBlockState[] sgRings;
        boolean debug = false;
        if (this.pass == 3 && FeatureGeneration.debugStructures) {
            debug = true;
        }
        IBlockState id = null;
        IBlockState air = Blocks.field_150350_a.func_176223_P();
        IBlockState sgBase = SGCraft.sgBaseBlock.func_176223_P().func_177226_a(BaseOrientation.Orient4WaysByState.FACING, (Comparable)this.gateFaces);
        sgRings = new IBlockState[]{SGCraft.sgRingBlock.func_176223_P(), sgRings[0].func_177226_a(SGRingBlock.VARIANT, (Comparable)Integer.valueOf(1))};
        boolean orientNS = false;
        if (this.gateFaces == EnumFacing.NORTH || this.gateFaces == EnumFacing.SOUTH) {
            orientNS = true;
        }
        if (debug) {
            System.out.println("Stargate built at: " + this.gatePos);
        }
        if (gateVertical) {
            for (int i = -2; i <= 2; ++i) {
                for (int j = 0; j <= 4; ++j) {
                    id = i == 0 && j == 0 ? sgBase : (i == -2 || i == 2 || j == 0 || j == 4 ? sgRings[i + j + 1 & 1] : air);
                    if (orientNS) {
                        this.func_175811_a(world, id, this.gateX + i, this.gateY + j, this.gateZ, clip);
                        continue;
                    }
                    this.func_175811_a(world, id, this.gateX, this.gateY + j, this.gateZ + i, clip);
                }
            }
        } else {
            System.out.println("Stargate attempted to spawn Horizontal, but that code is not done yet!");
            return;
        }
        SGBaseTE te = null;
        if (this.gatePos != null) {
            te = (SGBaseTE)world.func_175625_s(this.gatePos);
        }
        if (te != null) {
            if (this.generateChevronUpgrade) {
                te.hasChevronUpgrade = true;
                if (debug) {
                    System.out.println("Stargate granted chevron upgrade.");
                }
            }
            for (int x = 0; x < 5; ++x) {
                if (this.gateCamo[x] == null) continue;
                te.getInventory().func_70299_a(x, this.gateCamo[x].func_77946_l());
            }
            te.gateType = this.gateType;
            if (debug) {
                System.out.println("Stargate is type " + this.gateType);
            }
            te.markChanged();
            if (te.homeAddress != null) {
                GeneratorAddressRegistry.addAddress(te.func_145831_w(), te.homeAddress);
                te.canPlayerBreakGate = SGBaseTE.cfg.getBoolean("stargate", "canPlayerBreakGate", true);
            }
            if (te.homeAddress == null && this.pass >= 3) {
                System.err.println("Something bad happened!!! please report to Dockter:  unable to assign home address during generation");
            }
        } else if (this.pass == 3) {
            System.err.println("SGCraft: FeatureGeneration is done and Stargate TE was null! That's bad. gatePos " + this.gatePos + " and spawnDirection " + this.spawnDirection);
        }
    }

    public void GenerateDHD(World world, StructureBoundingBox clip) {
        IBlockState dhd = SGCraft.sgControllerBlock.func_176223_P().func_177226_a(BaseOrientation.Orient4WaysByState.FACING, (Comparable)this.dhdFaces);
        boolean debug = false;
        if (this.pass == 3 && FeatureGeneration.debugStructures) {
            debug = true;
        }
        this.func_175811_a(world, dhd, this.dhdX, this.dhdY, this.dhdZ, clip);
        if (debug) {
            System.out.println("DHD built at: " + this.dhdPos);
        }
        DHDTE dhdte = null;
        if (this.dhdPos != null) {
            dhdte = (DHDTE)world.func_175625_s(this.dhdPos);
        }
        if (dhdte != null) {
            ItemStack naquadahPieces = new ItemStack(SGCraft.naquadah, 3);
            dhdte.getInventory().func_70299_a(0, naquadahPieces);
        } else if (this.pass == 3) {
            System.err.println("SGCraft: FeatureGeneration is done and DHD TE was null! That's bad. dhdPos " + this.dhdPos + " and spawnDirection " + this.spawnDirection);
        }
    }

    public void GenerateChest(World world, StructureBoundingBox clip) {
        IBlockState air = Blocks.field_150350_a.func_176223_P();
        IBlockState chest = Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)this.chestFaces);
        boolean debug = false;
        if (this.pass == 3 && FeatureGeneration.debugStructures) {
            debug = true;
        }
        if (this.generateZpmChest) {
            if (SGCraft.zpm == null) {
                return;
            }
            this.func_175811_a(world, air, this.chestX, this.chestY, this.chestZ, clip);
            this.func_175811_a(world, chest, this.chestX, this.chestY, this.chestZ, clip);
            TileEntityChest chestTE = null;
            if (this.chestPos != null) {
                chestTE = (TileEntityChest)world.func_175625_s(this.chestPos);
            }
            if (chestTE != null) {
                ItemStack zpm;
                if (debug) {
                    System.out.println("Generating ZPM Chest at: " + this.chestPos);
                }
                if ((zpm = new ItemStack(SGCraft.zpm, 1)) != null) {
                    NBTTagCompound tag = zpm.func_77978_p();
                    if (tag == null) {
                        tag = new NBTTagCompound();
                    }
                    zpm.func_77982_d(tag);
                    tag.func_74780_a("AvailableEnergy", 2.147483647E9);
                    tag.func_74757_a("loadedIntoCart", false);
                    if (this.taintedZpm) {
                        zpm.func_77966_a(Enchantment.func_185262_c((int)51), 1);
                    }
                    if (chestTE.func_191420_l()) {
                        chestTE.getSingleChestHandler().insertItem(0, zpm, false);
                    }
                }
            } else if (this.pass == 3) {
                System.err.println("FeatureGeneration is done and ZPM Chest TE was null! That's bad. chestPos: " + this.chestPos + " and spawnDirection " + this.spawnDirection);
            }
        }
    }

    public void GenerateTokRa(World world, StructureBoundingBox clip) {
        if (this.generateTokra && this.pass == 3) {
            if (this.chestPos == null && FeatureGeneration.debugStructures) {
                System.err.println("Tried to spawn a Tok'Ra but chestPos was null!");
                return;
            }
            EntityVillager entityvillager = new EntityVillager(world);
            entityvillager.func_70012_b((double)this.chestPos.func_177958_n() + 0.5, (double)this.chestPos.func_177956_o() + 2.0, (double)this.chestPos.func_177952_p() + 0.5, 0.0f, 0.0f);
            entityvillager.func_70938_b(VillagerRegistry.getId((VillagerRegistry.VillagerProfession)SGCraft.tokraProfession));
            entityvillager.func_190672_a(world.func_175649_E(new BlockPos((Entity)entityvillager)), (IEntityLivingData)null, false);
            world.func_72838_d((Entity)entityvillager);
        }
    }

    public static Block getBiomeStairblock(Biome biome) {
        if (biome == Biomes.field_76769_d) {
            return Blocks.field_150372_bz;
        }
        if (biome == Biomes.field_76772_c) {
            return Blocks.field_150390_bg;
        }
        if (biome == Biomes.field_150588_X) {
            return Blocks.field_150446_ar;
        }
        if (biome == Biomes.field_76768_g) {
            return Blocks.field_150390_bg;
        }
        return Blocks.field_150390_bg;
    }

    public static Block getBiomeCamoblock(Biome biome) {
        if (biome == Biomes.field_76769_d) {
            return Blocks.field_150322_A;
        }
        if (biome == Biomes.field_76772_c) {
            return Blocks.field_150417_aV;
        }
        if (biome == Biomes.field_150588_X) {
            return Blocks.field_150347_e;
        }
        if (biome == Biomes.field_76768_g) {
            return Blocks.field_150417_aV;
        }
        return Blocks.field_150417_aV;
    }

    public static IBlockState getBiomePlatformblock(Biome biome) {
        if (biome == Biomes.field_76769_d) {
            return Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH);
        }
        if (biome == Biomes.field_76772_c) {
            return Blocks.field_150417_aV.func_176223_P();
        }
        if (biome == Biomes.field_150588_X) {
            return Blocks.field_150347_e.func_176223_P();
        }
        if (biome == Biomes.field_76768_g) {
            return Blocks.field_150417_aV.func_176223_P();
        }
        return Blocks.field_150417_aV.func_176223_P();
    }

    public static IBlockState getBiomeRandblockHigh(Biome biome) {
        if (biome == Biomes.field_76769_d) {
            return Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH);
        }
        if (biome == Biomes.field_76772_c) {
            return Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.MOSSY);
        }
        if (biome == Biomes.field_150588_X) {
            return Blocks.field_150348_b.func_176223_P();
        }
        if (biome == Biomes.field_76768_g) {
            return Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CRACKED);
        }
        return Blocks.field_150417_aV.func_176223_P();
    }

    public static IBlockState getBiomeRandblockLow(Biome biome) {
        if (biome == Biomes.field_76769_d) {
            return Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.CHISELED);
        }
        if (biome == Biomes.field_76772_c) {
            return Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CRACKED);
        }
        if (biome == Biomes.field_150588_X) {
            return Blocks.field_150351_n.func_176223_P();
        }
        if (biome == Biomes.field_76768_g) {
            return Blocks.field_150351_n.func_176223_P();
        }
        return Blocks.field_150417_aV.func_176223_P();
    }

    public static int getSurfaceLevel(World world, BlockPos loc) {
        BlockPos startPos = world.func_175672_r(loc);
        Object check = null;
        int curX = startPos.func_177958_n();
        int curY = startPos.func_177956_o();
        int curZ = startPos.func_177952_p();
        int maxTries = 10;
        for (int tries = 0; tries <= maxTries; ++tries) {
            if (world.func_180495_p(new BlockPos(curX, curY + tries, curZ)).func_177230_c() == Blocks.field_150355_j) continue;
            return curY + tries;
        }
        return curY + maxTries;
    }

    public static int getJungleTempleTop(World world, BlockPos centerPos) {
        int curX = centerPos.func_177958_n();
        int curY = centerPos.func_177956_o();
        int curZ = centerPos.func_177952_p();
        Block temp = null;
        for (int tries = 255; tries >= 0; --tries) {
            temp = world.func_180495_p(new BlockPos(curX, tries, curZ)).func_177230_c();
            if (temp != Blocks.field_150341_Y && temp != Blocks.field_150446_ar && temp != Blocks.field_150347_e) continue;
            return tries;
        }
        System.err.println("No jungle temple found! whoops.");
        return -1;
    }

    public static EnumFacing getOppDirection(EnumFacing origDir) {
        if (origDir == EnumFacing.NORTH) {
            return EnumFacing.SOUTH;
        }
        if (origDir == EnumFacing.SOUTH) {
            return EnumFacing.NORTH;
        }
        if (origDir == EnumFacing.EAST) {
            return EnumFacing.WEST;
        }
        return EnumFacing.EAST;
    }
}

