/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.features.pdd.client.gui;

import com.google.common.eventbus.Subscribe;
import gcewing.sg.SGCraft;
import gcewing.sg.features.pdd.AddressData;
import gcewing.sg.features.pdd.client.gui.GState;
import gcewing.sg.features.pdd.client.gui.PddEntryScreen;
import gcewing.sg.features.pdd.network.PddNetworkHandler;
import gcewing.sg.tileentity.DHDTE;
import gcewing.sg.tileentity.SGBaseTE;
import gcewing.sg.tileentity.data.GateAccessData;
import gcewing.sg.util.GateUtil;
import gcewing.sg.util.SGAddressing;
import gcewing.sg.util.SGState;
import java.util.List;
import net.malisis.core.client.gui.Anchor;
import net.malisis.core.client.gui.BasicScreen;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.BasicContainer;
import net.malisis.core.client.gui.component.container.BasicForm;
import net.malisis.core.client.gui.component.container.BasicList;
import net.malisis.core.client.gui.component.decoration.UILabel;
import net.malisis.core.client.gui.component.decoration.UISeparator;
import net.malisis.core.client.gui.component.interaction.UIButton;
import net.malisis.core.client.gui.component.interaction.button.builder.UIButtonBuilder;
import net.malisis.core.renderer.font.FontOptions;
import net.malisis.core.util.FontColors;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class PddScreen
extends BasicScreen {
    private int lastUpdate = 0;
    private boolean unlockMouse = true;
    private boolean isAdmin;
    private BasicForm form;
    private BasicContainer<?> addressContainer;
    private UIButton addAddressButton;
    private UIButton editAddressButton;
    private UIButton deleteAddressButton;
    private UIButton buttonReset;
    private UIButton closeButton;
    private UIButton buttonDial;
    private UIButton buttonDisconnect;
    private UILabel localGateAddressLabel;
    private UILabel gateStatusLabel;
    private UILabel availableAddressesLabel;
    private UILabel addressTextureLabel;
    private UILabel userFeedbackLabel;
    private UISeparator valuesSeparator;
    private BlockPos location;
    private World world;
    private EntityPlayer player;
    private boolean delayedUpdate = true;
    private int digit = 0;
    private boolean dialling = false;
    private String enteredAddress = "";
    private String diallingAddress = "";
    private GState gstate = new GState();
    private SGBaseTE localGate = null;
    private boolean last = false;
    public boolean firstOpen = true;
    private List<AddressData> clonedList;
    private BasicList<AddressData> addressList;
    private long timer;
    static final String symbolTextureFile = "symbols48.png";
    static final int symbolsPerRowInTexture = 10;
    static final int symbolWidthInTexture = 48;
    static final int symbolHeightInTexture = 48;
    static final int symbolTextureWidth = 512;
    static final int symbolTextureHeight = 256;
    static final int frameWidth = 236;
    static final int frameHeight = 44;
    static final int borderSize = 6;
    static final int cellSize = 24;

    public PddScreen(EntityPlayer player, World worldIn, boolean isAdmin) {
        this.player = player;
        this.isAdmin = false;
        this.world = worldIn;
        this.location = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
    }

    public void construct() {
        TileEntity dhdBaseTE;
        long timer = System.currentTimeMillis();
        this.guiscreenBackground = false;
        Keyboard.enableRepeatEvents((boolean)true);
        TileEntity localGateTE = GateUtil.locateLocalGate(this.world, this.location, 6, false);
        if (!(localGateTE instanceof SGBaseTE) && (dhdBaseTE = GateUtil.locateDHD(this.world, new BlockPos(this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v), 6, false)) instanceof DHDTE) {
            DHDTE dhd = (DHDTE)dhdBaseTE;
            if (dhd.isLinkedToStargate) {
                localGateTE = dhd.getLinkedStargateTE();
            }
        }
        if (localGateTE instanceof SGBaseTE) {
            this.localGate = (SGBaseTE)localGateTE;
        }
        this.form = new BasicForm((MalisisGui)this, 300, 225, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.pdd.label.personalDialerDevice", (Object[])new Object[0]));
        this.form.setMovable(true);
        this.form.setBackgroundAlpha(255);
        this.addressContainer = new BasicContainer((MalisisGui)this, 295, 185);
        this.addressContainer.setPosition(0, 0, Anchor.LEFT | Anchor.MIDDLE);
        this.addressContainer.setBorder(0xFFFFFF, 1, 185);
        this.addressContainer.setPadding(0, 3);
        this.addressContainer.setBackgroundAlpha(0);
        this.availableAddressesLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.pdd.label.availableAddresses", (Object[])new Object[0]) + ":");
        this.availableAddressesLabel.setPosition(5, 1, Anchor.LEFT | Anchor.TOP);
        this.localGateAddressLabel = new UILabel((MalisisGui)this, "gateAddress");
        this.localGateAddressLabel.setFontOptions(FontOptions.builder().from(FontColors.BLUE_FO).shadow(true).scale(1.0f).build());
        this.localGateAddressLabel.setPosition(-5, 1, Anchor.RIGHT | Anchor.TOP);
        this.gateStatusLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.pdd.label.dialling", (Object[])new Object[0]));
        this.gateStatusLabel.setFontOptions(FontOptions.builder().from(FontColors.BLUE_FO).shadow(true).scale(1.8f).build());
        this.gateStatusLabel.setPosition(-5, 50, Anchor.CENTER | Anchor.TOP);
        this.gateStatusLabel.setVisible(true);
        this.addressTextureLabel = new UILabel((MalisisGui)this, "... template ...");
        this.addressTextureLabel.setFontOptions(FontOptions.builder().from(FontColors.BLUE_FO).shadow(true).scale(1.8f).build());
        this.addressTextureLabel.setPosition(-5, 60, Anchor.CENTER | Anchor.TOP);
        this.addressTextureLabel.setVisible(false);
        this.valuesSeparator = new UISeparator((MalisisGui)this);
        this.valuesSeparator.setSize(this.addressContainer.getWidth() - 55, 1);
        this.valuesSeparator.setPosition(0, 70, Anchor.TOP | Anchor.CENTER);
        this.addressList = new BasicList((MalisisGui)this, 0, this.addressContainer.getHeight() - 14);
        this.addressList.setPosition(0, BasicScreen.getPaddedY((UIComponent)this.availableAddressesLabel, (int)2));
        this.addressList.setItemComponentFactory((x$0, x$1, x$2) -> new AddressItemComponent((MalisisGui)x$0, (BasicList<AddressData>)x$1, (AddressData)x$2));
        this.addressList.setItemComponentSpacing(1);
        this.addressList.setPadding(2);
        this.addressList.setBorder(0xFFFFFF, 1, 185);
        this.addressList.setBorders(0xFFFFFF, 185, 0, 1, 0, 0);
        this.addressList.setName("List");
        this.addressList.register((Object)this);
        this.addressContainer.add(new UIComponent[]{this.availableAddressesLabel, this.localGateAddressLabel, this.gateStatusLabel, this.addressTextureLabel, this.addressList});
        this.addAddressButton = new UIButtonBuilder((MalisisGui)this).text(TextFormatting.GREEN + "+").onClick(() -> new PddEntryScreen(this, this.player, "Name Here", "Address Here", 10, 0, false, false, 1).display()).anchor(Anchor.BOTTOM | Anchor.LEFT).position(0, 0).build("button.add");
        this.deleteAddressButton = new UIButtonBuilder((MalisisGui)this).text(TextFormatting.RED + "-").onClick(() -> {
            if (this.addressList.getSelectedItem() != null && !((AddressData)this.addressList.getSelectedItem()).isLocked()) {
                new PddEntryScreen(this, this.player, ((AddressData)this.addressList.getSelectedItem()).getName(), ((AddressData)this.addressList.getSelectedItem()).getAddress(), ((AddressData)this.addressList.getSelectedItem()).getIndex(), ((AddressData)this.addressList.getSelectedItem()).getUnid(), ((AddressData)this.addressList.getSelectedItem()).isLocked(), true, 3).display();
            }
        }).anchor(Anchor.BOTTOM | Anchor.LEFT).position(BasicScreen.getPaddedX((UIComponent)this.addAddressButton, (int)2), 0).build("button.remove");
        this.editAddressButton = new UIButtonBuilder((MalisisGui)this).text(TextFormatting.YELLOW + "?").onClick(() -> new PddEntryScreen(this, this.player, ((AddressData)this.addressList.getSelectedItem()).getName(), ((AddressData)this.addressList.getSelectedItem()).getAddress(), ((AddressData)this.addressList.getSelectedItem()).getIndex(), ((AddressData)this.addressList.getSelectedItem()).getUnid(), ((AddressData)this.addressList.getSelectedItem()).isLocked(), false, 2).display()).anchor(Anchor.BOTTOM | Anchor.LEFT).position(BasicScreen.getPaddedX((UIComponent)this.deleteAddressButton, (int)2), 0).build("button.details");
        this.buttonDial = new UIButtonBuilder((MalisisGui)this).width(40).anchor(Anchor.BOTTOM | Anchor.CENTER).text(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.button.dialSelectedAddress", (Object[])new Object[0])).visible(false).onClick(() -> this.dial()).build("button.dial");
        this.buttonReset = new UIButtonBuilder((MalisisGui)this).width(40).anchor(Anchor.BOTTOM | Anchor.CENTER).text(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.button.reset", (Object[])new Object[0])).visible(false).onClick(() -> this.resetGui()).build("button.reset");
        this.buttonDisconnect = new UIButtonBuilder((MalisisGui)this).width(40).anchor(Anchor.BOTTOM | Anchor.CENTER).text(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.button.disconnect", (Object[])new Object[0])).visible(false).onClick(() -> {
            TileEntity localGate = GateUtil.locateLocalGate(this.world, this.location, 6, false);
            if (!(localGate instanceof SGBaseTE)) {
                return;
            }
            if (localGate != null) {
                PddNetworkHandler.sendPddInputToServer((SGBaseTE)localGate, 2, "", "");
            }
        }).build("button.disconnect");
        UIButton buttonClose = new UIButtonBuilder((MalisisGui)this).width(40).anchor(Anchor.BOTTOM | Anchor.RIGHT).text(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.button.close", (Object[])new Object[0])).onClick(() -> ((PddScreen)this).close()).build("button.close");
        this.userFeedbackLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.pdd.label.warning", (Object[])new Object[0]));
        this.userFeedbackLabel.setPosition(-15, -3, Anchor.CENTER | Anchor.BOTTOM);
        this.form.add(new UIComponent[]{this.addressContainer, this.addAddressButton, this.editAddressButton, this.deleteAddressButton, this.buttonDial, this.buttonReset, this.buttonDisconnect, this.userFeedbackLabel, buttonClose});
        this.addToScreen((UIComponent)this.form);
    }

    @Subscribe
    public void onListChange(BasicList.SelectEvent<GateAccessData> event) {
        if (this.addressList.getSize() == 0) {
            this.deleteAddressButton.setEnabled(false);
            this.editAddressButton.setEnabled(false);
            this.buttonDial.setEnabled(false);
        } else {
            this.deleteAddressButton.setEnabled(true);
            this.editAddressButton.setEnabled(true);
            this.buttonDial.setEnabled(true);
        }
    }

    public void update(int mouseX, int mouseY, float partialTick) {
        super.update(mouseX, mouseY, partialTick);
        if (this.unlockMouse && this.lastUpdate == 25) {
            Mouse.setGrabbed((boolean)false);
            this.unlockMouse = false;
        }
        this.refresh();
        this.detectChange();
        if (System.currentTimeMillis() > this.timer + 750L) {
            this.checkDiallingStatus();
            this.timer = System.currentTimeMillis();
        }
        if (++this.lastUpdate > 125) {
            this.lastUpdate = 0;
        }
    }

    private void refresh() {
        if (this.localGate != null) {
            if (this.localGate.isMerged) {
                this.localGateAddressLabel.setText(SGAddressing.formatAddress(this.localGate.homeAddress, "-", "-"));
            } else {
                this.localGateAddressLabel.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.pdd.label.noLocalStargateFound", (Object[])new Object[0]));
            }
            if (this.localGate != null) {
                if (this.dialling || this.last || this.localGate.state == SGState.SyncAwait || this.localGate.state == SGState.Transient) {
                    this.buttonDial.setVisible(false);
                    this.addressList.setVisible(false);
                    this.availableAddressesLabel.setVisible(false);
                    this.localGateAddressLabel.setVisible(false);
                    if (this.localGate.state == SGState.SyncAwait || this.localGate.state == SGState.Transient) {
                        this.gateStatusLabel.setText(I18n.func_135052_a((String)"sgcraft.gui.pdd.label.establishing", (Object[])new Object[0]));
                        this.gateStatusLabel.setFontOptions(FontOptions.builder().from(FontColors.GREEN_FO).shadow(true).scale(1.8f).build());
                        if (this.enteredAddress.isEmpty()) {
                            this.enteredAddress = this.localGate.dialledAddress;
                        }
                    }
                } else {
                    if (this.localGate.state == SGState.Idle && !this.localGate.errorState && !this.dialling) {
                        this.addressList.setVisible(true);
                        this.buttonDial.setVisible(true);
                        this.localGateAddressLabel.setVisible(true);
                        this.availableAddressesLabel.setVisible(true);
                        this.buttonReset.setVisible(false);
                    }
                    if (this.localGate.state == SGState.Dialling) {
                        if (this.enteredAddress.isEmpty()) {
                            this.enteredAddress = this.localGate.dialledAddress;
                        }
                        if (this.diallingAddress.isEmpty()) {
                            this.diallingAddress = this.enteredAddress;
                        }
                        this.addressList.setVisible(false);
                        this.buttonDisconnect.setVisible(true);
                        this.gateStatusLabel.setFontOptions(FontOptions.builder().from(FontColors.BLUE_FO).shadow(true).scale(1.8f).build());
                        this.gateStatusLabel.setText(I18n.func_135052_a((String)"sgcraft.gui.pdd.label.dialing", (Object[])new Object[0]));
                        this.buttonReset.setVisible(true);
                    }
                    if (this.localGate.state == SGState.Disconnecting) {
                        this.addressList.setVisible(false);
                        this.gateStatusLabel.setFontOptions(FontOptions.builder().from(FontColors.YELLOW_FO).shadow(true).scale(1.8f).build());
                        this.gateStatusLabel.setText(I18n.func_135052_a((String)"sgcraft.gui.pdd.label.disconnecting", (Object[])new Object[0]));
                    }
                    if (this.localGate.state == SGState.Connected) {
                        if (this.enteredAddress.isEmpty()) {
                            this.enteredAddress = this.localGate.dialledAddress;
                        }
                        if (this.diallingAddress.isEmpty()) {
                            this.diallingAddress = this.enteredAddress;
                        }
                        this.addressList.setVisible(false);
                        this.buttonDisconnect.setVisible(true);
                        this.gateStatusLabel.setText(I18n.func_135052_a((String)"sgcraft.gui.pdd.label.connected", (Object[])new Object[0]));
                        this.gateStatusLabel.setFontOptions(FontOptions.builder().from(FontColors.BLUE_FO).shadow(true).scale(1.8f).build());
                    }
                }
                if (this.localGate.errorState) {
                    this.addressList.setVisible(false);
                    this.buttonDisconnect.setVisible(true);
                    this.gateStatusLabel.setFontOptions(FontOptions.builder().from(FontColors.RED_FO).shadow(true).scale(1.8f).build());
                    this.gateStatusLabel.setText(I18n.func_135052_a((String)"sgcraft.gui.pdd.label.error", (Object[])new Object[0]));
                    this.diallingAddress = this.localGate.dialledAddress;
                    this.dialling = false;
                    this.buttonDial.setVisible(false);
                    this.buttonReset.setVisible(true);
                }
                if (!this.addressList.isVisible() && this.localGate.state != SGState.Disconnecting && !this.gateStatusLabel.getText().equalsIgnoreCase("... Error ...")) {
                    this.drawAddressSymbols(this.getXStartLocation(this.diallingAddress), this.gateStatusLabel.screenY() + 40, this.enteredAddress);
                }
                if (this.localGate.isConnected() && this.localGate.state == SGState.Connected) {
                    this.last = false;
                    this.buttonDial.setVisible(false);
                    this.buttonReset.setVisible(false);
                    this.buttonDisconnect.setVisible(true);
                    this.buttonDisconnect.setEnabled(true);
                } else {
                    this.buttonDisconnect.setVisible(false);
                }
                this.addAddressButton.setVisible(this.addressList.isVisible());
                this.deleteAddressButton.setVisible(this.addressList.isVisible());
                this.editAddressButton.setVisible(this.addressList.isVisible());
                this.availableAddressesLabel.setVisible(this.addressList.isVisible());
                this.localGateAddressLabel.setVisible(this.addressList.isVisible());
                this.valuesSeparator.setVisible(!this.addressList.isVisible());
                this.userFeedbackLabel.setVisible(!this.buttonDial.isVisible() && !this.buttonReset.isVisible() && !this.buttonDisconnect.isVisible() && this.localGate.state != SGState.Disconnecting);
                this.gateStatusLabel.setVisible(!this.addressList.isVisible());
            }
        }
    }

    private void dial() {
        this.timer = System.currentTimeMillis();
        if (this.addressList.getSize() > 0 && this.addressList.getSelectedItem() != null && !((AddressData)this.addressList.getSelectedItem()).getAddress().isEmpty()) {
            this.resetGui();
            this.lastUpdate = 0;
            if (this.localGate.chevronsLockOnDial) {
                if (!this.isAdmin) {
                    this.dialSelectedAddressLockEachChevronIndividually();
                } else {
                    this.dialSelectedAddress();
                }
            } else {
                this.dialSelectedAddress();
                this.close();
            }
        }
    }

    private void resetGui() {
        PddNetworkHandler.sendPddInputToServer(this.localGate, 4, "", "");
        this.localGate.immediateDialAddress = "";
        this.dialling = false;
        this.firstOpen = true;
        this.last = false;
        this.addressList.setVisible(true);
        this.buttonReset.setVisible(false);
        this.buttonDial.setVisible(true);
    }

    protected void func_73869_a(char keyChar, int keyCode) {
        super.func_73869_a(keyChar, keyCode);
        this.lastUpdate = 0;
    }

    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        this.lastUpdate = 0;
    }

    public boolean func_73868_f() {
        return false;
    }

    private void detectChange() {
        List<AddressData> comparedList;
        ItemStack stack = this.player.func_184614_ca();
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null && !(comparedList = AddressData.getAddresses(compound)).equals(this.clonedList)) {
            this.addressList.clearItems();
            this.clonedList = AddressData.getAddresses(compound);
            this.addressList.addItems(AddressData.getAddresses(compound));
        }
    }

    private void dialRandom() {
        TileEntity localGateTE = GateUtil.locateLocalGate(this.world, this.location, 6, false);
        if (localGateTE instanceof SGBaseTE) {
            this.localGate = (SGBaseTE)localGateTE;
        }
        if (this.localGate != null) {
            PddNetworkHandler.sendPddInputToServer(this.localGate, 3, this.localGate.homeAddress, "");
        }
    }

    private void dialSelectedAddress() {
        TileEntity localGateTE = GateUtil.locateLocalGate(this.world, this.location, 6, false);
        if (localGateTE instanceof SGBaseTE) {
            this.localGate = (SGBaseTE)localGateTE;
        }
        if (this.localGate != null && this.addressList.getSelectedItem() != null && !((AddressData)this.addressList.getSelectedItem()).getAddress().isEmpty()) {
            this.gateStatusLabel.setText(I18n.func_135052_a((String)"sgcraft.gui.pdd.label.dialing", (Object[])new Object[0]));
            String destination = ((AddressData)this.addressList.getSelectedItem()).getAddress().toUpperCase().replaceAll("-", "");
            this.enteredAddress = SGAddressing.inSameDimension(this.localGate.homeAddress, destination) ? destination.substring(0, 7) : destination.substring(0, 9);
            PddNetworkHandler.sendPddInputToServer(this.localGate, 1, this.localGate.homeAddress, destination);
        }
    }

    private void dialSelectedAddressLockEachChevronIndividually() {
        TileEntity localGateTE = GateUtil.locateLocalGate(this.world, this.location, 6, false);
        if (localGateTE instanceof SGBaseTE) {
            this.localGate = (SGBaseTE)localGateTE;
        }
        if (this.localGate != null) {
            this.enteredAddress = "";
            this.gateStatusLabel.setFontOptions(FontOptions.builder().from(FontColors.BLUE_FO).shadow(true).scale(1.8f).build());
            this.gateStatusLabel.setText(I18n.func_135052_a((String)"sgcraft.gui.pdd.label.dialing", (Object[])new Object[0]));
            this.dialling = true;
            this.digit = 0;
        }
    }

    private void checkDiallingStatus() {
        if (this.localGate != null && this.dialling && !this.localGate.errorState) {
            this.firstOpen = false;
            this.diallingAddress = ((AddressData)this.addressList.getSelectedItem()).getAddress().toUpperCase().replaceAll("-", "");
            if (SGAddressing.inSameDimension(this.localGate.homeAddress, this.diallingAddress)) {
                this.diallingAddress = this.diallingAddress.substring(0, 7);
            }
            if (this.diallingAddress.length() != 7 && this.diallingAddress.length() != 9) {
                SGBaseTE.sendErrorMsg(this.player, "malformedAddress", new Object[0]);
                this.dialling = false;
                return;
            }
            if (this.diallingAddress.length() > this.localGate.getNumChevrons()) {
                SGBaseTE.sendErrorMsg(this.player, "targetLackChevrons", new Object[0]);
                this.dialling = false;
                return;
            }
            this.addressList.setVisible(false);
            TileEntity localGateTE = GateUtil.locateLocalGate(this.world, this.location, 6, false);
            if (localGateTE instanceof SGBaseTE) {
                SGBaseTE localGate = (SGBaseTE)localGateTE;
                this.last = false;
                localGate.immediateDialAddress = this.diallingAddress;
                PddNetworkHandler.sendEnterSymbolToServer(localGate, this.diallingAddress, this.digit);
                char currentSymbol = this.diallingAddress.charAt(this.digit);
                this.enteredAddress = this.enteredAddress + currentSymbol;
                ++this.digit;
            }
            if (this.digit >= this.diallingAddress.length()) {
                this.dialling = false;
                this.last = true;
                this.digit = 0;
            }
        }
    }

    public void stopDialing() {
        this.dialling = false;
    }

    private int getXStartLocation(String address) {
        if (address.length() == 7 || address.length() == 0) {
            return this.addressTextureLabel.screenX() - 25 + this.enteredAddress.length() * 12;
        }
        return this.addressTextureLabel.screenX() - 55 + this.enteredAddress.length() * 12;
    }

    private void drawAddressSymbols(int x, int y, String address) {
        int x0 = x - address.length() * 24 / 2;
        int y0 = y + 22 - 12;
        this.bindSGTexture(symbolTextureFile, 256, 128);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        int n = address.length();
        for (int i = 0; i < n; ++i) {
            int s = SGBaseTE.charToSymbol(address.charAt(i));
            int row = s / 10;
            int col = s % 10;
            this.drawTexturedRect(x0 + i * 24, y0, 24.0, 24.0, col * 24, row * 24);
        }
    }

    private void drawTexturedRect(double x, double y, double w, double h, double u, double v) {
        this.drawTexturedRect(x, y, w, h, u, v, w, h);
    }

    private void drawTexturedRect(double x, double y, double w, double h, double u, double v, double us, double vs) {
        this.drawTexturedRectUV(x, y, w, h, u * this.gstate.uscale, v * this.gstate.vscale, us * this.gstate.uscale, vs * this.gstate.vscale);
    }

    private void drawTexturedRectUV(double x, double y, double w, double h, double u, double v, double us, double vs) {
        GL11.glBegin((int)7);
        GL11.glColor3f((float)this.gstate.red, (float)this.gstate.green, (float)this.gstate.blue);
        GL11.glTexCoord2d((double)u, (double)(v + vs));
        GL11.glVertex3d((double)x, (double)(y + h), (double)1000.0);
        GL11.glTexCoord2d((double)(u + us), (double)(v + vs));
        GL11.glVertex3d((double)(x + w), (double)(y + h), (double)1000.0);
        GL11.glTexCoord2d((double)(u + us), (double)v);
        GL11.glVertex3d((double)(x + w), (double)y, (double)1000.0);
        GL11.glTexCoord2d((double)u, (double)v);
        GL11.glVertex3d((double)x, (double)y, (double)1000.0);
        GL11.glEnd();
    }

    private void bindSGTexture(String name, int usize, int vsize) {
        this.bindTexture(SGCraft.mod.resourceLocation("textures/gui/" + name), usize, vsize);
    }

    private void bindTexture(ResourceLocation rsrc, int usize, int vsize) {
        this.gstate.texture = rsrc;
        this.field_146297_k.func_110434_K().func_110577_a(rsrc);
        this.gstate.uscale = 1.0 / (double)usize;
        this.gstate.vscale = 1.0 / (double)vsize;
    }

    private class AddressItemComponent
    extends BasicList.ItemComponent<AddressData> {
        private UILabel addressLabel;
        private UILabel nameLabel;
        private BasicContainer lockedStatusContainer;

        public AddressItemComponent(MalisisGui gui, BasicList<AddressData> parent, AddressData item) {
            super(gui, parent, (Object)item);
            this.setOnDoubleClickConsumer(i -> PddScreen.this.dial());
        }

        protected void construct(MalisisGui gui) {
            super.construct(gui);
            this.setHeight(28);
            this.setPadding(1);
            this.nameLabel = new UILabel(this.getGui(), TextFormatting.WHITE + ((AddressData)this.item).getName());
            this.nameLabel.setPosition(4, 3);
            this.addressLabel = new UILabel(this.getGui(), TextFormatting.BLUE + ((AddressData)this.item).getAddress());
            this.addressLabel.setPosition(4, BasicScreen.getPaddedY((UIComponent)this.nameLabel, (int)2));
            this.lockedStatusContainer = new BasicContainer(this.getGui(), 5, 0);
            this.lockedStatusContainer.setPosition(0, 0, Anchor.MIDDLE | Anchor.RIGHT);
            this.update();
            this.add(new UIComponent[]{this.nameLabel, this.addressLabel, this.lockedStatusContainer});
        }

        public void update() {
            this.lockedStatusContainer.setColor(((AddressData)this.item).isLocked() ? 0xAAAAAA : 0x55FF55);
        }
    }
}

