/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.features.pdd;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public final class AddressData
implements Comparable<AddressData> {
    static final String ADDRESSES = "addresses";
    private static final String NAME = "name";
    private static final String ADDRESS = "address";
    private static final String LOCKED = "locked";
    private static final String INDEX = "index";
    private static final String UNID = "unid";
    private final String name;
    private final String address;
    private final boolean locked;
    private final int index;
    private final int unid;

    public AddressData(String name, String address, boolean locked, int index, int unid) {
        this.name = name;
        this.address = address;
        this.locked = locked;
        this.index = index;
        this.unid = unid;
    }

    public String getName() {
        return this.name;
    }

    public String getAddress() {
        return this.address;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public int getIndex() {
        return this.index;
    }

    public int getUnid() {
        return this.unid;
    }

    public static void updateAddress(EntityPlayer player, NBTTagCompound compound, int unid, String newName, String newAddress, int newIndex, boolean locked) {
        Preconditions.checkNotNull((Object)compound);
        ArrayList<AddressData> addresses = new ArrayList<AddressData>();
        NBTTagList list = compound.func_150295_c(ADDRESSES, 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound addressCompound = list.func_150305_b(i);
            int compoundEntryUnid = addressCompound.func_74762_e(UNID);
            if (compoundEntryUnid == unid) {
                addressCompound.func_74778_a(NAME, newName);
                addressCompound.func_74778_a(ADDRESS, newAddress);
                addressCompound.func_74768_a(INDEX, newIndex);
            }
            if (addressCompound.func_74762_e(INDEX) == -1) continue;
            addresses.add(new AddressData(addressCompound.func_74779_i(NAME), addressCompound.func_74779_i(ADDRESS), addressCompound.func_74767_n(LOCKED), addressCompound.func_74762_e(INDEX), addressCompound.func_74762_e(UNID)));
        }
        if (unid == 0) {
            addresses.add(new AddressData(newName, newAddress, locked, newIndex, 1));
        }
        AddressData.writeAddresses(compound, addresses);
    }

    public static List<AddressData> getAddresses(NBTTagCompound compound) {
        Preconditions.checkNotNull((Object)compound);
        ArrayList<AddressData> addresses = new ArrayList<AddressData>();
        NBTTagList list = compound.func_150295_c(ADDRESSES, 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound addressCompound = list.func_150305_b(i);
            String name = addressCompound.func_74779_i(NAME);
            String address = addressCompound.func_74779_i(ADDRESS);
            boolean locked = addressCompound.func_74767_n(LOCKED);
            int index = addressCompound.func_74762_e(INDEX);
            int unid = addressCompound.func_74762_e(UNID);
            addresses.add(new AddressData(name, address, locked, index, unid));
        }
        Collections.sort(addresses);
        return addresses;
    }

    public static NBTTagCompound writeAddresses(NBTTagCompound compound, List<AddressData> addresses) {
        Preconditions.checkNotNull((Object)compound);
        Preconditions.checkNotNull(addresses);
        NBTTagList list = new NBTTagList();
        for (AddressData data : addresses) {
            NBTTagCompound addressCompound = new NBTTagCompound();
            addressCompound.func_74778_a(NAME, data.getName());
            addressCompound.func_74778_a(ADDRESS, data.getAddress());
            addressCompound.func_74757_a(LOCKED, data.isLocked());
            addressCompound.func_74768_a(INDEX, data.getIndex());
            addressCompound.func_74768_a(UNID, data.hashCode());
            list.func_74742_a((NBTBase)addressCompound);
        }
        compound.func_74782_a(ADDRESSES, (NBTBase)list);
        return compound;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddressData that = (AddressData)o;
        return Objects.equals(this.address + this.name + this.index + this.locked, that.address + that.name + that.index + that.locked);
    }

    public int hashCode() {
        return Objects.hash(this.address + this.name + this.index + this.locked);
    }

    @Override
    public int compareTo(AddressData o) {
        return this.getIndex() - o.getIndex();
    }
}

