/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.features.ic2.zpm.modulehub;

import gcewing.sg.BaseTileInventory;
import gcewing.sg.BaseUtils;
import gcewing.sg.SGCraft;
import gcewing.sg.features.ic2.zpm.modulehub.ZpmHub;
import gcewing.sg.features.ic2.zpm.modulehub.ZpmHubBasicSource;
import gcewing.sg.features.zpm.ZPMItem;
import gcewing.sg.interfaces.ISGEnergySource;
import ic2.api.energy.prefab.BasicSource;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySource;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class ZpmHubTE
extends BaseTileInventory
implements ISGEnergySource,
IEnergySource,
IInventory,
ITickable {
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    public final BasicSource hubSource = new ZpmHubBasicSource(this, 2.147483647E9, 3);
    public static final int firstZpmSlot = 0;
    public static final int numZpmSlots = 3;
    public static final int numSlots = 3;
    public int zpmSlot0Energy = 0;
    public int zpmSlot1Energy = 0;
    public int zpmSlot2Energy = 0;
    public int zpmSlotsloaded = 0;
    private double energyPerSGEnergyUnit = 80.0;
    private int update = 0;

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.hubSource.readFromNBT(compound);
        this.zpmSlot0Energy = compound.func_74762_e("zpmSlot0Energy");
        this.zpmSlot1Energy = compound.func_74762_e("zpmSlot1Energy");
        this.zpmSlot2Energy = compound.func_74762_e("zpmSlot2Energy");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.hubSource.writeToNBT(compound);
        compound.func_74768_a("zpmSlot0Energy", this.zpmSlot0Energy);
        compound.func_74768_a("zpmSlot1Energy", this.zpmSlot1Energy);
        compound.func_74768_a("zpmSlot2Energy", this.zpmSlot2Energy);
        return compound;
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.hubSource.update();
    }

    public void onChunkUnload() {
        this.hubSource.onChunkUnload();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.hubSource.invalidate();
    }

    @Override
    @Nonnull
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound result = new NBTTagCompound();
        this.func_189515_b(result);
        return result;
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        NBTTagCompound tag = packet.func_148857_g();
        this.func_145839_a(tag);
    }

    @Override
    public double availableEnergy() {
        return this.hubSource.getEnergyStored();
    }

    @Override
    public double totalAvailableEnergy() {
        return this.hubSource.getCapacity();
    }

    @Override
    public double drawEnergyDouble(double amount) {
        double available = this.hubSource.getEnergyStored();
        double supply = BaseUtils.min(amount, available);
        this.hubSource.drawEnergy(supply * this.energyPerSGEnergyUnit);
        if (this.isTainted(this.func_70301_a(0))) {
            this.field_145850_b.func_72885_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 250.0f, true, true);
        }
        this.markChanged();
        return amount;
    }

    public double getOfferedEnergy() {
        return this.hubSource.getOfferedEnergy();
    }

    public int getZpmSlotsloaded() {
        int zpmCount = 0;
        if (this.zpmSlot0Energy > 0) {
            ++zpmCount;
        }
        if (this.zpmSlot1Energy > 0) {
            ++zpmCount;
        }
        if (this.zpmSlot2Energy > 0) {
            ++zpmCount;
        }
        if (zpmCount == 1) {
            this.hubSource.setSourceTier(3);
        } else if (zpmCount == 2) {
            this.hubSource.setSourceTier(4);
        } else if (zpmCount == 3) {
            this.hubSource.setSourceTier(5);
        }
        return zpmCount;
    }

    public void drawEnergy(double v) {
    }

    public int getSourceTier() {
        if (this.getZpmSlotsloaded() == 2) {
            return 4;
        }
        if (this.getZpmSlotsloaded() == 3) {
            return 5;
        }
        return 3;
    }

    public boolean emitsEnergyTo(IEnergyAcceptor iEnergyAcceptor, EnumFacing enumFacing) {
        if (this.isTainted(this.func_70301_a(0)) || this.isTainted(this.func_70301_a(1)) || this.isTainted(this.func_70301_a(2))) {
            this.field_145850_b.func_72885_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 250.0f, true, true);
        }
        this.markChanged();
        return this.hubSource.emitsEnergyTo(iEnergyAcceptor, enumFacing);
    }

    @Override
    public int func_70302_i_() {
        return 3;
    }

    @Override
    protected IInventory getInventory() {
        return this;
    }

    @Override
    public boolean func_191420_l() {
        for (ItemStack item : this.items) {
            if (item.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.items.get(index);
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    @Override
    public ItemStack func_70304_b(int index) {
        ItemStack item = ItemStackHelper.func_188382_a(this.items, (int)index, (int)1);
        NBTTagCompound tag = item.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            item.func_77982_d(tag);
        }
        if (tag.func_150297_b("AvailableEnergy", 99)) {
            if (index == 0) {
                tag.func_74780_a("AvailableEnergy", (double)this.zpmSlot0Energy);
                tag.func_74757_a("loadedIntoCart", false);
            } else if (index == 1) {
                tag.func_74780_a("AvailableEnergy", (double)this.zpmSlot1Energy);
                tag.func_74757_a("loadedIntoCart", false);
            } else if (index == 2) {
                tag.func_74780_a("AvailableEnergy", (double)this.zpmSlot2Energy);
                tag.func_74757_a("loadedIntoCart", false);
            }
        }
        if (this.field_145850_b != null) {
            this.validateSlotStatus();
            IBlockState other = this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)ZpmHub.ZPMS, (Comparable)Integer.valueOf(this.getZpmSlotsloaded()));
            this.field_145850_b.func_180501_a(this.field_174879_c, other, 3);
            this.markChanged();
        }
        return ItemStackHelper.func_188383_a(this.items, (int)index);
    }

    @Override
    public ItemStack func_70298_a(int index, int quantity) {
        ItemStack item = ItemStackHelper.func_188383_a(this.items, (int)index);
        NBTTagCompound tag = item.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            item.func_77982_d(tag);
        }
        if (tag != null && tag.func_150297_b("AvailableEnergy", 99)) {
            if (index == 0) {
                tag.func_74780_a("AvailableEnergy", (double)this.zpmSlot0Energy);
                tag.func_74757_a("loadedIntoCart", false);
            } else if (index == 1) {
                tag.func_74780_a("AvailableEnergy", (double)this.zpmSlot1Energy);
                tag.func_74757_a("loadedIntoCart", false);
            } else if (index == 2) {
                tag.func_74780_a("AvailableEnergy", (double)this.zpmSlot2Energy);
                tag.func_74757_a("loadedIntoCart", false);
            }
        }
        if (this.field_145850_b != null) {
            this.validateSlotStatus();
            IBlockState other = this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)ZpmHub.ZPMS, (Comparable)Integer.valueOf(this.getZpmSlotsloaded()));
            this.field_145850_b.func_180501_a(this.field_174879_c, other, 3);
            this.markChanged();
        }
        return item;
    }

    @Override
    public void func_70299_a(int index, ItemStack item) {
        this.items.set(index, (Object)item);
        if (ZpmHubTE.isValidFuelItem(item)) {
            NBTTagCompound tag = item.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
                item.func_77982_d(tag);
            }
            tag.func_74757_a("loadedIntoCart", true);
            if (!tag.func_150297_b("AvailableEnergy", 99)) {
                tag.func_74780_a("AvailableEnergy", 2.147483647E9);
            }
            if (index == 0) {
                this.zpmSlot0Energy = (int)tag.func_74769_h("AvailableEnergy");
            } else if (index == 1) {
                this.zpmSlot1Energy = (int)tag.func_74769_h("AvailableEnergy");
            } else if (index == 2) {
                this.zpmSlot2Energy = (int)tag.func_74769_h("AvailableEnergy");
            }
            this.hubSource.setEnergyStored(this.hubSource.getEnergyStored() + tag.func_74769_h("AvailableEnergy"));
        }
        if (this.field_145850_b != null) {
            this.validateSlotStatus();
            IBlockState other = this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)ZpmHub.ZPMS, (Comparable)Integer.valueOf(this.getZpmSlotsloaded()));
            this.field_145850_b.func_180501_a(this.field_174879_c, other, 3);
            this.markChanged();
        }
    }

    public void validateSlotStatus() {
        if (!ZpmHubTE.isValidFuelItem(this.func_70301_a(0))) {
            this.hubSource.setEnergyStored(this.hubSource.getEnergyStored() - (double)this.zpmSlot0Energy);
            this.zpmSlot0Energy = 0;
        }
        if (!ZpmHubTE.isValidFuelItem(this.func_70301_a(1))) {
            this.hubSource.setEnergyStored(this.hubSource.getEnergyStored() - (double)this.zpmSlot1Energy);
            this.zpmSlot1Energy = 0;
        }
        if (!ZpmHubTE.isValidFuelItem(this.func_70301_a(2))) {
            this.hubSource.setEnergyStored(this.hubSource.getEnergyStored() - (double)this.zpmSlot2Energy);
            this.zpmSlot2Energy = 0;
        }
        if (this.getZpmSlotsloaded() == 0) {
            this.hubSource.setEnergyStored(0.0);
        }
    }

    public static boolean isValidFuelItem(ItemStack stack) {
        return stack != null && stack.func_77973_b() == SGCraft.zpm && stack.func_190916_E() > 0;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack item) {
        return item.func_77973_b() instanceof ZPMItem;
    }

    @Override
    public int func_174887_a_(int id) {
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
    }

    @Override
    public int func_174890_g() {
        return 0;
    }

    @Override
    public void func_174888_l() {
        this.items.clear();
    }

    @Override
    public String func_70005_c_() {
        return "container.zero_point_module";
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public ITextComponent func_145748_c_() {
        return new TextComponentString("ZPM Container");
    }

    public static ZpmHubTE at(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof ZpmHubTE ? (ZpmHubTE)te : null;
    }

    public boolean isTainted(ItemStack item) {
        boolean hasTaint = false;
        NBTTagList nbttaglist = item.func_77986_q();
        for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(j);
            short k = nbttagcompound.func_74765_d("id");
            short l = nbttagcompound.func_74765_d("lvl");
            Enchantment enchantment = Enchantment.func_185262_c((int)k);
            if (k != 51) continue;
            hasTaint = true;
        }
        return hasTaint;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }
}

