/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.features.configurator.client.gui;

import com.google.common.eventbus.Subscribe;
import gcewing.sg.features.configurator.client.gui.PlayerAccessEntryScreen;
import gcewing.sg.features.configurator.network.ConfiguratorNetworkHandler;
import gcewing.sg.tileentity.SGBaseTE;
import gcewing.sg.tileentity.data.PlayerAccessData;
import gcewing.sg.util.GateUtil;
import java.util.ArrayList;
import java.util.List;
import net.malisis.core.client.gui.Anchor;
import net.malisis.core.client.gui.BasicScreen;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.BasicContainer;
import net.malisis.core.client.gui.component.container.BasicForm;
import net.malisis.core.client.gui.component.container.BasicList;
import net.malisis.core.client.gui.component.decoration.UILabel;
import net.malisis.core.client.gui.component.decoration.UISeparator;
import net.malisis.core.client.gui.component.interaction.UIButton;
import net.malisis.core.client.gui.component.interaction.UICheckBox;
import net.malisis.core.client.gui.component.interaction.button.builder.UIButtonBuilder;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.renderer.font.FontOptions;
import net.malisis.core.util.FontColors;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class PlayerAccessScreen
extends BasicScreen {
    private int lastUpdate = 0;
    private boolean unlockMouse = true;
    private boolean isAdmin;
    private boolean delayedUpdate = false;
    private BasicForm form;
    private BasicContainer<?> playerContainer;
    private BasicContainer<?> optionsContainer;
    private UIButton buttonClose;
    private UIButton addPlayerButton;
    private UIButton editPlayerButton;
    private UIButton deletePlayerButton;
    private UIButton saveOptionsButton;
    private UIButton saveDefaultOptionsButton;
    private UILabel addressListLabel;
    private UILabel gateDefaultAccessLabel;
    private UILabel gateDefaultIrisControllerLabel;
    private UILabel optionsLabel;
    private UILabel accessLabel;
    private UILabel irisControllerLabel;
    private UILabel gateDefaultAdminLabel;
    private UILabel adminLabel;
    private UICheckBox defaultAllowAccessCheckbox;
    private UICheckBox defaultDenyAccessCheckbox;
    private UICheckBox defaultAllowIrisCheckbox;
    private UICheckBox defaultDenyIrisCheckbox;
    private UICheckBox defaultAllowAdminCheckbox;
    private UICheckBox defaultDenyAdminCheckbox;
    private UICheckBox allowAccessCheckbox;
    private UICheckBox denyAccessCheckbox;
    private UICheckBox allowIrisControllerCheckbox;
    private UICheckBox denyIrisControllerCheckbox;
    private UICheckBox allowAdminCheckbox;
    private UICheckBox denyAdminCheckbox;
    private BlockPos location;
    private World world;
    private EntityPlayer player;
    private SGBaseTE localGate;
    private List<PlayerAccessData> clonedList;
    private BasicList<PlayerAccessData> playerAccessList;

    public PlayerAccessScreen(BasicScreen parent, EntityPlayer player, World worldIn, boolean isAdmin) {
        super((GuiScreen)parent, true);
        this.player = player;
        this.isAdmin = false;
        this.world = worldIn;
        this.location = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
    }

    public void construct() {
        this.guiscreenBackground = false;
        Keyboard.enableRepeatEvents((boolean)true);
        TileEntity localGateTE = GateUtil.locateLocalGate(this.world, this.location, 6, false);
        if (localGateTE instanceof SGBaseTE) {
            this.localGate = (SGBaseTE)localGateTE;
        }
        this.form = new BasicForm((MalisisGui)this, 350, 225, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.playerAccessList", (Object[])new Object[0]));
        this.form.setMovable(true);
        this.form.setBackgroundAlpha(255);
        this.playerContainer = new BasicContainer((MalisisGui)this, 150, 145);
        this.playerContainer.setPosition(0, 0, Anchor.LEFT | Anchor.TOP);
        this.playerContainer.setBorder(0xFFFFFF, 1, 185);
        this.playerContainer.setPadding(0, 3);
        this.playerContainer.setBackgroundAlpha(0);
        this.addressListLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.playerList", (Object[])new Object[0]));
        this.addressListLabel.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(true).scale(1.0f).build());
        this.addressListLabel.setPosition(0, 0, Anchor.CENTER | Anchor.TOP);
        this.playerAccessList = new BasicList((MalisisGui)this, 0, this.playerContainer.getHeight() - 14);
        this.playerAccessList.setPosition(0, 10);
        this.playerAccessList.setItemComponentFactory((x$0, x$1, x$2) -> new PlayerItemComponent((MalisisGui)x$0, (BasicList<PlayerAccessData>)x$1, (PlayerAccessData)x$2));
        this.playerAccessList.setItemComponentSpacing(1);
        this.playerAccessList.setPadding(2);
        this.playerAccessList.setName("List");
        this.playerAccessList.register((Object)this);
        this.playerAccessList.setBorder(0xFFFFFF, 1, 185);
        this.playerAccessList.setBorders(0xFFFFFF, 185, 0, 1, 0, 0);
        this.playerContainer.add(new UIComponent[]{this.addressListLabel, this.playerAccessList});
        this.optionsLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.options", (Object[])new Object[0]));
        this.optionsLabel.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(true).scale(1.0f).build());
        this.optionsLabel.setPosition(0, 0, Anchor.CENTER | Anchor.TOP);
        UISeparator optionsSeparator = new UISeparator((MalisisGui)this);
        optionsSeparator.setSize(this.optionsLabel.getWidth() - 10, 1);
        optionsSeparator.setPosition(0, 10, Anchor.TOP | Anchor.CENTER);
        this.optionsContainer = new BasicContainer((MalisisGui)this, 150, 145);
        this.optionsContainer.setPosition(0, 0, Anchor.RIGHT | Anchor.TOP);
        this.optionsContainer.setBorder(0xFFFFFF, 1, 185);
        this.optionsContainer.setPadding(0, 3);
        this.optionsContainer.setBackgroundAlpha(0);
        this.accessLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.access", (Object[])new Object[0]) + ":");
        this.accessLabel.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(true).scale(1.0f).build());
        this.accessLabel.setPosition(5, 20, Anchor.TOP | Anchor.LEFT);
        this.allowAccessCheckbox = new UICheckBox((MalisisGui)this);
        this.allowAccessCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.allow", (Object[])new Object[0]));
        this.allowAccessCheckbox.setPosition(this.accessLabel.getX() + this.accessLabel.getWidth() + 10, this.accessLabel.getY(), Anchor.LEFT | Anchor.TOP);
        this.allowAccessCheckbox.setName("checkbox.allowincoming");
        this.allowAccessCheckbox.setChecked(this.localGate.defaultAllowIncoming);
        this.allowAccessCheckbox.register((Object)this);
        this.denyAccessCheckbox = new UICheckBox((MalisisGui)this);
        this.denyAccessCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.deny", (Object[])new Object[0]));
        this.denyAccessCheckbox.setPosition(this.accessLabel.getX() + this.accessLabel.getWidth() + 10 + this.allowAccessCheckbox.getWidth() + 10, this.accessLabel.getY(), Anchor.LEFT | Anchor.TOP);
        this.denyAccessCheckbox.setName("checkbox.denyincoming");
        this.denyAccessCheckbox.setChecked(!this.localGate.defaultAllowIncoming);
        this.denyAccessCheckbox.register((Object)this);
        this.irisControllerLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.iris", (Object[])new Object[0]) + ":");
        this.irisControllerLabel.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(true).scale(1.0f).build());
        this.irisControllerLabel.setPosition(5, this.accessLabel.getY() + 15, Anchor.TOP | Anchor.LEFT);
        this.allowIrisControllerCheckbox = new UICheckBox((MalisisGui)this);
        this.allowIrisControllerCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.allow", (Object[])new Object[0]));
        this.allowIrisControllerCheckbox.setPosition(this.accessLabel.getX() + this.accessLabel.getWidth() + 10, this.irisControllerLabel.getY(), Anchor.LEFT | Anchor.TOP);
        this.allowIrisControllerCheckbox.setName("checkbox.allowoutgoing");
        this.allowIrisControllerCheckbox.setChecked(this.localGate.defaultAllowOutgoing);
        this.allowIrisControllerCheckbox.register((Object)this);
        this.denyIrisControllerCheckbox = new UICheckBox((MalisisGui)this);
        this.denyIrisControllerCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.deny", (Object[])new Object[0]));
        this.denyIrisControllerCheckbox.setPosition(this.irisControllerLabel.getX() + this.accessLabel.getWidth() + 10 + this.allowAccessCheckbox.getWidth() + 10, this.irisControllerLabel.getY(), Anchor.LEFT | Anchor.TOP);
        this.denyIrisControllerCheckbox.setName("checkbox.denyoutgoing");
        this.denyIrisControllerCheckbox.setChecked(!this.localGate.defaultAllowOutgoing);
        this.denyIrisControllerCheckbox.register((Object)this);
        this.adminLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.admin", (Object[])new Object[0]) + ":");
        this.adminLabel.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(true).scale(1.0f).build());
        this.adminLabel.setPosition(5, this.irisControllerLabel.getY() + 15, Anchor.TOP | Anchor.LEFT);
        this.allowAdminCheckbox = new UICheckBox((MalisisGui)this);
        this.allowAdminCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.allow", (Object[])new Object[0]));
        this.allowAdminCheckbox.setPosition(this.accessLabel.getX() + this.accessLabel.getWidth() + 10, this.adminLabel.getY(), Anchor.LEFT | Anchor.TOP);
        this.allowAdminCheckbox.setName("checkbox.allowadmin");
        this.allowAdminCheckbox.setChecked(this.localGate.defaultAllowOutgoing);
        this.allowAdminCheckbox.register((Object)this);
        this.denyAdminCheckbox = new UICheckBox((MalisisGui)this);
        this.denyAdminCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.deny", (Object[])new Object[0]));
        this.denyAdminCheckbox.setPosition(this.irisControllerLabel.getX() + this.accessLabel.getWidth() + 10 + this.allowAccessCheckbox.getWidth() + 10, this.adminLabel.getY(), Anchor.LEFT | Anchor.TOP);
        this.denyAdminCheckbox.setName("checkbox.denyadmin");
        this.denyAdminCheckbox.setChecked(!this.localGate.defaultAllowOutgoing);
        this.denyAdminCheckbox.register((Object)this);
        this.saveOptionsButton = new UIButtonBuilder((MalisisGui)this).text(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.button.save", (Object[])new Object[0])).onClick(() -> {
            if (this.playerAccessList.getSize() > 0 && this.playerAccessList.getSelectedItem() != null && !((PlayerAccessData)this.playerAccessList.getSelectedItem()).getPlayerName().isEmpty()) {
                ConfiguratorNetworkHandler.sendPlayerAccessInputToServer(this.localGate, ((PlayerAccessData)this.playerAccessList.getSelectedItem()).getPlayerName(), false, false, false, this.allowAccessCheckbox.isChecked(), this.allowIrisControllerCheckbox.isChecked(), this.allowAdminCheckbox.isChecked());
                SGBaseTE.sendBasicMsg(this.player, "changesSaved", new Object[0]);
            }
        }).anchor(Anchor.BOTTOM | Anchor.RIGHT).position(-5, 0).build("button.save");
        this.optionsContainer.add(new UIComponent[]{this.optionsLabel, optionsSeparator, this.accessLabel, this.allowAccessCheckbox, this.denyAccessCheckbox, this.irisControllerLabel, this.allowIrisControllerCheckbox, this.denyIrisControllerCheckbox, this.adminLabel, this.allowAdminCheckbox, this.denyAdminCheckbox, this.saveOptionsButton});
        this.addPlayerButton = new UIButtonBuilder((MalisisGui)this).text(TextFormatting.GREEN + "+").onClick(() -> {
            if (this.playerAccessList.getSize() == 0) {
                new PlayerAccessEntryScreen(this, this.player, this.localGate, "", "", 1).display();
            } else {
                new PlayerAccessEntryScreen(this, this.player, this.localGate, ((PlayerAccessData)this.playerAccessList.getSelectedItem()).getPlayerName(), ((PlayerAccessData)this.playerAccessList.getSelectedItem()).getPlayerName(), 1).display();
            }
        }).anchor(Anchor.TOP | Anchor.LEFT).position(this.playerContainer.getWidth() + 17, 40).build("button.add");
        this.editPlayerButton = new UIButtonBuilder((MalisisGui)this).text(TextFormatting.YELLOW + "?").onClick(() -> new PlayerAccessEntryScreen(this, this.player, this.localGate, ((PlayerAccessData)this.playerAccessList.getSelectedItem()).getPlayerName(), ((PlayerAccessData)this.playerAccessList.getSelectedItem()).getPlayerName(), 2).display()).anchor(Anchor.TOP | Anchor.LEFT).position(this.addPlayerButton.getX(), this.addPlayerButton.getY() + 20).build("button.details");
        this.deletePlayerButton = new UIButtonBuilder((MalisisGui)this).text(TextFormatting.RED + "-").onClick(() -> new PlayerAccessEntryScreen(this, this.player, this.localGate, ((PlayerAccessData)this.playerAccessList.getSelectedItem()).getPlayerName(), ((PlayerAccessData)this.playerAccessList.getSelectedItem()).getPlayerName(), 3).display()).anchor(Anchor.TOP | Anchor.LEFT).position(this.addPlayerButton.getX(), this.editPlayerButton.getY() + 20).build("button.remove");
        UISeparator defaultsSeparator = new UISeparator((MalisisGui)this);
        defaultsSeparator.setSize(this.form.getWidth() - 15, 1);
        defaultsSeparator.setPosition(0, -50, Anchor.BOTTOM | Anchor.CENTER);
        this.gateDefaultAccessLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.defaultAccess", (Object[])new Object[0]) + ":");
        this.gateDefaultAccessLabel.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(true).scale(1.0f).build());
        this.gateDefaultAccessLabel.setPosition(5, -35, Anchor.BOTTOM | Anchor.LEFT);
        this.defaultAllowAccessCheckbox = new UICheckBox((MalisisGui)this);
        this.defaultAllowAccessCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.allow", (Object[])new Object[0]));
        this.defaultAllowAccessCheckbox.setPosition(this.gateDefaultAccessLabel.getX() + this.gateDefaultAccessLabel.getWidth() + 10, this.gateDefaultAccessLabel.getY(), Anchor.LEFT | Anchor.BOTTOM);
        this.defaultAllowAccessCheckbox.setName("checkbox.defaultallowaccess");
        this.defaultAllowAccessCheckbox.setChecked(this.localGate.defaultAllowGateAccess);
        this.defaultAllowAccessCheckbox.register((Object)this);
        this.defaultDenyAccessCheckbox = new UICheckBox((MalisisGui)this);
        this.defaultDenyAccessCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.deny", (Object[])new Object[0]));
        this.defaultDenyAccessCheckbox.setPosition(this.gateDefaultAccessLabel.getX() + this.gateDefaultAccessLabel.getWidth() + 10 + this.defaultAllowAccessCheckbox.getWidth() + 10, this.gateDefaultAccessLabel.getY(), Anchor.LEFT | Anchor.BOTTOM);
        this.defaultDenyAccessCheckbox.setName("checkbox.defaultdenyaccess");
        this.defaultDenyAccessCheckbox.setChecked(!this.localGate.defaultAllowGateAccess);
        this.defaultDenyAccessCheckbox.register((Object)this);
        this.gateDefaultIrisControllerLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.defaultIris", (Object[])new Object[0]) + ":");
        this.gateDefaultIrisControllerLabel.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(true).scale(1.0f).build());
        this.gateDefaultIrisControllerLabel.setPosition(5, -20, Anchor.BOTTOM | Anchor.LEFT);
        this.defaultAllowIrisCheckbox = new UICheckBox((MalisisGui)this);
        this.defaultAllowIrisCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.allow", (Object[])new Object[0]));
        this.defaultAllowIrisCheckbox.setPosition(this.gateDefaultAccessLabel.getX() + this.gateDefaultAccessLabel.getWidth() + 10, this.gateDefaultIrisControllerLabel.getY(), Anchor.LEFT | Anchor.BOTTOM);
        this.defaultAllowIrisCheckbox.setName("checkbox.defaultallowiris");
        this.defaultAllowIrisCheckbox.setChecked(this.localGate.defaultAllowIrisAccess);
        this.defaultAllowIrisCheckbox.register((Object)this);
        this.defaultDenyIrisCheckbox = new UICheckBox((MalisisGui)this);
        this.defaultDenyIrisCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.deny", (Object[])new Object[0]));
        this.defaultDenyIrisCheckbox.setPosition(this.gateDefaultAccessLabel.getX() + this.gateDefaultAccessLabel.getWidth() + 10 + this.defaultAllowAccessCheckbox.getWidth() + 10, this.gateDefaultIrisControllerLabel.getY(), Anchor.LEFT | Anchor.BOTTOM);
        this.defaultDenyIrisCheckbox.setName("checkbox.defaultdenyiris");
        this.defaultDenyIrisCheckbox.setChecked(!this.localGate.defaultAllowIrisAccess);
        this.defaultDenyIrisCheckbox.register((Object)this);
        this.gateDefaultAdminLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.defaultAdmin", (Object[])new Object[0]) + ":");
        this.gateDefaultAdminLabel.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(true).scale(1.0f).build());
        this.gateDefaultAdminLabel.setPosition(5, -5, Anchor.BOTTOM | Anchor.LEFT);
        this.defaultAllowAdminCheckbox = new UICheckBox((MalisisGui)this);
        this.defaultAllowAdminCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.allow", (Object[])new Object[0]));
        this.defaultAllowAdminCheckbox.setPosition(this.gateDefaultAdminLabel.getX() + this.gateDefaultAccessLabel.getWidth() + 10, this.gateDefaultAdminLabel.getY(), Anchor.LEFT | Anchor.BOTTOM);
        this.defaultAllowAdminCheckbox.setName("checkbox.defaultallowadmin");
        this.defaultAllowAdminCheckbox.setChecked(this.localGate.defaultAllowAdminAccess);
        this.defaultAllowAdminCheckbox.register((Object)this);
        this.defaultDenyAdminCheckbox = new UICheckBox((MalisisGui)this);
        this.defaultDenyAdminCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.deny", (Object[])new Object[0]));
        this.defaultDenyAdminCheckbox.setPosition(this.gateDefaultAdminLabel.getX() + this.gateDefaultAccessLabel.getWidth() + 10 + this.defaultAllowAccessCheckbox.getWidth() + 10, this.gateDefaultAdminLabel.getY(), Anchor.LEFT | Anchor.BOTTOM);
        this.defaultDenyAdminCheckbox.setName("checkbox.defaultdenyadmin");
        this.defaultDenyAdminCheckbox.setChecked(!this.localGate.defaultAllowAdminAccess);
        this.defaultDenyAdminCheckbox.register((Object)this);
        this.buttonClose = new UIButtonBuilder((MalisisGui)this).width(40).anchor(Anchor.BOTTOM | Anchor.RIGHT).text(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.button.close", (Object[])new Object[0])).onClick(() -> ((PlayerAccessScreen)this).close()).build("button.close");
        this.saveDefaultOptionsButton = new UIButtonBuilder((MalisisGui)this).text(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.button.save", (Object[])new Object[0])).onClick(() -> {
            ConfiguratorNetworkHandler.sendPlayerAccessInputToServer(this.localGate, "", this.defaultAllowAccessCheckbox.isChecked(), this.defaultAllowIrisCheckbox.isChecked(), this.defaultAllowAdminCheckbox.isChecked(), this.allowAccessCheckbox.isChecked(), this.allowIrisControllerCheckbox.isChecked(), this.allowAdminCheckbox.isChecked());
            SGBaseTE.sendBasicMsg(this.player, "changesSaved", new Object[0]);
            this.close();
        }).anchor(Anchor.BOTTOM | Anchor.RIGHT).position(-(this.buttonClose.getX() + this.buttonClose.getWidth() + 5), 0).build("button.savedefaults");
        this.form.add(new UIComponent[]{this.playerContainer, defaultsSeparator, this.addPlayerButton, this.editPlayerButton, this.deletePlayerButton, this.gateDefaultAccessLabel, this.gateDefaultIrisControllerLabel, this.buttonClose});
        this.form.add(new UIComponent[]{this.optionsContainer, this.saveDefaultOptionsButton});
        this.form.add(new UIComponent[]{this.defaultAllowAccessCheckbox, this.defaultDenyAccessCheckbox, this.defaultAllowIrisCheckbox, this.defaultDenyIrisCheckbox, this.gateDefaultAdminLabel, this.defaultAllowAdminCheckbox, this.defaultDenyAdminCheckbox});
        this.addToScreen((UIComponent)this.form);
        this.loadData();
    }

    @Subscribe
    public void onListChange(BasicList.SelectEvent<PlayerAccessData> event) {
        boolean firstClick;
        boolean bl = firstClick = event.getOldValue() == null;
        if (this.localGate.getPlayerAccessData().size() > 0) {
            this.allowAccessCheckbox.setChecked(this.localGate.allowGateAccess(((PlayerAccessData)event.getNewValue()).getPlayerName()));
            this.denyAccessCheckbox.setChecked(!this.localGate.allowGateAccess(((PlayerAccessData)event.getNewValue()).getPlayerName()));
            this.allowIrisControllerCheckbox.setChecked(this.localGate.allowAccessToIrisController(((PlayerAccessData)event.getNewValue()).getPlayerName()));
            this.denyIrisControllerCheckbox.setChecked(!this.localGate.allowAccessToIrisController(((PlayerAccessData)event.getNewValue()).getPlayerName()));
            this.allowAdminCheckbox.setChecked(this.localGate.allowAdminAccess(((PlayerAccessData)event.getNewValue()).getPlayerName()));
            this.denyAdminCheckbox.setChecked(!this.localGate.allowAdminAccess(((PlayerAccessData)event.getNewValue()).getPlayerName()));
            this.optionsContainer.setEnabled(true);
        } else {
            this.optionsContainer.setEnabled(false);
        }
    }

    @Subscribe
    public void onValueChange(ComponentEvent.ValueChange event) {
        switch (event.getComponent().getName()) {
            case "checkbox.defaultallowaccess": {
                this.defaultDenyAccessCheckbox.setChecked(this.defaultAllowAccessCheckbox.isChecked());
                break;
            }
            case "checkbox.defaultdenyaccess": {
                this.defaultAllowAccessCheckbox.setChecked(this.defaultDenyAccessCheckbox.isChecked());
                break;
            }
            case "checkbox.defaultallowiris": {
                this.defaultDenyIrisCheckbox.setChecked(this.defaultAllowIrisCheckbox.isChecked());
                break;
            }
            case "checkbox.defaultdenyiris": {
                this.defaultAllowIrisCheckbox.setChecked(this.defaultDenyIrisCheckbox.isChecked());
                break;
            }
            case "checkbox.defaultallowadmin": {
                this.defaultDenyAdminCheckbox.setChecked(this.defaultAllowAdminCheckbox.isChecked());
                break;
            }
            case "checkbox.defaultdenyadmin": {
                this.defaultAllowAdminCheckbox.setChecked(this.defaultDenyAdminCheckbox.isChecked());
                break;
            }
            case "checkbox.allowincoming": {
                this.denyAccessCheckbox.setChecked(this.allowAccessCheckbox.isChecked());
                break;
            }
            case "checkbox.denyincoming": {
                this.allowAccessCheckbox.setChecked(this.denyAccessCheckbox.isChecked());
                break;
            }
            case "checkbox.allowoutgoing": {
                this.denyIrisControllerCheckbox.setChecked(this.allowIrisControllerCheckbox.isChecked());
                break;
            }
            case "checkbox.denyoutgoing": {
                this.allowIrisControllerCheckbox.setChecked(this.denyIrisControllerCheckbox.isChecked());
                break;
            }
            case "checkbox.allowadmin": {
                this.denyAdminCheckbox.setChecked(this.allowAdminCheckbox.isChecked());
                break;
            }
            case "checkbox.denyadmin": {
                this.allowAdminCheckbox.setChecked(this.denyAdminCheckbox.isChecked());
            }
        }
    }

    public void update(int mouseX, int mouseY, float partialTick) {
        super.update(mouseX, mouseY, partialTick);
        if (this.unlockMouse && this.lastUpdate == 25) {
            Mouse.setGrabbed((boolean)false);
            this.unlockMouse = false;
        }
        if (this.lastUpdate == 20) {
            this.editPlayerButton.setEnabled(this.playerAccessList.getSize() > 0);
            this.deletePlayerButton.setEnabled(this.playerAccessList.getSize() > 0);
            this.optionsContainer.setEnabled(this.playerAccessList.getSize() > 0);
            if (!this.localGate.getPlayerAccessData().equals(this.clonedList)) {
                this.loadData();
            }
        }
        if (++this.lastUpdate > 60) {
            this.lastUpdate = 0;
        }
    }

    public void delayedUpdate() {
        this.lastUpdate = 0;
        this.delayedUpdate = true;
    }

    protected void func_73869_a(char keyChar, int keyCode) {
        super.func_73869_a(keyChar, keyCode);
        this.lastUpdate = 0;
    }

    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        this.lastUpdate = 0;
    }

    public boolean func_73868_f() {
        return false;
    }

    private void loadData() {
        if (this.localGate != null && this.localGate.getGateAccessData() != null) {
            this.playerAccessList.setItems(this.localGate.getPlayerAccessData());
            this.playerAccessList.setSelectedItem(this.playerAccessList.getItems().stream().findFirst().orElse(null));
            this.clonedList = new ArrayList<PlayerAccessData>(this.localGate.getPlayerAccessData());
        }
    }

    private class PlayerItemComponent
    extends BasicList.ItemComponent<PlayerAccessData> {
        private UILabel playerNameLabel;

        public PlayerItemComponent(MalisisGui gui, BasicList<PlayerAccessData> parent, PlayerAccessData item) {
            super(gui, parent, (Object)item);
        }

        protected void construct(MalisisGui gui) {
            super.construct(gui);
            this.setHeight(15);
            this.setPadding(1);
            this.playerNameLabel = new UILabel(this.getGui(), TextFormatting.WHITE + ((PlayerAccessData)this.item).getPlayerName());
            this.playerNameLabel.setAnchor(Anchor.LEFT | Anchor.MIDDLE);
            this.playerNameLabel.setPosition(5, 0);
            this.add(new UIComponent[]{this.playerNameLabel});
        }

        public void update() {
        }
    }
}

