/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.features.configurator.client.gui;

import com.google.common.eventbus.Subscribe;
import gcewing.sg.features.configurator.client.gui.GateAddressAccessScreen;
import gcewing.sg.features.configurator.client.gui.PlayerAccessScreen;
import gcewing.sg.features.configurator.network.ConfiguratorNetworkHandler;
import gcewing.sg.tileentity.SGBaseTE;
import gcewing.sg.util.GateUtil;
import gcewing.sg.util.SGAddressing;
import net.malisis.core.client.gui.Anchor;
import net.malisis.core.client.gui.BasicScreen;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.BasicForm;
import net.malisis.core.client.gui.component.decoration.UILabel;
import net.malisis.core.client.gui.component.decoration.UISeparator;
import net.malisis.core.client.gui.component.interaction.UIButton;
import net.malisis.core.client.gui.component.interaction.UICheckBox;
import net.malisis.core.client.gui.component.interaction.UITextField;
import net.malisis.core.client.gui.component.interaction.button.builder.UIButtonBuilder;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.client.gui.event.component.StateChangeEvent;
import net.malisis.core.renderer.font.FontOptions;
import net.malisis.core.util.FontColors;
import net.malisis.core.util.MathUtil;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class ConfiguratorScreen
extends BasicScreen {
    private int lastUpdate = 0;
    private boolean unlockMouse = true;
    private boolean isAdmin;
    private BasicForm form;
    private BasicForm numericOptionsArea;
    private BasicForm checkboxOptionsArea;
    private UILabel gateAddressLabel;
    private UICheckBox oneWayTravelCheckbox;
    private UICheckBox irisUpgradeCheckbox;
    private UICheckBox chevronUpgradeCheckbox;
    private UICheckBox gateTypeCheckbox;
    private UICheckBox reverseWormholeKillsCheckbox;
    private UICheckBox closeFromEitherEndCheckbox;
    private UICheckBox preserveInventoryCheckbox;
    private UICheckBox noPowerRequiredCheckbox;
    private UICheckBox chevronsLockOnDialCheckbox;
    private UICheckBox returnIrisToPreviousStateCheckbox;
    private UICheckBox transientDamageCheckbox;
    private UICheckBox transparencyCheckbox;
    private UICheckBox horizontalFaceUpCheckbox;
    private UICheckBox horizontalFaceDownCheckbox;
    private UICheckBox useDHDFuelSourceCheckbox;
    private UICheckBox allowRedstoneOutputCheckbox;
    private UICheckBox allowRedstoneInputCheckbox;
    private UICheckBox playerCanDestroyGateCheckbox;
    private UICheckBox displayGateAddressCheckbox;
    private UITextField secondsToStayOpen;
    private UITextField gateRotationSpeed;
    private UITextField energyBufferSize;
    private UITextField energyPerNaquadah;
    private UITextField gateOpeningsPerNaquadah;
    private UITextField distanceMultiplier;
    private UITextField dimensionalMultiplier;
    private UIButton gateAddressAccessListButton;
    private UIButton playerAccessListButton;
    private BlockPos location;
    private World world;
    private EntityPlayer player;
    private boolean secondsToStayOpenPerm;
    private boolean gateRotationSpeedPerm;
    private boolean energyBufferSizePerm;
    private boolean energyPerNaquadahPerm;
    private boolean openingsPerNaquadahPerm;
    private boolean distanceFactorMultiplierPerm;
    private boolean interDimensionalMultiplierPerm;
    private boolean oneWayTravelOnlyPerm;
    private boolean irisUpgradePerm;
    private boolean chevronUpgradePerm;
    private boolean pegasusGateTypePerm;
    private boolean reverseWormholeKillsPerm;
    private boolean closeFromEitherEndPerm;
    private boolean preserveInventoryOnIrisDeathPerm;
    private boolean noInputPowerRequiredPerm;
    private boolean chevronsLockOnDialPerm;
    private boolean returnToPreviousIrisStatePerm;
    private boolean transientDamagePerm;
    private boolean transparencyPerm;
    private boolean dhdAsFuelSourcePerm;
    private boolean allowRedstoneOutputPerm;
    private boolean allowRedstoneInputPerm;
    private boolean gateAccessPerm;
    private boolean playerAccessPerm;
    private boolean playerCanDestroyGatePerm;
    private boolean displayGateAddressPerm;

    public ConfiguratorScreen(EntityPlayer player, World worldIn, boolean isAdmin, boolean secondsToStayOpenPerm, boolean gateRotationSpeedPerm, boolean energyBufferSizePerm, boolean energyPerNaquadahPerm, boolean openingsPerNaquadahPerm, boolean distanceFactorMultiplierPerm, boolean interDimensionalMultiplierPerm, boolean oneWayTravelOnlyPerm, boolean irisUpgradePerm, boolean chevronUpgradePerm, boolean pegasusGateTypePerm, boolean reverseWormholeKillsPerm, boolean closeFromEitherEndPerm, boolean preserveInventoryOnIrisDeathPerm, boolean noInputPowerRequiredPerm, boolean chevronsLockOnDialPerm, boolean returnToPreviousIrisStatePerm, boolean transientDamagePerm, boolean transparencyPerm, boolean dhdAsFuelSourcePerm, boolean allowRedstoneOutputPerm, boolean allowRedstoneInputPerm, boolean playerCanDestroyGatePerm, boolean displayGateAddressPerm, boolean gateAccessPerm, boolean playerAccessPerm) {
        this.player = player;
        this.isAdmin = isAdmin;
        this.world = worldIn;
        this.secondsToStayOpenPerm = secondsToStayOpenPerm;
        this.gateRotationSpeedPerm = gateRotationSpeedPerm;
        this.energyBufferSizePerm = energyBufferSizePerm;
        this.energyPerNaquadahPerm = energyPerNaquadahPerm;
        this.openingsPerNaquadahPerm = openingsPerNaquadahPerm;
        this.distanceFactorMultiplierPerm = distanceFactorMultiplierPerm;
        this.interDimensionalMultiplierPerm = interDimensionalMultiplierPerm;
        this.oneWayTravelOnlyPerm = oneWayTravelOnlyPerm;
        this.irisUpgradePerm = irisUpgradePerm;
        this.chevronUpgradePerm = chevronUpgradePerm;
        this.pegasusGateTypePerm = pegasusGateTypePerm;
        this.reverseWormholeKillsPerm = reverseWormholeKillsPerm;
        this.closeFromEitherEndPerm = closeFromEitherEndPerm;
        this.preserveInventoryOnIrisDeathPerm = preserveInventoryOnIrisDeathPerm;
        this.noInputPowerRequiredPerm = noInputPowerRequiredPerm;
        this.chevronsLockOnDialPerm = chevronsLockOnDialPerm;
        this.returnToPreviousIrisStatePerm = returnToPreviousIrisStatePerm;
        this.transientDamagePerm = transientDamagePerm;
        this.transparencyPerm = transparencyPerm;
        this.dhdAsFuelSourcePerm = dhdAsFuelSourcePerm;
        this.allowRedstoneOutputPerm = allowRedstoneOutputPerm;
        this.allowRedstoneInputPerm = allowRedstoneInputPerm;
        this.playerCanDestroyGatePerm = playerCanDestroyGatePerm;
        this.displayGateAddressPerm = displayGateAddressPerm;
        this.gateAccessPerm = gateAccessPerm;
        this.playerAccessPerm = playerAccessPerm;
        this.location = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
    }

    public void construct() {
        this.guiscreenBackground = false;
        Keyboard.enableRepeatEvents((boolean)true);
        TileEntity localGateTE = GateUtil.locateLocalGate(this.world, this.location, 6, false);
        if (!(localGateTE instanceof SGBaseTE)) {
            return;
        }
        SGBaseTE localGate = (SGBaseTE)localGateTE;
        this.form = new BasicForm((MalisisGui)this, 500, 300, "");
        this.form.setAnchor(Anchor.CENTER | Anchor.MIDDLE);
        this.form.setMovable(true);
        this.form.setClosable(true);
        this.form.setBorder(0xFFFFFF, 1, 185);
        this.form.setBackgroundAlpha(215);
        this.form.setBottomPadding(3);
        this.form.setRightPadding(3);
        this.form.setTopPadding(20);
        this.form.setLeftPadding(3);
        UILabel titleLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.configurator", (Object[])new Object[0]));
        titleLabel.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(true).scale(1.1f).build());
        titleLabel.setPosition(0, -15, Anchor.CENTER | Anchor.TOP);
        this.numericOptionsArea = new BasicForm((MalisisGui)this, 245, 260, "");
        this.numericOptionsArea.setPosition(0, 0, Anchor.LEFT | Anchor.MIDDLE);
        this.numericOptionsArea.setMovable(false);
        this.numericOptionsArea.setClosable(false);
        this.numericOptionsArea.setBorder(0xFFFFFF, 1, 185);
        this.numericOptionsArea.setBackgroundAlpha(215);
        this.numericOptionsArea.setBottomPadding(3);
        this.numericOptionsArea.setRightPadding(3);
        this.numericOptionsArea.setTopPadding(3);
        this.numericOptionsArea.setLeftPadding(3);
        int padding = 15;
        UILabel numericValuesLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.numericValues", (Object[])new Object[0]));
        numericValuesLabel.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(true).scale(1.1f).build());
        numericValuesLabel.setPosition(0, 0, Anchor.CENTER | Anchor.TOP);
        UISeparator valuesSeparator = new UISeparator((MalisisGui)this);
        valuesSeparator.setSize(this.numericOptionsArea.getWidth() - 15, 1);
        valuesSeparator.setPosition(0, 10, Anchor.TOP | Anchor.CENTER);
        UILabel secondsToStayOpenLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.secondsToStayOpen", (Object[])new Object[0]) + ":");
        secondsToStayOpenLabel.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(true).scale(1.1f).build());
        secondsToStayOpenLabel.setPosition(10, numericValuesLabel.getY() + padding + 5, Anchor.LEFT | Anchor.TOP);
        this.secondsToStayOpen = new UITextField((MalisisGui)this, "", false);
        this.secondsToStayOpen.setSize(45, 0);
        this.secondsToStayOpen.setPosition(-10, secondsToStayOpenLabel.getY(), Anchor.RIGHT | Anchor.TOP);
        this.secondsToStayOpen.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(false).build());
        this.secondsToStayOpen.setFilter(s -> {
            try {
                int value = Integer.parseInt(s.replaceAll("[^\\d]", ""));
                return String.valueOf(MathUtil.squashi((int)value, (int)0, (int)50000));
            }
            catch (NumberFormatException e) {
                return "";
            }
        });
        this.secondsToStayOpen.register((Object)this);
        UILabel gateRotationSpeedLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.gateRotationSpeed", (Object[])new Object[0]) + ":");
        gateRotationSpeedLabel.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(true).scale(1.1f).build());
        gateRotationSpeedLabel.setPosition(10, secondsToStayOpenLabel.getY() + padding, Anchor.LEFT | Anchor.TOP);
        this.gateRotationSpeed = new UITextField((MalisisGui)this, "", false);
        this.gateRotationSpeed.setSize(45, 0);
        this.gateRotationSpeed.setPosition(-10, gateRotationSpeedLabel.getY(), Anchor.RIGHT | Anchor.TOP);
        this.gateRotationSpeed.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(false).build());
        this.gateRotationSpeed.setFilter(s -> {
            try {
                double value = Double.parseDouble(s.replaceAll("[^\\d.]", ""));
                return String.valueOf(MathUtil.squashd((double)value, (double)1.0, (double)10.0));
            }
            catch (NumberFormatException e) {
                return "";
            }
        });
        this.gateRotationSpeed.register((Object)this);
        UILabel energyBufferMaxSizeLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.energyBufferSize", (Object[])new Object[0]) + ":");
        energyBufferMaxSizeLabel.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(true).scale(1.1f).build());
        energyBufferMaxSizeLabel.setPosition(10, gateRotationSpeedLabel.getY() + padding, Anchor.LEFT | Anchor.TOP);
        this.energyBufferSize = new UITextField((MalisisGui)this, "", false);
        this.energyBufferSize.setSize(45, 0);
        this.energyBufferSize.setPosition(-10, energyBufferMaxSizeLabel.getY(), Anchor.RIGHT | Anchor.TOP);
        this.energyBufferSize.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(false).build());
        this.energyBufferSize.setFilter(s -> {
            try {
                double value = Double.parseDouble(s.replaceAll("[^\\d.]", ""));
                return String.valueOf(MathUtil.squashd((double)value, (double)0.0, (double)5000000.0));
            }
            catch (NumberFormatException e) {
                return "";
            }
        });
        this.energyBufferSize.register((Object)this);
        UILabel energyPerItemLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.energyPerNaquadah", (Object[])new Object[0]) + ":");
        energyPerItemLabel.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(true).scale(1.1f).build());
        energyPerItemLabel.setPosition(10, energyBufferMaxSizeLabel.getY() + padding, Anchor.LEFT | Anchor.TOP);
        this.energyPerNaquadah = new UITextField((MalisisGui)this, "", false);
        this.energyPerNaquadah.setSize(45, 0);
        this.energyPerNaquadah.setPosition(-10, energyPerItemLabel.getY(), Anchor.RIGHT | Anchor.TOP);
        this.energyPerNaquadah.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(false).build());
        this.energyPerNaquadah.setFilter(s -> {
            try {
                double value = Double.parseDouble(s.replaceAll("[^\\d.]", ""));
                return String.valueOf(MathUtil.squashd((double)value, (double)0.0, (double)250000.0));
            }
            catch (NumberFormatException e) {
                return "";
            }
        });
        this.energyPerNaquadah.register((Object)this);
        UILabel energyPerOpeningLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.openingsPerNaquadah", (Object[])new Object[0]) + ":");
        energyPerOpeningLabel.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(true).scale(1.1f).build());
        energyPerOpeningLabel.setPosition(10, energyPerItemLabel.getY() + padding, Anchor.LEFT | Anchor.TOP);
        this.gateOpeningsPerNaquadah = new UITextField((MalisisGui)this, "", false);
        this.gateOpeningsPerNaquadah.setSize(45, 0);
        this.gateOpeningsPerNaquadah.setPosition(-10, energyPerOpeningLabel.getY(), Anchor.RIGHT | Anchor.TOP);
        this.gateOpeningsPerNaquadah.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(false).build());
        this.gateOpeningsPerNaquadah.setFilter(s -> {
            try {
                int value = Integer.parseInt(s.replaceAll("[^\\d]", ""));
                return String.valueOf(MathUtil.squashi((int)value, (int)0, (int)50000));
            }
            catch (NumberFormatException e) {
                return "";
            }
        });
        this.gateOpeningsPerNaquadah.register((Object)this);
        UILabel distanceFactorMultiplierLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.distanceFactorMultiplier", (Object[])new Object[0]) + ":");
        distanceFactorMultiplierLabel.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(true).scale(1.1f).build());
        distanceFactorMultiplierLabel.setPosition(10, energyPerOpeningLabel.getY() + padding, Anchor.LEFT | Anchor.TOP);
        this.distanceMultiplier = new UITextField((MalisisGui)this, "", false);
        this.distanceMultiplier.setSize(45, 0);
        this.distanceMultiplier.setPosition(-10, distanceFactorMultiplierLabel.getY(), Anchor.RIGHT | Anchor.TOP);
        this.distanceMultiplier.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(false).build());
        this.distanceMultiplier.setFilter(s -> {
            try {
                double value = Double.parseDouble(s.replaceAll("[^\\d.]", ""));
                return String.valueOf(MathUtil.squashd((double)value, (double)0.0, (double)1000.0));
            }
            catch (NumberFormatException e) {
                return "";
            }
        });
        this.distanceMultiplier.register((Object)this);
        UILabel interDimensionalMultiplierLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.interDimensionalMultiplier", (Object[])new Object[0]) + ":");
        interDimensionalMultiplierLabel.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(true).scale(1.1f).build());
        interDimensionalMultiplierLabel.setPosition(10, distanceFactorMultiplierLabel.getY() + padding, Anchor.LEFT | Anchor.TOP);
        this.dimensionalMultiplier = new UITextField((MalisisGui)this, "", false);
        this.dimensionalMultiplier.setSize(45, 0);
        this.dimensionalMultiplier.setPosition(-10, interDimensionalMultiplierLabel.getY(), Anchor.RIGHT | Anchor.TOP);
        this.dimensionalMultiplier.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(false).build());
        this.dimensionalMultiplier.setFilter(s -> {
            try {
                double value = Double.parseDouble(s.replaceAll("[^\\d.]", ""));
                return String.valueOf(MathUtil.squashd((double)value, (double)0.0, (double)1000.0));
            }
            catch (NumberFormatException e) {
                return "";
            }
        });
        this.dimensionalMultiplier.register((Object)this);
        this.gateAddressAccessListButton = new UIButtonBuilder((MalisisGui)this).width(160).anchor(Anchor.TOP | Anchor.CENTER).position(0, this.dimensionalMultiplier.getY() + 60).enabled(this.gateAccessPerm).text(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.button.gateAddressAccessList", (Object[])new Object[0])).onClick(() -> new GateAddressAccessScreen(this, this.player, this.world, true).display()).listener((Object)this).build("button.gateaddressaccesslist");
        this.playerAccessListButton = new UIButtonBuilder((MalisisGui)this).width(160).anchor(Anchor.TOP | Anchor.CENTER).position(0, this.gateAddressAccessListButton.getY() + 20).enabled(this.playerAccessPerm).text(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.button.playerAccessList", (Object[])new Object[0])).onClick(() -> new PlayerAccessScreen(this, this.player, this.world, true).display()).listener((Object)this).build("button.playeraccesslist");
        UILabel accessControlSystemsLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.accessControlSystems", (Object[])new Object[0]) + ":");
        accessControlSystemsLabel.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(true).scale(1.1f).build());
        accessControlSystemsLabel.setPosition(0, this.gateAddressAccessListButton.getY() - 20, Anchor.CENTER | Anchor.TOP);
        UISeparator accSeparator = new UISeparator((MalisisGui)this);
        accSeparator.setSize(this.numericOptionsArea.getWidth() - 15, 1);
        accSeparator.setPosition(0, accessControlSystemsLabel.getY() + 10, Anchor.TOP | Anchor.CENTER);
        this.numericOptionsArea.add(new UIComponent[]{numericValuesLabel, valuesSeparator, secondsToStayOpenLabel, gateRotationSpeedLabel, energyBufferMaxSizeLabel, energyPerItemLabel, energyPerOpeningLabel, distanceFactorMultiplierLabel, interDimensionalMultiplierLabel});
        this.numericOptionsArea.add(new UIComponent[]{this.secondsToStayOpen, this.gateRotationSpeed, this.energyBufferSize, this.energyPerNaquadah, this.gateOpeningsPerNaquadah, this.distanceMultiplier, this.dimensionalMultiplier});
        this.numericOptionsArea.add(new UIComponent[]{this.gateAddressAccessListButton, this.playerAccessListButton, accessControlSystemsLabel, accSeparator});
        this.checkboxOptionsArea = new BasicForm((MalisisGui)this, 245, 260, "");
        this.checkboxOptionsArea.setPosition(0, 0, Anchor.RIGHT | Anchor.MIDDLE);
        this.checkboxOptionsArea.setMovable(false);
        this.checkboxOptionsArea.setClosable(false);
        this.checkboxOptionsArea.setBorder(0xFFFFFF, 1, 185);
        this.checkboxOptionsArea.setBackgroundAlpha(215);
        this.checkboxOptionsArea.setBottomPadding(3);
        this.checkboxOptionsArea.setRightPadding(3);
        this.checkboxOptionsArea.setTopPadding(3);
        this.checkboxOptionsArea.setLeftPadding(3);
        int checkboxIndentPadding = 10;
        padding = 12;
        UILabel booleanValuesLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.booleanValue", (Object[])new Object[0]));
        booleanValuesLabel.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(true).scale(1.1f).build());
        booleanValuesLabel.setPosition(0, 0, Anchor.CENTER | Anchor.TOP);
        UISeparator checkboxSeparator = new UISeparator((MalisisGui)this);
        checkboxSeparator.setSize(this.checkboxOptionsArea.getWidth() - 15, 1);
        checkboxSeparator.setPosition(0, 10, Anchor.TOP | Anchor.CENTER);
        this.oneWayTravelCheckbox = new UICheckBox((MalisisGui)this);
        this.oneWayTravelCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.oneWayTravelOnly", (Object[])new Object[0]));
        this.oneWayTravelCheckbox.setPosition(checkboxIndentPadding, 20, Anchor.LEFT | Anchor.TOP);
        this.oneWayTravelCheckbox.setName("checkbox.onewaytravel");
        this.oneWayTravelCheckbox.register((Object)this);
        this.irisUpgradeCheckbox = new UICheckBox((MalisisGui)this);
        this.irisUpgradeCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.irisUpgrade", (Object[])new Object[0]));
        this.irisUpgradeCheckbox.setPosition(checkboxIndentPadding, this.oneWayTravelCheckbox.getY() + padding, Anchor.LEFT | Anchor.TOP);
        this.irisUpgradeCheckbox.setName("checkbox.irisupgrade");
        this.irisUpgradeCheckbox.register((Object)this);
        this.chevronUpgradeCheckbox = new UICheckBox((MalisisGui)this);
        this.chevronUpgradeCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.chevronUpgrade", (Object[])new Object[0]));
        this.chevronUpgradeCheckbox.setPosition(checkboxIndentPadding, this.irisUpgradeCheckbox.getY() + padding, Anchor.LEFT | Anchor.TOP);
        this.chevronUpgradeCheckbox.setName("checkbox.chevronupgrade");
        this.chevronUpgradeCheckbox.register((Object)this);
        this.gateTypeCheckbox = new UICheckBox((MalisisGui)this);
        this.gateTypeCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.pegasusGateType", (Object[])new Object[0]));
        this.gateTypeCheckbox.setPosition(checkboxIndentPadding, this.chevronUpgradeCheckbox.getY() + padding, Anchor.LEFT | Anchor.TOP);
        this.gateTypeCheckbox.setName("checkbox.gateType");
        this.gateTypeCheckbox.register((Object)this);
        this.reverseWormholeKillsCheckbox = new UICheckBox((MalisisGui)this);
        this.reverseWormholeKillsCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.reverseWormholeKills", (Object[])new Object[0]));
        this.reverseWormholeKillsCheckbox.setPosition(checkboxIndentPadding, this.gateTypeCheckbox.getY() + padding, Anchor.LEFT | Anchor.TOP);
        this.reverseWormholeKillsCheckbox.setName("checkbox.reversekills");
        this.reverseWormholeKillsCheckbox.register((Object)this);
        this.closeFromEitherEndCheckbox = new UICheckBox((MalisisGui)this);
        this.closeFromEitherEndCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.closeFromEitherEnd", (Object[])new Object[0]));
        this.closeFromEitherEndCheckbox.setPosition(checkboxIndentPadding, this.reverseWormholeKillsCheckbox.getY() + padding, Anchor.LEFT | Anchor.TOP);
        this.closeFromEitherEndCheckbox.setName("checkbox.canbedialedto");
        this.closeFromEitherEndCheckbox.register((Object)this);
        this.preserveInventoryCheckbox = new UICheckBox((MalisisGui)this);
        this.preserveInventoryCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.preserveInventoryOnDeath", (Object[])new Object[0]));
        this.preserveInventoryCheckbox.setPosition(checkboxIndentPadding, this.closeFromEitherEndCheckbox.getY() + padding, Anchor.LEFT | Anchor.TOP);
        this.preserveInventoryCheckbox.setName("checkbox.canbedialedto");
        this.preserveInventoryCheckbox.register((Object)this);
        this.noPowerRequiredCheckbox = new UICheckBox((MalisisGui)this);
        this.noPowerRequiredCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.noInputPowerRequired", (Object[])new Object[0]));
        this.noPowerRequiredCheckbox.setPosition(checkboxIndentPadding, this.preserveInventoryCheckbox.getY() + padding, Anchor.LEFT | Anchor.TOP);
        this.noPowerRequiredCheckbox.setName("checkbox.nopowerrequired");
        this.noPowerRequiredCheckbox.register((Object)this);
        this.chevronsLockOnDialCheckbox = new UICheckBox((MalisisGui)this);
        this.chevronsLockOnDialCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.chevronsLockOnDial", (Object[])new Object[0]));
        this.chevronsLockOnDialCheckbox.setPosition(checkboxIndentPadding, this.noPowerRequiredCheckbox.getY() + padding, Anchor.LEFT | Anchor.TOP);
        this.chevronsLockOnDialCheckbox.setEnabled(true);
        this.chevronsLockOnDialCheckbox.setName("checkbox.chevronlockondial");
        this.chevronsLockOnDialCheckbox.register((Object)this);
        this.returnIrisToPreviousStateCheckbox = new UICheckBox((MalisisGui)this);
        this.returnIrisToPreviousStateCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.returnToPreviousIrisState", (Object[])new Object[0]));
        this.returnIrisToPreviousStateCheckbox.setPosition(checkboxIndentPadding, this.chevronsLockOnDialCheckbox.getY() + padding, Anchor.LEFT | Anchor.TOP);
        this.returnIrisToPreviousStateCheckbox.setEnabled(true);
        this.returnIrisToPreviousStateCheckbox.setName("checkbox.returntopreviousirisstate");
        this.returnIrisToPreviousStateCheckbox.register((Object)this);
        this.transientDamageCheckbox = new UICheckBox((MalisisGui)this);
        this.transientDamageCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.transientDamage", (Object[])new Object[0]));
        this.transientDamageCheckbox.setPosition(checkboxIndentPadding, this.returnIrisToPreviousStateCheckbox.getY() + padding, Anchor.LEFT | Anchor.TOP);
        this.transientDamageCheckbox.setEnabled(localGate.gateOrientation == 1);
        this.transientDamageCheckbox.setName("checkbox.transientDamage");
        this.transientDamageCheckbox.register((Object)this);
        this.transparencyCheckbox = new UICheckBox((MalisisGui)this);
        this.transparencyCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.eventHorizonTransparency", (Object[])new Object[0]));
        this.transparencyCheckbox.setPosition(checkboxIndentPadding, this.transientDamageCheckbox.getY() + padding, Anchor.LEFT | Anchor.TOP);
        this.transparencyCheckbox.setEnabled(true);
        this.transparencyCheckbox.setName("checkbox.eventhorizontransparent");
        this.transparencyCheckbox.register((Object)this);
        this.useDHDFuelSourceCheckbox = new UICheckBox((MalisisGui)this);
        this.useDHDFuelSourceCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.dhdAsFuelSource", (Object[])new Object[0]));
        this.useDHDFuelSourceCheckbox.setPosition(checkboxIndentPadding, this.transparencyCheckbox.getY() + padding, Anchor.LEFT | Anchor.TOP);
        this.useDHDFuelSourceCheckbox.setEnabled(true);
        this.useDHDFuelSourceCheckbox.setName("checkbox.dhdfuelsource");
        this.useDHDFuelSourceCheckbox.register((Object)this);
        this.allowRedstoneOutputCheckbox = new UICheckBox((MalisisGui)this);
        this.allowRedstoneOutputCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.allowRedstoneOutput", (Object[])new Object[0]));
        this.allowRedstoneOutputCheckbox.setPosition(checkboxIndentPadding, this.useDHDFuelSourceCheckbox.getY() + padding, Anchor.LEFT | Anchor.TOP);
        this.allowRedstoneOutputCheckbox.setEnabled(true);
        this.allowRedstoneOutputCheckbox.setName("checkbox.redstoneoutput");
        this.allowRedstoneOutputCheckbox.register((Object)this);
        this.allowRedstoneInputCheckbox = new UICheckBox((MalisisGui)this);
        this.allowRedstoneInputCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.allowRedstoneInput", (Object[])new Object[0]));
        this.allowRedstoneInputCheckbox.setPosition(checkboxIndentPadding, this.allowRedstoneOutputCheckbox.getY() + padding, Anchor.LEFT | Anchor.TOP);
        this.allowRedstoneInputCheckbox.setEnabled(true);
        this.allowRedstoneInputCheckbox.setName("checkbox.redstoneinput");
        this.allowRedstoneInputCheckbox.register((Object)this);
        this.playerCanDestroyGateCheckbox = new UICheckBox((MalisisGui)this);
        this.playerCanDestroyGateCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.playerCanDestroyGate", (Object[])new Object[0]));
        this.playerCanDestroyGateCheckbox.setPosition(checkboxIndentPadding, this.allowRedstoneInputCheckbox.getY() + padding, Anchor.LEFT | Anchor.TOP);
        this.playerCanDestroyGateCheckbox.setEnabled(true);
        this.playerCanDestroyGateCheckbox.setName("checkbox.playercandestroygate");
        this.playerCanDestroyGateCheckbox.register((Object)this);
        this.displayGateAddressCheckbox = new UICheckBox((MalisisGui)this);
        this.displayGateAddressCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.displayGateAddress", (Object[])new Object[0]));
        this.displayGateAddressCheckbox.setPosition(checkboxIndentPadding, this.playerCanDestroyGateCheckbox.getY() + padding, Anchor.LEFT | Anchor.TOP);
        this.displayGateAddressCheckbox.setEnabled(true);
        this.displayGateAddressCheckbox.setName("checkbox.displaygateaddress");
        this.displayGateAddressCheckbox.register((Object)this);
        this.horizontalFaceUpCheckbox = new UICheckBox((MalisisGui)this);
        this.horizontalFaceUpCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.renderFaceUp", (Object[])new Object[0]));
        this.horizontalFaceUpCheckbox.setPosition(70, -15, Anchor.LEFT | Anchor.BOTTOM);
        this.horizontalFaceUpCheckbox.setEnabled(true);
        this.horizontalFaceUpCheckbox.setChecked(localGate.gateOrientation == 2);
        this.horizontalFaceUpCheckbox.setName("checkbox.horizontalup");
        this.horizontalFaceUpCheckbox.register((Object)this);
        this.horizontalFaceDownCheckbox = new UICheckBox((MalisisGui)this);
        this.horizontalFaceDownCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.renderFaceDown", (Object[])new Object[0]));
        this.horizontalFaceDownCheckbox.setPosition(70, -2, Anchor.LEFT | Anchor.BOTTOM);
        this.horizontalFaceDownCheckbox.setEnabled(true);
        this.horizontalFaceDownCheckbox.setChecked(localGate.gateOrientation == 3);
        this.horizontalFaceDownCheckbox.setName("checkbox.horizontaldown");
        this.horizontalFaceDownCheckbox.register((Object)this);
        UILabel horizontalGateLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.horizontalGate", (Object[])new Object[0]));
        horizontalGateLabel.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(true).scale(1.1f).build());
        horizontalGateLabel.setPosition(0, this.horizontalFaceUpCheckbox.getY() - 16, Anchor.CENTER | Anchor.BOTTOM);
        UISeparator checkbox2Separator = new UISeparator((MalisisGui)this);
        checkbox2Separator.setSize(this.checkboxOptionsArea.getWidth() - 15, 1);
        checkbox2Separator.setPosition(0, horizontalGateLabel.getY() - 12, Anchor.CENTER | Anchor.BOTTOM);
        UISeparator checkbox3Separator = new UISeparator((MalisisGui)this);
        checkbox3Separator.setSize(this.checkboxOptionsArea.getWidth() - 15, 1);
        checkbox3Separator.setPosition(0, horizontalGateLabel.getY() + 2, Anchor.CENTER | Anchor.BOTTOM);
        this.checkboxOptionsArea.add(new UIComponent[]{booleanValuesLabel, checkboxSeparator, this.oneWayTravelCheckbox, this.irisUpgradeCheckbox, this.chevronUpgradeCheckbox, this.gateTypeCheckbox});
        this.checkboxOptionsArea.add(new UIComponent[]{this.reverseWormholeKillsCheckbox, this.closeFromEitherEndCheckbox, this.preserveInventoryCheckbox, this.noPowerRequiredCheckbox});
        this.checkboxOptionsArea.add(new UIComponent[]{this.chevronsLockOnDialCheckbox, this.returnIrisToPreviousStateCheckbox, this.transientDamageCheckbox, this.transparencyCheckbox, this.useDHDFuelSourceCheckbox});
        this.checkboxOptionsArea.add(new UIComponent[]{this.allowRedstoneOutputCheckbox, this.allowRedstoneInputCheckbox, this.playerCanDestroyGateCheckbox, this.displayGateAddressCheckbox});
        if (localGate.gateOrientation == 2 || localGate.gateOrientation == 3) {
            this.checkboxOptionsArea.add(new UIComponent[]{checkbox2Separator, checkbox3Separator, horizontalGateLabel, this.horizontalFaceUpCheckbox, this.horizontalFaceDownCheckbox});
        }
        UIButton buttonDefaults = new UIButtonBuilder((MalisisGui)this).width(40).anchor(Anchor.BOTTOM | Anchor.LEFT).text(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.button.loadDefaults", (Object[])new Object[0])).onClick(() -> {
            this.secondsToStayOpen.setText(String.valueOf(SGBaseTE.cfg.getInteger("stargate", "secondsToStayOpen", 500)));
            this.gateRotationSpeed.setText(String.valueOf(2.0));
            this.energyBufferSize.setText(String.valueOf(SGBaseTE.cfg.getDouble("stargate", "maxEnergyBuffer", 2500.0)));
            this.energyPerNaquadah.setText(String.valueOf(SGBaseTE.cfg.getDouble("stargate", "energyPerFuelItem", 25000.0)));
            this.gateOpeningsPerNaquadah.setText(String.valueOf(SGBaseTE.cfg.getInteger("stargate", "gateOpeningsPerFuelItem", 10)));
            this.distanceMultiplier.setText(String.valueOf(SGBaseTE.cfg.getDouble("stargate", "distanceFactorMultiplier", 1.0)));
            this.dimensionalMultiplier.setText(String.valueOf(SGBaseTE.cfg.getDouble("stargate", "interDimensionMultiplier", 4.0)));
            this.oneWayTravelCheckbox.setChecked(SGBaseTE.cfg.getBoolean("stargate", "oneWayTravel", true));
            this.irisUpgradeCheckbox.setChecked(SGBaseTE.cfg.getBoolean("stargate", "irisUpgrade", true));
            this.chevronUpgradeCheckbox.setChecked(SGBaseTE.cfg.getBoolean("stargate", "chevronUpgrade", true));
            this.reverseWormholeKillsCheckbox.setChecked(SGBaseTE.cfg.getBoolean("stargate", "reverseWormholeKills", false));
            this.closeFromEitherEndCheckbox.setChecked(SGBaseTE.cfg.getBoolean("stargate", "requiresNoPower", true));
            this.preserveInventoryCheckbox.setChecked(SGBaseTE.cfg.getBoolean("iris", "preserveInventory", false));
            this.noPowerRequiredCheckbox.setChecked(SGBaseTE.cfg.getBoolean("stargate", "closeFromEitherEnd", false));
            this.chevronsLockOnDialCheckbox.setChecked(SGBaseTE.cfg.getBoolean("stargate", "chevronsLockOnDial", false));
            this.returnIrisToPreviousStateCheckbox.setChecked(SGBaseTE.cfg.getBoolean("stargate", "returnToPreviousIrisState", false));
            this.transientDamageCheckbox.setChecked(SGBaseTE.cfg.getBoolean("stargate", "transientDamage", true));
            this.transparencyCheckbox.setChecked(SGBaseTE.cfg.getBoolean("stargate", "transparency", true));
            this.useDHDFuelSourceCheckbox.setChecked(SGBaseTE.cfg.getBoolean("dhd", "useDHDFuelSource", true));
            this.allowRedstoneOutputCheckbox.setChecked(SGBaseTE.cfg.getBoolean("stargate", "allowRedstoneOutput", true));
            this.allowRedstoneInputCheckbox.setChecked(SGBaseTE.cfg.getBoolean("iris", "allowRedstoneInput", true));
            this.playerCanDestroyGateCheckbox.setChecked(SGBaseTE.cfg.getBoolean("gate", "canPlayerBreakGate", true));
            this.displayGateAddressCheckbox.setChecked(SGBaseTE.cfg.getBoolean("stargate", "displayGateAddress", true));
            if (localGate.gateOrientation == 1) {
                this.transientDamageCheckbox.setChecked(false);
            }
        }).listener((Object)this).build("button.defaults");
        UIButton buttonClose = new UIButtonBuilder((MalisisGui)this).width(40).anchor(Anchor.BOTTOM | Anchor.RIGHT).text(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.button.close", (Object[])new Object[0])).onClick(() -> this.close()).listener((Object)this).build("button.close");
        UIButton buttonSave = new UIButtonBuilder((MalisisGui)this).width(40).anchor(Anchor.BOTTOM | Anchor.RIGHT).position(-(buttonClose.getX() + buttonClose.getWidth() + 5), 0).text(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.button.save", (Object[])new Object[0])).onClick(() -> {
            int gateType = 1;
            int orientation = 1;
            if (this.gateTypeCheckbox.isChecked()) {
                gateType = 2;
            }
            if (localGate.gateOrientation == 2 || localGate.gateOrientation == 3) {
                orientation = this.horizontalFaceUpCheckbox.isChecked() ? 2 : 3;
            }
            ConfiguratorNetworkHandler.sendConfiguratorInputToServer(localGate, Integer.valueOf(this.secondsToStayOpen.getText()), Double.valueOf(this.gateRotationSpeed.getText()), Double.valueOf(this.energyBufferSize.getText()), Double.valueOf(this.energyPerNaquadah.getText()), Integer.valueOf(this.gateOpeningsPerNaquadah.getText()), Double.valueOf(this.distanceMultiplier.getText()), Double.valueOf(this.dimensionalMultiplier.getText()), this.oneWayTravelCheckbox.isChecked(), this.irisUpgradeCheckbox.isChecked(), this.chevronUpgradeCheckbox.isChecked(), gateType, this.reverseWormholeKillsCheckbox.isChecked(), this.closeFromEitherEndCheckbox.isChecked(), this.preserveInventoryCheckbox.isChecked(), this.noPowerRequiredCheckbox.isChecked(), this.chevronsLockOnDialCheckbox.isChecked(), this.returnIrisToPreviousStateCheckbox.isChecked(), this.transientDamageCheckbox.isChecked(), this.transparencyCheckbox.isChecked(), orientation, this.useDHDFuelSourceCheckbox.isChecked(), this.allowRedstoneOutputCheckbox.isChecked(), this.allowRedstoneInputCheckbox.isChecked(), this.playerCanDestroyGateCheckbox.isChecked(), this.displayGateAddressCheckbox.isChecked());
            this.close();
        }).listener((Object)this).build("button.save");
        UILabel addressLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.gateAddress", (Object[])new Object[0]) + ":");
        addressLabel.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(true).scale(1.1f).build());
        addressLabel.setPosition(-40, -3, Anchor.CENTER | Anchor.BOTTOM);
        this.gateAddressLabel = new UILabel((MalisisGui)this, "");
        this.gateAddressLabel.setFontOptions(FontOptions.builder().from(FontColors.BLUE_FO).shadow(true).scale(1.1f).build());
        this.gateAddressLabel.setPosition(40, -2, Anchor.CENTER | Anchor.BOTTOM);
        this.form.add(new UIComponent[]{titleLabel, this.numericOptionsArea, this.checkboxOptionsArea, buttonDefaults, buttonSave, addressLabel, this.gateAddressLabel, buttonClose});
        this.addToScreen((UIComponent)this.form);
        this.refresh();
    }

    @Subscribe
    public void onValueChange(ComponentEvent.ValueChange event) {
        if (event.getComponent().getName() != null) {
            switch (event.getComponent().getName()) {
                case "checkbox.horizontalup": {
                    this.horizontalFaceDownCheckbox.setChecked(this.horizontalFaceUpCheckbox.isChecked());
                    break;
                }
                case "checkbox.horizontaldown": {
                    this.horizontalFaceUpCheckbox.setChecked(this.horizontalFaceDownCheckbox.isChecked());
                    break;
                }
                case "checkbox.gateType": {
                    if (!this.gateTypeCheckbox.isChecked()) {
                        this.gateRotationSpeed.setText("6.0");
                        break;
                    }
                    this.gateRotationSpeed.setText("3.0");
                }
            }
        }
    }

    @Subscribe
    public void onFocusStateChange(StateChangeEvent.FocusStateChange<UITextField> event) {
        TileEntity localGateTE = GateUtil.locateLocalGate(this.world, this.location, 6, false);
        if (localGateTE instanceof SGBaseTE) {
            SGBaseTE localGate = (SGBaseTE)localGateTE;
            if (this.secondsToStayOpen.getText().isEmpty()) {
                this.secondsToStayOpen.setText(String.valueOf(localGate.secondsToStayOpen));
            }
            if (this.gateRotationSpeed.getText().isEmpty()) {
                this.gateRotationSpeed.setText(String.valueOf(localGate.ringRotationSpeed));
            }
            if (this.energyBufferSize.getText().isEmpty()) {
                this.energyBufferSize.setText(String.valueOf(localGate.maxEnergyBuffer));
            }
            if (this.energyPerNaquadah.getText().isEmpty()) {
                this.energyPerNaquadah.setText(String.valueOf(localGate.energyPerFuelItem));
            }
            if (this.gateOpeningsPerNaquadah.getText().isEmpty()) {
                this.gateOpeningsPerNaquadah.setText(String.valueOf(localGate.gateOpeningsPerFuelItem));
            }
            if (this.distanceMultiplier.getText().isEmpty()) {
                this.distanceMultiplier.setText(String.valueOf(localGate.distanceFactorMultiplier));
            }
            if (this.dimensionalMultiplier.getText().isEmpty()) {
                this.dimensionalMultiplier.setText(String.valueOf(localGate.interDimensionMultiplier));
            }
        }
    }

    private void refresh() {
        TileEntity localGateTE = GateUtil.locateLocalGate(this.world, this.location, 6, false);
        if (localGateTE instanceof SGBaseTE) {
            SGBaseTE localGate = (SGBaseTE)localGateTE;
            this.gateAddressLabel.setText(SGAddressing.formatAddress(localGate.homeAddress, "-", "-"));
            this.secondsToStayOpen.setText(String.valueOf(localGate.secondsToStayOpen));
            this.secondsToStayOpen.setEnabled(this.secondsToStayOpenPerm);
            this.gateRotationSpeed.setText(String.valueOf(localGate.ringRotationSpeed));
            this.gateRotationSpeed.setEnabled(this.gateRotationSpeedPerm);
            this.energyBufferSize.setText(String.valueOf(localGate.maxEnergyBuffer));
            this.energyBufferSize.setEnabled(this.energyBufferSizePerm);
            this.energyPerNaquadah.setText(String.valueOf(localGate.energyPerFuelItem));
            this.energyPerNaquadah.setEnabled(this.energyPerNaquadahPerm);
            this.gateOpeningsPerNaquadah.setText(String.valueOf(localGate.gateOpeningsPerFuelItem));
            this.gateOpeningsPerNaquadah.setEnabled(this.openingsPerNaquadahPerm);
            this.distanceMultiplier.setText(String.valueOf(localGate.distanceFactorMultiplier));
            this.distanceMultiplier.setEnabled(this.distanceFactorMultiplierPerm);
            this.dimensionalMultiplier.setText(String.valueOf(localGate.interDimensionMultiplier));
            this.dimensionalMultiplier.setEnabled(this.interDimensionalMultiplierPerm);
            this.oneWayTravelCheckbox.setChecked(localGate.oneWayTravel);
            this.oneWayTravelCheckbox.setEnabled(this.oneWayTravelOnlyPerm);
            this.irisUpgradeCheckbox.setChecked(localGate.hasIrisUpgrade);
            this.irisUpgradeCheckbox.setEnabled(this.irisUpgradePerm);
            this.chevronUpgradeCheckbox.setChecked(localGate.hasChevronUpgrade);
            this.chevronUpgradeCheckbox.setEnabled(this.chevronUpgradePerm);
            if (localGate.gateType == 0 || localGate.gateType == 1) {
                this.gateTypeCheckbox.setChecked(false);
            } else {
                this.gateTypeCheckbox.setChecked(true);
            }
            this.gateTypeCheckbox.setEnabled(this.pegasusGateTypePerm);
            this.reverseWormholeKillsCheckbox.setChecked(localGate.reverseWormholeKills);
            this.reverseWormholeKillsCheckbox.setEnabled(this.reverseWormholeKillsPerm);
            this.closeFromEitherEndCheckbox.setChecked(localGate.closeFromEitherEnd);
            this.closeFromEitherEndCheckbox.setEnabled(this.closeFromEitherEndPerm);
            this.preserveInventoryCheckbox.setChecked(localGate.preserveInventory);
            this.preserveInventoryCheckbox.setEnabled(this.preserveInventoryOnIrisDeathPerm);
            this.noPowerRequiredCheckbox.setChecked(localGate.requiresNoPower);
            this.noPowerRequiredCheckbox.setEnabled(this.noInputPowerRequiredPerm);
            this.chevronsLockOnDialCheckbox.setChecked(localGate.chevronsLockOnDial);
            this.chevronsLockOnDialCheckbox.setEnabled(this.chevronsLockOnDialPerm);
            this.returnIrisToPreviousStateCheckbox.setChecked(localGate.returnToPreviousIrisState);
            this.returnIrisToPreviousStateCheckbox.setEnabled(this.returnToPreviousIrisStatePerm);
            if (localGate.gateOrientation == 1) {
                this.transientDamageCheckbox.setChecked(localGate.transientDamage);
            } else {
                this.transientDamageCheckbox.setChecked(false);
            }
            this.transientDamageCheckbox.setEnabled(this.transientDamagePerm);
            this.transparencyCheckbox.setChecked(localGate.transparency);
            this.transparencyCheckbox.setEnabled(this.transparencyPerm);
            this.useDHDFuelSourceCheckbox.setChecked(localGate.useDHDFuelSource);
            this.useDHDFuelSourceCheckbox.setEnabled(this.dhdAsFuelSourcePerm);
            this.allowRedstoneOutputCheckbox.setChecked(localGate.allowRedstoneOutput);
            this.allowRedstoneOutputCheckbox.setEnabled(this.allowRedstoneOutputPerm);
            this.allowRedstoneInputCheckbox.setChecked(localGate.allowRedstoneInput);
            this.allowRedstoneInputCheckbox.setEnabled(this.allowRedstoneInputPerm);
            this.playerCanDestroyGateCheckbox.setChecked(localGate.canPlayerBreakGate);
            this.playerCanDestroyGateCheckbox.setEnabled(this.playerCanDestroyGatePerm);
            this.displayGateAddressCheckbox.setChecked(localGate.displayGateAddress);
            this.displayGateAddressCheckbox.setEnabled(this.displayGateAddressPerm);
            if (localGate.gateOrientation == 2) {
                this.horizontalFaceUpCheckbox.setChecked(true);
                this.horizontalFaceDownCheckbox.setChecked(false);
            } else if (localGate.gateOrientation == 3) {
                this.horizontalFaceUpCheckbox.setChecked(false);
                this.horizontalFaceDownCheckbox.setChecked(true);
            }
        }
    }

    public void update(int mouseX, int mouseY, float partialTick) {
        super.update(mouseX, mouseY, partialTick);
        if (this.unlockMouse && this.lastUpdate == 25) {
            Mouse.setGrabbed((boolean)false);
            this.unlockMouse = false;
        }
        if (++this.lastUpdate > 30) {
            this.lastUpdate = 0;
        }
    }

    protected void func_73869_a(char keyChar, int keyCode) {
        if (keyCode == 15) {
            if (this.secondsToStayOpen.isFocused()) {
                this.gateRotationSpeed.setFocused(true);
                return;
            }
            if (this.gateRotationSpeed.isFocused()) {
                this.energyBufferSize.setFocused(true);
                return;
            }
            if (this.energyBufferSize.isFocused()) {
                this.energyPerNaquadah.setFocused(true);
                return;
            }
            if (this.energyPerNaquadah.isFocused()) {
                this.gateOpeningsPerNaquadah.setFocused(true);
                return;
            }
            if (this.gateOpeningsPerNaquadah.isFocused()) {
                this.distanceMultiplier.setFocused(true);
                return;
            }
            if (this.distanceMultiplier.isFocused()) {
                this.dimensionalMultiplier.setFocused(true);
                return;
            }
            if (this.dimensionalMultiplier.isFocused()) {
                this.secondsToStayOpen.setFocused(true);
                return;
            }
        }
        super.func_73869_a(keyChar, keyCode);
        this.lastUpdate = 0;
    }

    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        this.lastUpdate = 0;
    }

    public boolean func_73868_f() {
        return false;
    }
}

