/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BaseBlockUtils {
    public static String getNameForBlock(Block block) {
        return ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString();
    }

    public static boolean blockIsGettingExternallyPowered(World world, BlockPos pos) {
        for (EnumFacing side : BaseUtils.facings) {
            if (!BaseBlockUtils.isPoweringSide(world, pos.func_177972_a(side), side)) continue;
            return true;
        }
        return false;
    }

    static boolean isPoweringSide(World world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.func_180656_a(state, (IBlockAccess)world, pos, side) > 0) {
            return true;
        }
        if (block.shouldCheckWeakPower(state, (IBlockAccess)world, pos, side)) {
            for (EnumFacing side2 : BaseUtils.facings) {
                if (side2 == side.func_176734_d() || world.func_175627_a(pos.func_177972_a(side2), side2) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public static IBlockState getBlockStateFromItemStack(ItemStack stack) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        int meta = 0;
        if (stack.func_77973_b().func_77614_k()) {
            meta = stack.func_77952_i() & 0xF;
        }
        return block.func_176203_a(meta);
    }

    public static IBlockState getBlockStateFromMeta(Block block, int meta) {
        return block.func_176203_a(meta);
    }

    public static int getMetaFromBlockState(IBlockState state) {
        return state.func_177230_c().func_176201_c(state);
    }

    public static Block getWorldBlock(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c();
    }

    public static IBlockState getWorldBlockState(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos);
    }

    public static void setWorldBlockState(World world, BlockPos pos, IBlockState state) {
        world.func_180501_a(pos, state, 3);
    }

    public static void notifyWorldNeighborsOfStateChange(World world, BlockPos pos, Block block) {
        world.func_175685_c(pos, block, true);
    }

    public static TileEntity getWorldTileEntity(IBlockAccess world, BlockPos pos) {
        return world.func_175625_s(pos);
    }

    public static World getTileEntityWorld(TileEntity te) {
        return te.func_145831_w();
    }

    public static BlockPos getTileEntityPos(TileEntity te) {
        return te.func_174877_v();
    }

    public static boolean blockCanRenderInLayer(Block block, BlockRenderLayer layer) {
        return block.canRenderInLayer((IBlockState)block.func_176194_O(), layer);
    }

    public static ItemStack blockStackWithState(IBlockState state, int size) {
        Block block = state.func_177230_c();
        int meta = block.func_176201_c(state);
        return new ItemStack(block, size, meta);
    }

    public static BlockPos readBlockPos(DataInput data) {
        try {
            int x = data.readInt();
            int y = data.readInt();
            int z = data.readInt();
            return new BlockPos(x, y, z);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeBlockPos(DataOutput data, BlockPos pos) {
        try {
            data.writeInt(pos.func_177958_n());
            data.writeInt(pos.func_177956_o());
            data.writeInt(pos.func_177952_p());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void markBlockForUpdate(World world, BlockPos pos) {
        world.func_175704_b(pos, pos);
        if (!world.field_72995_K) {
            IBlockState state = world.func_180495_p(pos);
            world.func_184138_a(pos, state, state, 3);
        }
    }
}

