/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.data;

import com.feed_the_beast.ftblib.lib.math.BlockDimPos;
import com.feed_the_beast.ftbutilities.data.TeleportLog;
import com.feed_the_beast.ftbutilities.data.TeleportType;
import com.mojang.authlib.GameProfile;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.server.permission.IPermissionHandler;
import net.minecraftforge.server.permission.PermissionAPI;

public class TeleportTracker
implements INBTSerializable<NBTTagCompound> {
    private TeleportLog[] logs = new TeleportLog[TeleportType.values().length];
    private IPermissionHandler permissionHandler;

    public TeleportTracker() {
        this(PermissionAPI.getPermissionHandler());
    }

    public TeleportTracker(IPermissionHandler permissionHandler) {
        this.permissionHandler = permissionHandler;
    }

    public void logTeleport(TeleportType teleportType, BlockDimPos from, long worldTime) {
        this.logs[teleportType.ordinal()] = new TeleportLog(teleportType, from, worldTime);
    }

    public TeleportLog getLastDeath() {
        return this.logs[TeleportType.RESPAWN.ordinal()];
    }

    private TeleportLog[] getSortedLogs() {
        TeleportLog[] toSort = (TeleportLog[])Arrays.stream(this.logs).filter(l -> l != null).toArray(TeleportLog[]::new);
        Arrays.sort(toSort, Collections.reverseOrder());
        return toSort;
    }

    public TeleportLog getLastAvailableLog(GameProfile gameProfile) {
        for (TeleportLog l : this.getSortedLogs()) {
            if (!this.permissionHandler.hasPermission(gameProfile, l.teleportType.getPermission(), null)) continue;
            return l;
        }
        return null;
    }

    public TeleportLog getLastLog() {
        TeleportLog[] logs = this.getSortedLogs();
        return logs[0];
    }

    public void clearLog(TeleportType teleportType) {
        this.logs[teleportType.ordinal()] = null;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        for (int i = 0; i < this.logs.length; ++i) {
            nbt.func_74782_a(String.valueOf(i), (NBTBase)this.logs[i].serializeNBT());
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            return;
        }
        for (int i = 0; i < this.logs.length; ++i) {
            this.logs[i] = new TeleportLog(nbt.func_74775_l(String.valueOf(i)));
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        for (int i = 0; i < this.logs.length; ++i) {
            TeleportLog l = this.logs[i];
            builder.append(l.teleportType.toString() + ":" + l.getBlockDimPos());
            if (i == this.logs.length - 1) continue;
            builder.append(",");
        }
        builder.append("}");
        return builder.toString();
    }
}

