/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.intern.discord;

import info.u_team.u_team_core.UCoreConstants;
import info.u_team.u_team_core.intern.event.EventHandlerUpdateDiscordRichPresence;
import info.u_team.u_team_core.registry.CommonRegistry;
import info.u_team.u_team_core.repack.com.jagrosh.discordipc.IPCClient;
import info.u_team.u_team_core.repack.com.jagrosh.discordipc.entities.DiscordBuild;
import info.u_team.u_team_core.repack.com.jagrosh.discordipc.entities.RichPresence;
import info.u_team.u_team_core.repack.com.jagrosh.discordipc.exceptions.NoDiscordClientException;
import java.time.OffsetDateTime;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.fml.common.Loader;

public class DiscordRichPresence {
    private static IPCClient client = new IPCClient(427196986064764928L);
    private static boolean isEnabled = false;
    private static OffsetDateTime time = OffsetDateTime.now();
    public static State current = new State(EnumState.STARTUP);
    private static int errorcount = 0;
    private static Timer timer = new Timer("Discord Rich Presence Timer Thread");
    private static TimerTask task;

    public static void start() {
        try {
            client.connect(new DiscordBuild[0]);
            task = new TimerTask(){

                @Override
                public void run() {
                    DiscordRichPresence.setState(current);
                }
            };
            timer.schedule(task, 1000L, 120000L);
            CommonRegistry.registerEventHandler(EventHandlerUpdateDiscordRichPresence.class);
            isEnabled = true;
            UCoreConstants.LOGGER.info("Discord client found and connected.");
        }
        catch (NoDiscordClientException ex) {
            UCoreConstants.LOGGER.info("Discord client was not found.");
        }
    }

    public static void stop() {
        if (task != null) {
            task.cancel();
            task = null;
        }
        try {
            client.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        errorcount = 0;
        CommonRegistry.unregisterEventHandler(EventHandlerUpdateDiscordRichPresence.class);
        isEnabled = false;
        UCoreConstants.LOGGER.info("Discord client closed.");
    }

    public static void setIdling() {
        DiscordRichPresence.setState(new State(EnumState.MENU));
    }

    public static void setDimension(WorldProvider provider) {
        DiscordRichPresence.setState(DiscordRichPresence.getStateFromDimension(provider));
    }

    public static State getStateFromDimension(WorldProvider provider) {
        switch (provider.getDimension()) {
            case -1: {
                return new State(EnumState.NETHER);
            }
            case 0: {
                return new State(EnumState.OVERWORLD);
            }
            case 1: {
                return new State(EnumState.END);
            }
        }
        return new State(EnumState.DIM, provider.func_186058_p().func_186065_b());
    }

    public static void setState(State state) {
        block7: {
            current = state;
            RichPresence.Builder builder = new RichPresence.Builder();
            builder.setDetails("1.12.2 with " + Loader.instance().getModList().size() + " Mods");
            builder.setState(state.getState().getMessage(state.getReplace()));
            builder.setStartTimestamp(time);
            builder.setLargeImage(state.getState().getImageKey(), state.getState().getImageName(state.getReplace()));
            if (state.getState() == EnumState.MENU || state.getState() == EnumState.STARTUP) {
                builder.setSmallImage("uteamcore", "U-Team Core");
            }
            try {
                client.sendRichPresence(builder.build());
            }
            catch (Exception ex) {
                try {
                    client.connect(new DiscordBuild[0]);
                    errorcount = 0;
                    client.sendRichPresence(builder.build());
                }
                catch (Exception ex2) {
                    try {
                        client.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (++errorcount <= 10) break block7;
                    UCoreConstants.LOGGER.info("Discord rich presence stopped cause connection is not working.");
                    DiscordRichPresence.stop();
                }
            }
        }
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> DiscordRichPresence.stop()));
    }

    public static enum EnumState {
        STARTUP("Starting Minecraft", "Minecraft", "minecraft"),
        MENU("Idling in menu", "Minecraft", "minecraft"),
        OVERWORLD("Dimension: Overworld", "Overworld", "world_overworld"),
        NETHER("Dimension: Nether", "Nether", "world_nether"),
        END("Dimension: The End", "The End", "world_the_end"),
        DIM("Dimension: %s", "%s", "world_dim");

        private String message;
        private String imagename;
        private String imagekey;

        private EnumState(String message, String imagename, String imagekey) {
            this.message = message;
            this.imagename = imagename;
            this.imagekey = imagekey;
        }

        public String getMessage(String replace) {
            return this.message.replace("%s", replace);
        }

        public String getImageName(String replace) {
            return this.imagename.replace("%s", replace);
        }

        public String getImageKey() {
            return this.imagekey;
        }
    }

    public static class State {
        private EnumState state;
        private String replace;

        public State(EnumState state) {
            this(state, "");
        }

        public State(EnumState state, String replace) {
            this.state = state;
            this.replace = replace;
        }

        public EnumState getState() {
            return this.state;
        }

        public String getReplace() {
            return this.replace;
        }
    }
}

