/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.blocks;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import omtteam.omlib.api.permission.IHasOwner;
import omtteam.omlib.api.render.camo.ICamoSupport;
import omtteam.omlib.api.render.camo.RenderBlockStateContainer;
import omtteam.omlib.blocks.BlockAbstractTileEntity;
import omtteam.omlib.util.GeneralUtil;
import omtteam.omlib.util.camo.CamoResult;
import omtteam.omlib.util.camo.EnumTool;
import omtteam.omlib.util.player.PlayerUtil;

public abstract class BlockAbstractCamoTileEntity
extends BlockAbstractTileEntity {
    public static final IUnlistedProperty<RenderBlockStateContainer> RENDERBLOCKSTATE = new IUnlistedProperty<RenderBlockStateContainer>(){

        public String getName() {
            return "omlib:camo_property";
        }

        public boolean isValid(RenderBlockStateContainer value) {
            return true;
        }

        public Class<RenderBlockStateContainer> getType() {
            return RenderBlockStateContainer.class;
        }

        public String valueToString(RenderBlockStateContainer value) {
            return value.toString();
        }
    };

    protected BlockAbstractCamoTileEntity(Material material) {
        super(material);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        ICamoSupport camoTE = (ICamoSupport)world.func_175625_s(pos);
        if (camoTE != null && state.func_177230_c() instanceof BlockAbstractCamoTileEntity && state instanceof IExtendedBlockState) {
            IBlockState camoState = camoTE.getCamoState();
            return ((IExtendedBlockState)state).withProperty(RENDERBLOCKSTATE, (Object)new RenderBlockStateContainer(camoState));
        }
        if (camoTE != null && !(state instanceof IExtendedBlockState)) {
            return state.func_177230_c().getExtendedState(state, world, pos);
        }
        return ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("minecraft:grass"))).func_176223_P();
    }

    protected String getDefaultTool() {
        return "";
    }

    protected CamoResult handleCamoActivation(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.MAIN_HAND) {
            ItemStack heldItem = player.func_184614_ca();
            ICamoSupport te = (ICamoSupport)world.func_175625_s(pos);
            if (player.func_70093_af() && heldItem == ItemStack.field_190927_a && te != null) {
                if (PlayerUtil.isPlayerOwner(player, (IHasOwner)te.getOwnedBlock())) {
                    te.setCamoState(state);
                    return new CamoResult(true, EnumTool.byName(this.getDefaultTool()));
                }
                PlayerUtil.addChatMessage((ICommandSender)player, (ITextComponent)new TextComponentString(GeneralUtil.safeLocalize("status.ownership")));
            }
            Block heldBlock = null;
            IBlockState camoState = null;
            if (heldItem != ItemStack.field_190927_a) {
                heldBlock = Block.func_149634_a((Item)heldItem.func_77973_b());
                camoState = heldBlock.getStateForPlacement(world, pos, side.func_176734_d(), hitX, hitY, hitZ, heldItem.func_77960_j(), (EntityLivingBase)player, hand);
            }
            if (!player.func_70093_af() && heldItem != ItemStack.field_190927_a && heldItem.func_77973_b() instanceof ItemBlock && heldBlock.func_149730_j(camoState) && !heldBlock.isAir(camoState, (IBlockAccess)world, pos) && !heldBlock.hasTileEntity(camoState) && !(heldBlock instanceof BlockAbstractCamoTileEntity) && te != null) {
                if (PlayerUtil.isPlayerOwner(player, (IHasOwner)te.getOwnedBlock())) {
                    te.setCamoState(camoState);
                    return new CamoResult(true, EnumTool.byName(camoState.func_177230_c().getHarvestTool(camoState)));
                }
                PlayerUtil.addChatMessage((ICommandSender)player, (ITextComponent)new TextComponentString(GeneralUtil.safeLocalize("status.ownership")));
            }
        }
        return new CamoResult(false, null);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    @ParametersAreNonnullByDefault
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return true;
    }
}

