/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.api.permission;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import omtteam.omlib.api.permission.EnumAccessLevel;
import omtteam.omlib.handler.OMConfig;
import omtteam.omlib.util.player.Player;

public class TrustedPlayer {
    private String name;
    private EnumAccessLevel accessLevel = EnumAccessLevel.NONE;
    private UUID uuid;
    private boolean hacked = false;

    @ParametersAreNonnullByDefault
    public TrustedPlayer(String name) {
        this.name = name;
    }

    @ParametersAreNonnullByDefault
    public TrustedPlayer(Player player) {
        this.name = player.getName();
        this.uuid = player.getUuid();
    }

    @ParametersAreNonnullByDefault
    public TrustedPlayer(Player player, EnumAccessLevel accessLevel) {
        this.name = player.getName();
        this.uuid = player.getUuid();
        this.accessLevel = accessLevel;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EnumAccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public void setAccessLevel(EnumAccessLevel accessLevel) {
        this.accessLevel = accessLevel;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public boolean isHacked() {
        return this.hacked;
    }

    public void setHacked(boolean hacked) {
        this.hacked = hacked;
    }

    public Player getPlayer() {
        return new Player(this.uuid, this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrustedPlayer that = (TrustedPlayer)o;
        return this.hacked == that.hacked && this.name.equals(that.name) && this.accessLevel == that.accessLevel && (OMConfig.GENERAL.offlineModeSupport || Objects.equals(this.uuid, that.uuid));
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.accessLevel, this.uuid, this.hacked});
    }

    public Map<String, String> asMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", this.name);
        map.put("accessLevel", this.accessLevel.ordinal() + ": " + this.accessLevel.getName());
        return map;
    }
}

