/*
 * Decompiled with CFR 0.152.
 */
package org.dave.bonsaitrees.trees;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import org.dave.bonsaitrees.api.IBonsaiIntegration;
import org.dave.bonsaitrees.api.IBonsaiSoil;
import org.dave.bonsaitrees.api.IBonsaiTreeType;
import org.dave.bonsaitrees.api.ITreeTypeRegistry;
import org.dave.bonsaitrees.compat.CraftTweaker2.registries.SoilStatsModificationsRegistry;
import org.dave.bonsaitrees.compat.CraftTweaker2.registries.TreeGrowthModificationsRegistry;
import org.dave.bonsaitrees.misc.ConfigurationHandler;
import org.dave.bonsaitrees.trees.TreeShapeRegistry;
import org.dave.bonsaitrees.utility.Logz;

public class TreeTypeRegistry
implements ITreeTypeRegistry {
    private Map<String, IBonsaiTreeType> treeTypes = new HashMap<String, IBonsaiTreeType>();
    private Map<IBonsaiTreeType, IBonsaiIntegration> integrationMap = new HashMap<IBonsaiTreeType, IBonsaiIntegration>();

    public void clear() {
        this.treeTypes = new HashMap<String, IBonsaiTreeType>();
        this.integrationMap = new HashMap<IBonsaiTreeType, IBonsaiIntegration>();
    }

    public void checkMissingShapes() {
        for (IBonsaiTreeType type : this.getAllTypes()) {
            int shapes = TreeShapeRegistry.getShapeCountForType(type);
            if (shapes != 0) continue;
            Logz.warn("Tree type '%s' has no shapes configured", type.getName());
        }
    }

    public String getBaseGrowTimeHuman(IBonsaiTreeType treeType) {
        float actualGrowTime = this.getBaseGrowTime(treeType);
        int fullSeconds = (int)actualGrowTime / 20;
        int minutes = fullSeconds / 60;
        int seconds = fullSeconds % 60;
        return String.format("%d:%02d", minutes, seconds);
    }

    public int getBaseGrowTime(IBonsaiTreeType treeType) {
        return TreeGrowthModificationsRegistry.getModifiedGrowTime(treeType);
    }

    public int getFinalGrowTime(IBonsaiTreeType treeType, IBonsaiSoil soil) {
        return (int)Math.floor((float)this.getBaseGrowTime(treeType) * SoilStatsModificationsRegistry.getModifiedGrowTimeModifier(soil));
    }

    public Collection<IBonsaiTreeType> getAllTypes() {
        return this.treeTypes.values();
    }

    public IBonsaiTreeType getTypeByName(String name) {
        return this.treeTypes.get(name);
    }

    public IBonsaiTreeType getTypeByStack(ItemStack stack) {
        if (stack == ItemStack.field_190927_a) {
            return null;
        }
        return this.treeTypes.values().stream().filter(treeType -> treeType.worksWith(stack)).findFirst().orElse(null);
    }

    public IBonsaiIntegration getIntegrationForType(IBonsaiTreeType treeType) {
        return this.integrationMap.get(treeType);
    }

    @Override
    public void registerTreeType(IBonsaiIntegration integrator, IBonsaiTreeType treeType) {
        if (Arrays.asList(ConfigurationHandler.IntegrationSettings.disabledTreeTypes).contains(treeType.getName())) {
            Logz.info("Tree type %s has been disabled via config. Skipping...", treeType.getName());
            return;
        }
        if (this.treeTypes.containsKey(treeType.getName())) {
            Logz.info("Tree type %s has already been loaded before. Skipping...", treeType.getName());
            return;
        }
        if (treeType.getExampleStack().func_190926_b()) {
            Logz.info("Tree type %s has no sapling stack. Skipping...", treeType.getName());
            return;
        }
        this.treeTypes.put(treeType.getName(), treeType);
        this.integrationMap.put(treeType, integrator);
    }
}

