/*
 * Decompiled with CFR 0.152.
 */
package org.dave.bonsaitrees.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import org.dave.bonsaitrees.BonsaiTrees;
import org.dave.bonsaitrees.api.IBonsaiSoil;
import org.dave.bonsaitrees.api.IBonsaiTreeType;
import org.dave.bonsaitrees.api.TreeTypeDrop;
import org.dave.bonsaitrees.compat.CraftTweaker2.registries.SoilStatsModificationsRegistry;
import org.dave.bonsaitrees.compat.CraftTweaker2.registries.TreeDropModificationsRegistry;
import org.dave.bonsaitrees.misc.ConfigurationHandler;
import org.dave.bonsaitrees.misc.RenderTickCounter;
import org.dave.bonsaitrees.trees.TreeBlockAccess;
import org.dave.bonsaitrees.trees.TreeShape;
import org.dave.bonsaitrees.trees.TreeShapeRegistry;
import org.lwjgl.opengl.GL11;

public class BonsaiTreeRecipeWrapper
implements IRecipeWrapper,
ITooltipCallback<ItemStack> {
    public final IBonsaiTreeType type;
    public float[] slotChances;
    private IBlockAccess blockAccess;
    private TreeShape treeShape;

    public BonsaiTreeRecipeWrapper(IBonsaiTreeType type) {
        this.type = type;
    }

    public void getIngredients(IIngredients ingredients) {
        ArrayList<List<Object>> inputs = new ArrayList<List<Object>>();
        inputs.add(Arrays.asList(this.type.getExampleStack()));
        List soilList = BonsaiTrees.instance.soilCompatibility.getValidSoilsForTree(this.type).stream().map(IBonsaiSoil::getSoilStack).collect(Collectors.toList());
        inputs.add(soilList);
        ingredients.setInputLists(ItemStack.class, inputs);
        List<TreeTypeDrop> ttDrops = TreeDropModificationsRegistry.getModifiedDropList(this.type);
        ttDrops.sort((a, b) -> (int)(b.chance * 100.0f) - (int)(a.chance * 100.0f));
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        this.slotChances = new float[ttDrops.size()];
        int slot = 0;
        for (TreeTypeDrop drop : ttDrops) {
            drops.add(drop.stack.func_77946_l());
            this.slotChances[slot] = drop.chance;
            ++slot;
        }
        ingredients.setOutputs(ItemStack.class, drops);
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        if (mouseButton != 0) {
            return false;
        }
        if (mouseX < 30 || mouseX >= 75 || mouseY < 0 || mouseY > 40) {
            return false;
        }
        this.treeShape = TreeShapeRegistry.getNextTreeShape(this.type, this.treeShape);
        return true;
    }

    public void drawInfo(Minecraft mc, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        float angle = (float)RenderTickCounter.renderTicks * 45.0f / 128.0f;
        if (this.treeShape == null) {
            this.treeShape = TreeShapeRegistry.getRandomShapeForStack(this.type.getExampleStack());
        }
        if (this.treeShape == null) {
            return;
        }
        List<BlockPos> toRender = this.treeShape.getToRenderPositions();
        if (toRender.isEmpty()) {
            return;
        }
        this.blockAccess = new TreeBlockAccess(this.treeShape);
        BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
        GlStateManager.func_179123_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179106_n();
        GlStateManager.func_179140_f();
        RenderHelper.func_74518_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179089_o();
        GlStateManager.func_179141_d();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        GlStateManager.func_179101_C();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)216.5f);
        GlStateManager.func_179109_b((float)50.0f, (float)20.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        double scale = this.treeShape.getScaleRatio(true);
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
        double progress = 40.0;
        GlStateManager.func_179139_a((double)progress, (double)progress, (double)progress);
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)((float)(this.treeShape.getWidth() + 1) / -2.0f), (float)((float)(this.treeShape.getHeight() + 1) / -2.0f), (float)((float)(this.treeShape.getDepth() + 1) / -2.0f));
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GL11.glFrontFace((int)2304);
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        GlStateManager.func_179118_c();
        this.renderLayer(blockrendererdispatcher, buffer, BlockRenderLayer.SOLID, toRender);
        GlStateManager.func_179141_d();
        this.renderLayer(blockrendererdispatcher, buffer, BlockRenderLayer.CUTOUT_MIPPED, toRender);
        this.renderLayer(blockrendererdispatcher, buffer, BlockRenderLayer.CUTOUT, toRender);
        GlStateManager.func_179103_j((int)7424);
        this.renderLayer(blockrendererdispatcher, buffer, BlockRenderLayer.TRANSLUCENT, toRender);
        tessellator.func_78381_a();
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GL11.glFrontFace((int)2305);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        GlStateManager.func_179099_b();
    }

    public void renderLayer(BlockRendererDispatcher blockrendererdispatcher, BufferBuilder buffer, BlockRenderLayer renderLayer, List<BlockPos> toRender) {
        for (BlockPos pos : toRender) {
            IBlockState state = this.treeShape.getStateAtPos(pos);
            if (!state.func_177230_c().canRenderInLayer(state, renderLayer)) continue;
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)renderLayer);
            try {
                blockrendererdispatcher.func_175018_a(state, pos, this.blockAccess, buffer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ForgeHooksClient.setRenderLayer(null);
        }
    }

    public void onTooltip(int slotIndex, boolean input, ItemStack ingredient, List<String> tooltip) {
        if (slotIndex == 0) {
            String growTimeHuman = BonsaiTrees.instance.typeRegistry.getBaseGrowTimeHuman(this.type);
            tooltip.add(tooltip.size() - 1, TextFormatting.YELLOW + I18n.func_135052_a((String)"bonsaitrees.jei.category.sapling.growtime", (Object[])new Object[]{growTimeHuman}));
        }
        if (slotIndex == 1) {
            IBonsaiSoil soil = BonsaiTrees.instance.soilRegistry.getTypeByStack(ingredient);
            float speedModifier = SoilStatsModificationsRegistry.getModifiedGrowTimeModifier(soil) * 100.0f;
            float dropModifier = SoilStatsModificationsRegistry.getModifiedDropChanceModifier(soil) * 100.0f;
            tooltip.add(tooltip.size() - 1, TextFormatting.AQUA + I18n.func_135052_a((String)"bonsaitrees.jei.category.soil.hint", (Object[])new Object[0]));
            tooltip.add(tooltip.size() - 1, TextFormatting.YELLOW + I18n.func_135052_a((String)"bonsaitrees.jei.category.soil.growTimeModifier", (Object[])new Object[]{Float.valueOf(speedModifier)}));
            tooltip.add(tooltip.size() - 1, TextFormatting.YELLOW + I18n.func_135052_a((String)"bonsaitrees.jei.category.soil.dropChanceModifier", (Object[])new Object[]{Float.valueOf(dropModifier)}));
        }
        if (!ConfigurationHandler.ClientSettings.showChanceInJEI || input) {
            return;
        }
        tooltip.add(tooltip.size() - 1, TextFormatting.YELLOW + I18n.func_135052_a((String)"bonsaitrees.jei.category.growing.chance", (Object[])new Object[]{(int)(this.slotChances[slotIndex - 2] * 100.0f)}));
    }
}

