/*
 * Decompiled with CFR 0.152.
 */
package org.dave.bonsaitrees.integration.mods;

import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockSapling;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.dave.bonsaitrees.api.IBonsaiIntegration;
import org.dave.bonsaitrees.api.IBonsaiSoilRegistry;
import org.dave.bonsaitrees.api.IBonsaiTreeType;
import org.dave.bonsaitrees.api.ITreeTypeRegistry;
import org.dave.bonsaitrees.api.TreeTypeSimple;
import org.dave.bonsaitrees.misc.ConfigurationHandler;
import org.dave.bonsaitrees.soils.BonsaiSoil;
import org.dave.bonsaitrees.utility.Logz;
import org.dave.bonsaitrees.utility.ResourceLoader;
import org.dave.bonsaitrees.utility.SerializationHelper;

public class JSONIntegration
implements IBonsaiIntegration {
    @Override
    public void registerTrees(ITreeTypeRegistry registry) {
        ResourceLoader loader = new ResourceLoader(ConfigurationHandler.treeTypesDir, "assets/bonsaitrees/config/types.d/");
        for (Map.Entry<String, InputStream> entry : loader.getResources().entrySet()) {
            String filename = entry.getKey();
            InputStream is = entry.getValue();
            if (!filename.endsWith(".json")) continue;
            Logz.debug(" > Loading tree type from file: '%s'", filename);
            try {
                TreeTypeSimple treeType = (TreeTypeSimple)SerializationHelper.GSON.fromJson(new JsonReader((Reader)new InputStreamReader(is)), TreeTypeSimple.class);
                registry.registerTreeType(this, treeType);
            }
            catch (JsonParseException e) {
                Logz.info("Could not load tree type from file '%s': %s", filename, e.getLocalizedMessage());
            }
        }
    }

    @Override
    public void registerSoils(IBonsaiSoilRegistry registry) {
        ResourceLoader loader = new ResourceLoader(ConfigurationHandler.soilsDir, "assets/bonsaitrees/config/soils.d/");
        for (Map.Entry<String, InputStream> entry : loader.getResources().entrySet()) {
            String filename = entry.getKey();
            InputStream is = entry.getValue();
            if (!filename.endsWith(".json")) continue;
            Logz.debug(" > Loading soils from file: '%s'", filename);
            try {
                List soils = (List)SerializationHelper.GSON.fromJson(new JsonReader((Reader)new InputStreamReader(is)), new TypeToken<List<BonsaiSoil>>(){}.getType());
                for (BonsaiSoil soil : soils) {
                    registry.registerBonsaiSoilIntegration(this, soil);
                }
            }
            catch (JsonParseException e) {
                Logz.info("Could not load soils from file '%s': %s", filename, e.getLocalizedMessage());
            }
        }
    }

    @Override
    public void generateTree(IBonsaiTreeType type, World world, BlockPos pos, Random rand) {
        if (!(type instanceof TreeTypeSimple)) {
            return;
        }
        TreeTypeSimple simpleType = (TreeTypeSimple)type;
        if (simpleType.getWorldGen() != null) {
            simpleType.getWorldGen().func_180709_b(world, rand, pos);
        } else if (simpleType.getExampleStack().func_77973_b() instanceof ItemBlock && ((ItemBlock)simpleType.getExampleStack().func_77973_b()).func_179223_d() instanceof BlockSapling) {
            BlockSapling saplingBlock = (BlockSapling)((ItemBlock)simpleType.getExampleStack().func_77973_b()).func_179223_d();
            saplingBlock.func_176476_e(world, pos, saplingBlock.func_176203_a(simpleType.getExampleStack().func_77960_j()), rand);
        }
    }
}

