/*
 * Decompiled with CFR 0.152.
 */
package org.dave.bonsaitrees.integration.mods;

import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.ForestryAPI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.dave.bonsaitrees.api.BonsaiDropChances;
import org.dave.bonsaitrees.api.BonsaiIntegration;
import org.dave.bonsaitrees.api.IBonsaiIntegration;
import org.dave.bonsaitrees.api.IBonsaiTreeType;
import org.dave.bonsaitrees.api.ITreeTypeRegistry;
import org.dave.bonsaitrees.integration.TreeTypeForestry;
import org.dave.bonsaitrees.utility.Logz;

@BonsaiIntegration(mod="forestry")
public class Forestry
implements IBonsaiIntegration {
    private List<String> blockedTrees = Arrays.asList("for.trees.species.giantSequoia", "for.trees.species.coastSequoia");

    @Override
    public void registerTrees(ITreeTypeRegistry registry) {
        if (!ForestryAPI.moduleManager.isModuleEnabled("forestry", "arboriculture")) {
            Logz.info("Arboriculture module is disabled. Not loading forestry trees!", new Object[0]);
            return;
        }
        for (ITree tree : TreeManager.treeRoot.getIndividualTemplates()) {
            String id = tree.getGenome().getPrimary().getUnlocalizedName();
            if (this.blockedTrees.contains(id)) continue;
            TreeTypeForestry treeType = new TreeTypeForestry(tree);
            ItemStack woodStack = tree.getGenome().getPrimary().getWoodProvider().getWoodStack().func_77946_l();
            woodStack.func_190920_e(BonsaiDropChances.logAmount);
            treeType.addDrop(woodStack, BonsaiDropChances.logChance);
            ItemStack leafStack = tree.getGenome().getPrimary().getLeafProvider().getDecorativeLeaves().func_77946_l();
            leafStack.func_190920_e(BonsaiDropChances.leafAmount);
            treeType.addDrop(leafStack, BonsaiDropChances.leafChance);
            for (Map.Entry entry : tree.getProducts().entrySet()) {
                ItemStack fruitStack = ((ItemStack)entry.getKey()).func_77946_l();
                fruitStack.func_190920_e(BonsaiDropChances.fruitAmount);
                Float chance = Float.valueOf(((Float)entry.getValue()).floatValue() * BonsaiDropChances.fruitChance);
                treeType.addDrop(fruitStack, chance.floatValue());
            }
            treeType.addDrop(new ItemStack(Items.field_151055_y, BonsaiDropChances.stickAmount), BonsaiDropChances.stickChance);
            ItemStack saplingStack = treeType.getExampleStack();
            saplingStack.func_190920_e(BonsaiDropChances.saplingAmount);
            treeType.addDrop(saplingStack, BonsaiDropChances.saplingChance);
            registry.registerTreeType(this, treeType);
        }
    }

    @Override
    public void generateTree(IBonsaiTreeType type, World world, BlockPos pos, Random rand) {
        ITree tree = ((TreeTypeForestry)type).getForestryTreeType();
        for (int x = 0; x < tree.getGirth(); ++x) {
            for (int z = 0; z < tree.getGirth(); ++z) {
                TreeManager.treeRoot.plantSapling(world, tree, null, pos.func_177963_a((double)x, 0.0, (double)z));
            }
        }
        WorldGenerator treeGen = tree.getTreeGenerator(world, pos, true);
        treeGen.func_180709_b(world, rand, pos);
    }

    @Override
    public void modifyTreeShape(IBonsaiTreeType type, Map<BlockPos, IBlockState> blocks) {
        ITree tree = ((TreeTypeForestry)type).getForestryTreeType();
        for (Map.Entry<BlockPos, IBlockState> entry : blocks.entrySet()) {
            ItemStack leafStack;
            Item leafItem;
            if (!entry.getValue().func_177230_c().getRegistryName().toString().equals("forestry:leaves") || !((leafItem = (leafStack = tree.getGenome().getPrimary().getLeafProvider().getDecorativeLeaves()).func_77973_b()) instanceof ItemBlock)) continue;
            blocks.put(entry.getKey(), ((ItemBlock)leafItem).func_179223_d().func_176203_a(leafStack.func_77960_j()));
        }
    }
}

