/*
 * Decompiled with CFR 0.152.
 */
package org.dave.bonsaitrees.compat.CraftTweaker2.handlers;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import java.util.Locale;
import org.dave.bonsaitrees.compat.CraftTweaker2.registries.SoilStatsModificationsRegistry;
import org.dave.bonsaitrees.soils.EnumSoilStat;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.bonsaitrees.SoilStats")
public class SoilStatsHandler {
    @ZenMethod
    public static void setGrowTimeModifier(String soilName, float modifier) {
        CraftTweakerAPI.apply((IAction)new StatModificationAction(EnumSoilStat.GROW_TIME, soilName, modifier));
    }

    @ZenMethod
    public static void setDropChanceModifier(String soilName, float modifier) {
        CraftTweakerAPI.apply((IAction)new StatModificationAction(EnumSoilStat.DROP_CHANCE, soilName, modifier));
    }

    private static class StatModificationAction
    implements IAction {
        EnumSoilStat type;
        String soilName;
        float modifier;

        public StatModificationAction(EnumSoilStat type, String soilName, float modifier) {
            this.type = type;
            this.soilName = soilName;
            this.modifier = modifier;
        }

        public void apply() {
            SoilStatsModificationsRegistry.setMultiplier(this.type, this.soilName, this.modifier);
        }

        public String describe() {
            return String.format(Locale.ENGLISH, "Setting '%s' modifier for soil '%s' to %.2f", this.type.getHumanName(), this.soilName, Float.valueOf(this.modifier));
        }
    }
}

