/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.lang;

import com.google.common.collect.Maps;
import com.rwtema.careerbees.BeeMod;
import com.rwtema.careerbees.ClientRunnable;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.util.text.translation.LanguageMap;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Lang {
    @Nullable
    private static final TreeMap<String, String> lang = BeeMod.deobf_folder ? new TreeMap() : null;
    private static final HashMap<String, String> textKey = new HashMap();
    @Nullable
    private static final HashMap<String, String> existingMCLangMap;
    @Nonnull
    private static final HashMap<String, String> injectingMCLangMap;
    private static final int MAX_KEY_LEN = 32;
    private static final TObjectIntHashMap<String> numRandomEntries;
    private static int size;

    public static void init() {
        BeeMod.logger.info("Lang Initialized");
    }

    public static void readStream(@Nonnull InputStream stream, boolean safe) {
        Map langMap = LanguageMap.parseLangFile((InputStream)stream);
        if (safe) {
            for (Map.Entry entry : langMap.entrySet()) {
                String key = Lang.makeKey((String)entry.getValue());
                if (key.equals(entry.getKey())) continue;
                lang.put(((String)entry.getKey()).toLowerCase(Locale.ENGLISH), (String)entry.getValue());
            }
        } else {
            for (Map.Entry entry : langMap.entrySet()) {
                lang.put(((String)entry.getKey()).toLowerCase(Locale.ENGLISH), (String)entry.getValue());
            }
        }
    }

    @Nonnull
    public static String translate(@Nonnull String text) {
        return Lang.translatePrefix(text);
    }

    @Nonnull
    public static String translatePrefix(@Nonnull String text) {
        String key = Lang.getKey(text);
        return Lang.translate(key, text);
    }

    public static String getKey(@Nonnull String text) {
        String key = textKey.get(text);
        if (key == null) {
            key = Lang.makeKey(text);
            textKey.put(text, key);
            if (BeeMod.deobf_folder) {
                Lang.translate(key, text);
            }
        }
        return key;
    }

    private static String makeKey(@Nonnull String text) {
        String t = Lang.stripText(text);
        String key = "BeeMod.text." + t;
        return key;
    }

    @Nonnull
    public static String stripText(@Nonnull String text) {
        int n;
        String t = text.replaceAll("([^A-Za-z\\s])", "").trim();
        if ((t = t.replaceAll("\\s+", ".").toLowerCase()).length() > 32 && (n = t.indexOf(46, 32)) != -1) {
            t = t.substring(0, n);
        }
        return t;
    }

    @Nonnull
    public static String translate(@Nonnull String key, @Nonnull String _default) {
        if (BeeMod.deobf_folder && FMLLaunchHandler.side() == Side.CLIENT && size != existingMCLangMap.size()) {
            existingMCLangMap.putAll(injectingMCLangMap);
            size = existingMCLangMap.size();
        }
        if (I18n.func_94522_b((String)key)) {
            return I18n.func_74838_a((String)key);
        }
        Lang.initKey(key, _default);
        return _default;
    }

    public static String initKey(String key, @Nonnull String _default) {
        if (BeeMod.deobf_folder && FMLLaunchHandler.side() == Side.CLIENT) {
            if (!_default.equals(lang.get(key))) {
                lang.put(key, _default);
                Lang.createMissedFile();
            }
            if (!existingMCLangMap.containsKey(key)) {
                injectingMCLangMap.put(key, _default);
                existingMCLangMap.put(key, _default);
            }
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createMissedFile() {
        PrintWriter out = null;
        try {
            String t;
            File file;
            try {
                file = Lang.getMissedEntriesFile();
                if (file.getParentFile() != null && file.getParentFile().mkdirs()) {
                    BeeMod.logger.info("Making Translation Directory");
                }
                out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                t = null;
                for (Map.Entry<String, String> entry : lang.entrySet()) {
                    int i;
                    String key_prefix = entry.getKey();
                    if (key_prefix.startsWith("careerbees.")) {
                        key_prefix = key_prefix.substring("careerbees.".length());
                    }
                    if ((i = key_prefix.indexOf(46)) < 0) {
                        i = 1;
                    }
                    key_prefix = key_prefix.substring(0, i);
                    if (t != null && !t.equals(key_prefix)) {
                        out.println("");
                    }
                    t = key_prefix;
                    out.println(entry.getKey().toLowerCase() + "=" + entry.getValue());
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
            out = null;
            try {
                file = Lang.getNonTrivialFile();
                if (file.getParentFile() != null && file.getParentFile().mkdirs()) {
                    BeeMod.logger.info("Making Translation Directory");
                }
                out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                t = null;
                for (Map.Entry<String, String> entry : lang.entrySet()) {
                    String value;
                    String key = entry.getKey();
                    if (key.equals(Lang.makeKey(value = entry.getValue()))) continue;
                    int i = key.indexOf(46);
                    if (i < 0) {
                        i = 1;
                    }
                    String s = key.substring(0, i);
                    if (t != null && !t.equals(s)) {
                        out.println("");
                    }
                    t = s;
                    out.println(key.toLowerCase() + "=" + value);
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    @Nonnull
    private static File getMissedEntriesFile() {
        return new File(new File(new File("."), "debug_text"), "missed_en_US.lang");
    }

    @Nonnull
    private static File getNonTrivialFile() {
        return new File(new File(new File("."), "debug_text"), "non_trivial_en_US.lang");
    }

    @Nonnull
    public static TextComponentTranslation chat(@Nonnull String message, Object ... args) {
        String key = Lang.getKey(message);
        if (I18n.func_94522_b((String)key)) {
            return new TextComponentTranslation(key, args);
        }
        return new TextComponentTranslation(message, args);
    }

    @Nonnull
    public static TextComponentTranslation chat(boolean dummy, @Nonnull String key, @Nonnull String _default, Object ... args) {
        return new TextComponentTranslation(Lang.translate(key, _default), args);
    }

    public static String translateArgs(boolean dummy, @Nonnull String key, @Nonnull String _default, Object ... args) {
        String translate = Lang.translate(key, _default);
        try {
            return String.format(translate, args);
        }
        catch (IllegalFormatException err) {
            throw new RuntimeException("Message: \"" + _default + "\" with key : \"" + key + "\" and translation: \"" + translate + "\"", err);
        }
    }

    public static String translateArgs(@Nonnull String message, Object ... args) {
        String translate = Lang.translate(message);
        try {
            return String.format(translate, args);
        }
        catch (IllegalFormatException err) {
            throw new RuntimeException("Message: \"" + message + "\" with key : \"" + Lang.getKey(message) + "\" and translation: \"" + translate + "\"", err);
        }
    }

    public static String getItemName(@Nonnull Block block) {
        return Lang.getItemName(new ItemStack(block));
    }

    public static String getItemName(@Nonnull Item item) {
        return Lang.getItemName(new ItemStack(item));
    }

    public static String getItemName(@Nonnull ItemStack stack) {
        return stack.func_82833_r();
    }

    public static String random(@Nonnull String key) {
        return Lang.random(key, BeeMod.RANDOM);
    }

    public static String random(@Nonnull String key, @Nonnull Random rand) {
        int n = Lang.getNumSelections(key);
        if (n == 0) {
            return I18n.func_74838_a((String)key);
        }
        return I18n.func_74838_a((String)(key + "." + rand.nextInt(n)));
    }

    public static String random(String key, int index) {
        int n = Lang.getNumSelections(key);
        int i = Math.abs(index) % n;
        return I18n.func_74838_a((String)(key + "." + i));
    }

    private static int getNumSelections(String key) {
        int i;
        if (numRandomEntries.containsKey((Object)key)) {
            i = numRandomEntries.get((Object)key);
        } else {
            i = 0;
            while (I18n.func_94522_b((String)(key + "." + i))) {
                ++i;
            }
            numRandomEntries.put((Object)key, ++i);
        }
        return i;
    }

    static {
        numRandomEntries = new TObjectIntHashMap();
        size = 0;
        if (BeeMod.deobf_folder && FMLLaunchHandler.side() == Side.CLIENT) {
            try (FileInputStream fis2 = null;){
                File file = Lang.getMissedEntriesFile();
                fis2 = new FileInputStream(file);
                Lang.readStream(fis2, true);
            }
            catch (FileNotFoundException fis2) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            BeeMod.proxy.run(new ClientRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                @SideOnly(value=Side.CLIENT)
                public void run() {
                    ResourceLocation resourceLocation = new ResourceLocation("careerbees", "lang/en_US.lang");
                    try {
                        IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceLocation);
                        try (InputStream stream = null;){
                            stream = resource.func_110527_b();
                            Lang.readStream(stream, false);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    Lang.createMissedFile();
                }
            });
            LanguageMap instance = (LanguageMap)ObfuscationReflectionHelper.getPrivateValue(LanguageMap.class, null, (String[])new String[]{"instance"});
            existingMCLangMap = (HashMap)ObfuscationReflectionHelper.getPrivateValue(LanguageMap.class, (Object)instance, (String[])new String[]{"languageList"});
            size = existingMCLangMap.size();
            injectingMCLangMap = Maps.newHashMap();
        } else {
            existingMCLangMap = null;
            injectingMCLangMap = Maps.newHashMap();
        }
    }
}

